/*
 * file name : evlHiaStruct.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"evlHiaParse.h"
#include	"evlHiaStruct.h"
#include	"evlPool.h"
#include	"evlUtil.h"
#include	"envldef.h"

/*
 * evlHiaStructNew()
 */
HiaStruct*
evlHiaStructNew(char *my_aid, char *my_logical_name,
             int agent_type, char *in_env, char *substance)
{
  HiaStruct	*op;
  char	*agentsp, *ip;
  int	status, agent_num;

  op = (HiaStruct*)malloc( sizeof(HiaStruct) );
  if ( op == NULL ) return NULL;

  op->lower_agents = NULL;
  op->upper = NULL;
  op->lower_agent_num = 0;
  op->my_env = NULL;
  op->tmp = evlPoolNew(evlHiaStructAgentMatch, evlHiaStructAgentPrint);
  if ( op->tmp == NULL ) return NULL;

  status = evlUtilSetString(&(op->my_aid), my_aid);
  if ( status != 0 ) return NULL;

  status = evlUtilSetString(&(op->my_logical_name), my_logical_name);
  if ( status != 0 ) return NULL;

  op->agent_type = agent_type;

  status = evlUtilSetString(&(op->in_env), in_env);
  if ( status != 0 ) return NULL;

  if ( agent_type == 0 ) {
    status = evlUtilSetString(&((op->substance).full_path), substance);
    if ( status != 0 ) return NULL;
  }
  else if ( agent_type == 1 ) {
    (op->substance).agents = evlPoolNew(evlHiaStructAgentMatch, evlHiaStructAgentPrint);
    if ( (op->substance).agents == NULL ) return NULL;

    agent_num = 0;
    agentsp = strdup(substance);
    ip = strtok(agentsp, "[ ,]");
    if ( ip != NULL ) {
      do {
	agent_num++;
	evlPoolPut((op->substance).agents, ip);
      } while ( ip = strtok(NULL, "[ ,]") );
      op->lower_agent_num = agent_num;
    }
  }

  return op;
}


/*
 * evlHiaStructSetInfo()
 */
void
evlHiaStructSetInfo(HiaStruct *target, EnvlInfo *info)
{
  target->info = info;
}


/*
 * evlHiaStructSetUpper()
 */
void
evlHiaStructSetUpper(HiaStruct *target, HiaStruct *upper)
{
  target->upper = upper;
  return;
}


/*
 * evlHiaStructSetMyEnv()
 */
int
evlHiaStructSetMyEnv(HiaStruct *target, char *env)
{
  int	status;

  status = evlUtilSetString(&(target->my_env), env);
  if ( status != NORMAL ) return EALLOC;

  return NORMAL;
}


/*
 * evlHiaStructSetParam()
 */
void
evlHiaStructSetParam(HiaStruct *target)
{
  target->is_param = 1;
}


/*
 * evlHiaStructPutLowerAgent()
 */
int
evlHiaStructPutLowerAgent(HiaStruct *target, HiaStruct *obj)
{
  if ( target->lower_agents == NULL ) {
    target->lower_agents = evlPoolNew(evlHiaStructMatch, evlHiaStructPrint);
    if ( target->lower_agents == NULL ) return EALLOC;
  }

  if ( evlPoolPut(target->lower_agents, obj) == EALLOC )
    return EALLOC;

  return NORMAL;
}


/*
 * evlHiaStructGetLowerAgent()
 */
HiaStruct*
evlHiaStructGetHiaOfLowerAgent(HiaStruct* target, void *lookfor)
{
  return evlPoolGet(((HiaStruct*)target)->lower_agents, lookfor);
}


/*
 * evlHiaStructGetInfo()
 */
EnvlInfo*
evlHiaStructGetInfo(HiaStruct *target)
{
  return target->info;
}


/*
 * evlHiaStructGetUpper()
 */
HiaStruct*
evlHiaStructGetUpper(HiaStruct *target)
{
  return target->upper;
}


/*
 * evlHiaStructGetMyAid()
 */
char*
evlHiaStructGetMyAid(HiaStruct *target)
{
  return target->my_aid;
}


/*
 * evlHiaStructGetMyLogicalName()
 */
char*
evlHiaStructGetMyLogicalName(HiaStruct *target)
{
  return target->my_logical_name;
}


/*
 * evlHiaStructGetAgentType()
 */
int
evlHiaStructGetAgentType(HiaStruct *target)
{
  return target->agent_type;
}


/*
 * evlHiaStructGetInEnv()
 */
char*
evlHiaStructGetInEnv(HiaStruct *target)
{
  return target->in_env;
}


/*
 * evlHiaStructGetMyEnv()
 */
char*
evlHiaStructGetMyEnv(HiaStruct *target)
{
  return target->my_env;
}


/*
 * evlHiaStructGetSubstanceFullPath()
 */
char*
evlHiaStructGetSubstanceFullPath(HiaStruct *target)
{
  return (target->substance).full_path;
}


/*
 * evlHiaStructGetSubstanceAgents()
 */
Pool*
evlHiaStructGetSubstanceAgents(HiaStruct *target)
{
  return (target->substance).agents;
}


/*
 * evlHiaStructGetLowerAgent()
 */
char*
evlHiaStructGetLowerAgent(HiaStruct *target)
{
  char	*agent;

  if ( target->agent_type != 1 ) return NULL;

  agent = evlPoolGet((target->substance).agents, NULL);
  if ( agent == NULL ) {
    while ( agent = evlPoolGet(target->tmp, NULL) ) {
      evlPoolPut((target->substance).agents, agent);
    }
    return NULL;
  }

  evlPoolPut((target->tmp), agent);
  return agent;
}


/*
 * evlHiaStructIsParam()
 */
int
evlHiaStructIsParam(HiaStruct *target)
{
  return target->is_param;
}


/*
 * evlHiaStructMatch()
 */
int
evlHiaStructMatch(void *target, void *lookfor)
{
  HiaStruct	*hop;

  hop = target;
  if ( !strcmp(hop->my_aid, (char*)lookfor) )
    return TRUE;

  return FALSE;
}


/*
 * evlHiaStructPrint()
 */
void
evlHiaStructPrint(void *target)
{
  HiaStruct	*op;

  op = target;
  if ( target == NULL ) return;

  fprintf(stderr, "\t-- HiaStruct --\n");
  fprintf(stderr, "upper           = %x\n", op->upper);
  fprintf(stderr, "my_aid          = %s\n", op->my_aid);
  fprintf(stderr, "my_logical_name = %s\n", op->my_logical_name);
  fprintf(stderr, "agent_type      = %d\n", op->agent_type);
  fprintf(stderr, "in_env          = %s\n", op->in_env);
  fprintf(stderr, "my_env          = %s\n", op->my_env);
  if ( op->agent_type == 0 ) 
    fprintf(stderr, "substance       = %s\n", (op->substance).full_path);
  else {
    evlPoolPrint((op->substance).agents);
  }
  fprintf(stderr, "lower_agent_num = %d\n", op->lower_agent_num);
  if ( op->lower_agents != NULL ) {
    evlPoolPrint(op->lower_agents);
  }
  fprintf(stderr, "\n");
  return;
}


/*
 * evlHiaStructAgentPrint()
 */
void
evlHiaStructAgentPrint(void *target)
{
  fprintf(stderr, "\tlower_agent_ID = %s\n", (char*)target);
}


/*
 * evlHiaStructAgentMatch()
 */
int
evlHiaStructAgentMatch(void *target, void *lookfor)
{
  if ( !strcmp((char*)target, (char*)lookfor) ) 
    return 1;

  return 0;
}


/*
 * evlHiaStructTreePrint()
 */
void
evlHiaStructTreePrint(HiaStruct *target)
{
  return;
}


/*
 * evlHiaStructMatchForName()
 */
int
evlHiaStructMatchForName(void *target, void *lookfor)
{
  HiaStruct	*hop;

  hop = target;
  if ( !strcmp(hop->my_logical_name, (char*)lookfor) )
    return 1;

  return 0;
}


/*
 * evlHiaStructMatchForType()
 */
int
evlHiaStructMatchForType(void *target, void *lookfor)
{
  HiaStruct	*hop;

  hop = target;
  if ( hop->agent_type == *(int*)(lookfor) )
    return 1;

  return 0;
}


/*
 * evlHiaStructMatchForEnv()
 */
int
evlHiaStructMatchForEnv(void *target, void *lookfor)
{
  HiaStruct	*hop;

  hop = target;
  if ( !strcmp(hop->in_env, (char*)lookfor) )
    return 1;

  return 0;
}

/*** END OF FILE ***/

