/*
 * file name : evlHiaPool.c
 *
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"evlHiaPool.h"
#include	"evlHiaStruct.h"
#include	"evlPool.h"
#include	"envldef.h"


static	Pool	*hia_pool = NULL;
static	Pool	*tmp_pool = NULL;

/*
 * evlHiaPoolPut()
 */
int
evlHiaPoolPut(HiaStruct *target)
{
  if ( hia_pool == NULL ) {
    hia_pool = evlPoolNew(NULL, NULL);
    if ( hia_pool == NULL ) return EALLOC;
  }

  evlPoolPut(hia_pool, target);
  return NORMAL;
}


/*
 * evlHiaPoolGet()
 */
HiaStruct*
evlHiaPoolGet(void)
{
  HiaStruct	*hop;

  if ( tmp_pool == NULL ) {
    tmp_pool = evlPoolNew(NULL, NULL);
    if ( tmp_pool == NULL ) return NULL;
  }

  hop = evlPoolGet(hia_pool, NULL);
  if ( hop == NULL ) {
    while ( hop = evlPoolGet(tmp_pool, NULL) ) 
      evlPoolPut(hia_pool, hop);
    return NULL;
  }
  else {
    evlPoolPut(tmp_pool, hop);
    return hop;
  }
}

/*** END OF FILE ***/
