/*
 * file name : evlHiaParse.c
 *
 */
#include	<stdio.h>
#include	<string.h>
#include	"envldef.h"
#include	"evlHiaParse.h"
#include	"evlHiaStruct.h"
#include	"evlHiaPool.h"
#include	"evlPool.h"

#define READ_BUFLEN	4096

#define	STATE1	1
#define STATE2	2
#define STATE3  3

#define OK	1
#define NO	0

static  HiaStruct	*s_hia_top = NULL;
static	char	s_hia_file_name[256];
static	char	s_top_agent[256];
static	char	s_top_aid[256];

static	char	s_buf[READ_BUFLEN];

static	Pool	*s_hiaP_for_aid;
static	Pool	*s_hiaP_for_name;
static	Pool	*s_hiaP_for_type;
static	Pool	*s_hiaP_for_env;

/*
 * evlHiaParse()
 */
HiaStruct*
evlHiaParse(char *top_agent_name)
{
  FILE	*fp;
  HiaStruct	*upper_hop, *hop;
  EnvlInfo	*infop;
  Pool	*hia_pool;
  char	*field[5], *p, *ip;
  char	*lowers;
  char	*aid;
  int	mode = STATE1, i, top_aid_len = 0;
  int	ok_flag = NO;
  int	cnt;
  int	hia_line_no = 0;


  strcpy(s_hia_file_name, HIA_FILE_NAME1);

  strcpy(s_top_agent, top_agent_name);

  fp = fopen(s_hia_file_name, "r");
  if ( fp == NULL ) {
    fprintf(stderr, "Can not open %s\n", s_hia_file_name);
    exit(0);
  }

  s_hiaP_for_aid = evlPoolNew(evlHiaStructMatch, evlHiaStructPrint);
  if ( s_hiaP_for_aid == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  s_hiaP_for_name = evlPoolNew(evlHiaStructMatchForName, evlHiaStructPrint);
  if ( s_hiaP_for_name == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  s_hiaP_for_type = evlPoolNew(evlHiaStructMatchForType, evlHiaStructPrint);
  if ( s_hiaP_for_type == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  s_hiaP_for_env = evlPoolNew(evlHiaStructMatchForEnv, evlHiaStructPrint);
  if ( s_hiaP_for_env == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  hia_pool = evlPoolNew(evlHiaStructMatch, evlHiaStructPrint);
  if ( hia_pool == NULL ){
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }


  while ( 1 ) {
    p = fgets(s_buf, READ_BUFLEN, fp);
    if ( p == NULL ) {
      if ( feof(fp) != 0 ) break;
    }

    hia_line_no++;

    /* # is key word for comment line, ignore it */
    if ( *p == '#' ) continue;

    /* ignore space line */
    p = s_buf;
    while ( isspace(*p) ) p++;
    if ( *p == NULL ) continue;

    /*  process \newline */
    cnt = 0;
    while ( *p != NULL ) {
      cnt++;
      if ( *p == '\\' ) {
	p = fgets(p, READ_BUFLEN - cnt, fp);
	hia_line_no++;
	continue;
      }
      p++;
    }

    while ( *p != '\n' ) p++;
    *p = NULL;
    
    for ( i = 0; i < 6; i++ ) {
      if ( i == 0 ) ip = strtok(s_buf, " \t");
      else ip = strtok(NULL, " \t");
      field[i] = ip;
    }

    /*** field inspection ***/
    for ( i = 0; i < 6; i++ ) {
      if ( field[i] == NULL ) {
	fprintf(stderr, "error:%d: in helios.hia file\n", hia_line_no);
	return NULL;
      }
    }

    /*** for extracting subordinate of top agent ***/
    if ( mode == STATE1 && !strcmp(field[1], s_top_agent) ) {
      mode = STATE2;
      ok_flag = OK;
      strcpy(s_top_aid, field[0]);
      top_aid_len = strlen(s_top_aid);
    }
    else if ( mode == STATE2 &&
	      strncmp(field[0], s_top_aid, top_aid_len) ) {
      mode = STATE3;
      continue;
    }
    else if ( mode == STATE2 ) {
      /* process! */
    }
    else { /* STATE1 or STATE3 */
      continue;
    }


    if ( !strcmp(field[3], "user") ) {
      s_hia_top = evlHiaStructNew(field[0], field[1], atoi(field[2]), field[3],
			     field[5]);
      if ( s_hia_top == NULL ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlHiaPoolPut(s_hia_top) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_aid, s_hia_top) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_name, s_hia_top) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_type, s_hia_top) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_env, s_hia_top) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      infop = evlEnvlInfoNew();
      if ( infop == NULL ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      evlHiaStructSetInfo(s_hia_top, infop);
    }
    else {
      hop = evlHiaStructNew(field[0], field[1], atoi(field[2]), field[3],
			 field[5]);
      if ( hop == NULL ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(hia_pool, hop) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlHiaPoolPut(hop) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_aid, hop) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_name, hop) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_type, hop) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      if ( evlPoolPut(s_hiaP_for_env, hop) == EALLOC ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      infop = evlEnvlInfoNew();
      if ( infop == NULL ) {
	fprintf(stderr, "memory shortage!\n");
	exit(0);
      }

      evlHiaStructSetInfo(hop, infop);
    }
  }

  if ( ok_flag == NO ) {
    fprintf(stderr, "%s is not in helios.hia file.\n", s_top_agent);
    exit(0);
  }

  construct_hia_structure(hia_pool, s_hia_top);

  return s_hia_top;
}


/*
 * construct_hia_structure()
 */
int
construct_hia_structure(Pool *pool, HiaStruct *hop)
{
  HiaStruct	*lower_hop;
  char		*aid;

  while ( 1 ) {
    aid = evlHiaStructGetLowerAgent(hop);
    if ( aid == NULL ) break;

    lower_hop = evlPoolGet(pool, aid);
    if ( lower_hop == NULL ) return ERROR;
    evlPoolPut(pool, lower_hop);

    evlHiaStructSetUpper(lower_hop, hop);
    if ( evlHiaStructPutLowerAgent(hop, lower_hop) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }

    if ( evlHiaStructGetMyEnv(hop) == NULL ) {
      evlHiaStructSetMyEnv(hop, evlHiaStructGetInEnv(lower_hop));
    }

    if ( evlHiaStructGetAgentType(lower_hop) == 1 ) {
      construct_hia_structure(pool, lower_hop);
    }
  }
  return NORMAL;
}


/*
 * evlHiaParseGetHiaTop()
 */
HiaStruct*
evlHiaParseGetHiaTop(void)
{
  return s_hia_top;
}


/*
 * evlHiaParseGetPoolForAid()
 */
Pool*
evlHiaParseGetPoolForAid(void)
{
  return s_hiaP_for_aid;
}


/*
 * evlHiaParseGetPoolForName()
 */
Pool*
evlHiaParseGetPoolForName(void)
{
  return s_hiaP_for_name;
}


/*
 * evlHiaParseGetPoolForType()
 */
Pool*
evlHiaParseGetPoolForType(void)
{
  return s_hiaP_for_type;
}


/*
 * evlHiaParseGetPoolForEnv()
 */
Pool*
evlHiaParseGetPoolForEnv(void)
{
  return s_hiaP_for_env;
}

/*** END OF FILE ***/

