/*
 * file name : evlErrCheckObj.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"evlErrCheckObj.h"
#include	"evlUtil.h"
#include	"envldef.h"


/*
 * evlErrCheckObjNew()
 */
ErrCheckObj*
evlErrCheckObjNew(char *name, char *environment)
{
  ErrCheckObj	*op;
  int		status;

  op = (ErrCheckObj*)malloc( sizeof(ErrCheckObj) );
  if ( op == NULL ) return NULL;

  status = evlUtilSetString(&(op->name), name);
  if ( status != NORMAL ) return NULL;

  status = evlUtilSetString(&(op->environment), environment);
  if ( status != NORMAL ) return NULL;

  return op;
}


/*
 * evlErrCheckObjGetEnv()
 */
char*
evlErrCheckObjGetEnv(ErrCheckObj *target)
{
  return target->environment;
}


/*
 * evlErrCheckObjMatch()
 */
int
evlErrCheckObjMatch(void *target, void *lookfor)
{
  ErrCheckObj	*op;

  op = target;
  if ( !strcmp(op->name, (char*)lookfor) )
    return TRUE;

  return FALSE;
}


/*
 * evlErrCheckObjPrint()
 */
void
evlErrCheckObjPrint(void *target)
{
  ErrCheckObj	*op;

  if ( target == NULL ) return;
  op = target;
  fprintf(stderr, "name        = %s\n", op->name);
  fprintf(stderr, "environment = %s\n", op->environment);
  return;
}

/*** END OF FILE ***/
