/*
 * file name : evlEnvlInfo.h
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"evlEnvlInfo.h"
#include	"evlPool.h"
#include	"envldef.h"


/*
 * evlEnvlInfoNew()
 */
EnvlInfo*
evlEnvlInfoNew(void)
{
  EnvlInfo	*op;

  op = (EnvlInfo *)malloc( sizeof(EnvlInfo) );
  if ( op == NULL ) return NULL;

  op->add_to_agent_dir = NULL;
  op->agent_dir_tmp = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
  if ( op->agent_dir_tmp == NULL ) return NULL;

  op->add_to_function_dir = NULL;
  op->function_dir_tmp = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
  if ( op->function_dir_tmp == NULL ) return NULL;

  op->add_to_method_dir = NULL;
  op->method_dir_tmp = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
  if ( op->method_dir_tmp == NULL ) return NULL;

  op->add_to_global_cstr = NULL;
  op->global_cstr_tmp = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
  if ( op->global_cstr_tmp == NULL ) return NULL;

  op->templates = NULL;
  op->templates_tmp = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
  if ( op->templates_tmp == NULL ) return NULL;

  return op;
}


/*
 * evlEnvlInfoPutAgentDir()
 */
int
evlEnvlInfoPutAgentDir(EnvlInfo *target, char *cmd)
{
  if ( target->add_to_agent_dir == NULL ) {
    target->add_to_agent_dir = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
    if ( target->add_to_agent_dir == NULL ) return EALLOC;
  }

  evlPoolPut(target->add_to_agent_dir, cmd);
  return NORMAL;
}


/*
 * evlEnvlInfoPutFunctionDir()
 */
int
evlEnvlInfoPutFunctionDir(EnvlInfo *target, char *cmd)
{
  if ( target->add_to_function_dir == NULL ) {
    target->add_to_function_dir = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
    if ( target->add_to_function_dir == NULL ) return EALLOC;
  }

  evlPoolPut(target->add_to_function_dir, cmd);
  return NORMAL;
}


/*
 * evlEnvlInfoPutMethodDir()
 */
int
evlEnvlInfoPutMethodDir(EnvlInfo *target, char *cmd)
{
  if ( target->add_to_method_dir == NULL ) {
    target->add_to_method_dir = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
    if ( target->add_to_method_dir == NULL ) return EALLOC;
  }

  evlPoolPut(target->add_to_method_dir, cmd);
  return NORMAL;
}


/*
 * evlEnvlInfoPutGlobalCstr()
 */
int
evlEnvlInfoPutGlobalCstr(EnvlInfo *target, char *cmd)
{
  if ( target->add_to_global_cstr == NULL ) {
    target->add_to_global_cstr = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
    if ( target->add_to_global_cstr == NULL ) return EALLOC;
  }

  evlPoolPut(target->add_to_global_cstr, cmd);
  return NORMAL;
}


/*
 * evlEnvlInfoPutTemplate()
 */
int
evlEnvlInfoPutTemplate(EnvlInfo *target, char *name)
{
  if ( target->templates == NULL ) {
    target->templates = evlPoolNew(NULL, evlEnvlInfoInternalPrint);
    if ( target->templates == NULL ) return EALLOC;
  }

  evlPoolPut(target->templates, name);
  return NORMAL;
}


/*
 * evlEnvlInfoGetAgentDirCmd()
 */
char*
evlEnvlInfoGetAgentDirCmd(EnvlInfo *target)
{
  char 	*cmd;

  if ( target->add_to_agent_dir == NULL )
    return NULL;

  cmd = evlPoolGet(target->add_to_agent_dir, NULL);
  if ( cmd == NULL ) {
    while ( cmd = evlPoolGet(target->agent_dir_tmp, NULL ) )
      evlPoolPut(target->add_to_agent_dir, cmd);
    return NULL;
  }
  else {
    evlPoolPut(target->agent_dir_tmp, cmd);
    return cmd;
  }
}


/*
 * evlEnvlInfoGetFunctionDirCmd()
 */
char*
evlEnvlInfoGetFunctionDirCmd(EnvlInfo *target)
{
  char 	*cmd;

  if ( target->add_to_function_dir == NULL )
    return NULL;

  cmd = evlPoolGet(target->add_to_function_dir, NULL);
  if ( cmd == NULL ) {
    while ( cmd = evlPoolGet(target->function_dir_tmp, NULL ) )
      evlPoolPut(target->add_to_function_dir, cmd);
    return NULL;
  }
  else {
    evlPoolPut(target->function_dir_tmp, cmd);
    return cmd;
  }
}


/*
 * evlEnvlInfoGetMethodDirCmd()
 */
char*
evlEnvlInfoGetMethodDirCmd(EnvlInfo *target)
{
  char 	*cmd;

  if ( target->add_to_method_dir == NULL ) 
    return NULL;

  cmd = evlPoolGet(target->add_to_method_dir, NULL);
  if ( cmd == NULL ) {
    while ( cmd = evlPoolGet(target->method_dir_tmp, NULL ) )
      evlPoolPut(target->add_to_method_dir, cmd);
    return NULL;
  }
  else {
    evlPoolPut(target->method_dir_tmp, cmd);
    return cmd;
  }
}


/*
 * evlEnvlInfoGetGlobalCstrCmd()
 */
char*
evlEnvlInfoGetGlobalCstrCmd(EnvlInfo *target)
{
  char 	*cmd;

  if ( target->add_to_global_cstr == NULL ) 
    return NULL;

  cmd = evlPoolGet(target->add_to_global_cstr, NULL);
  if ( cmd == NULL ) {
    while ( cmd = evlPoolGet(target->global_cstr_tmp, NULL ) )
      evlPoolPut(target->add_to_global_cstr, cmd);
    return NULL;
  }
  else {
    evlPoolPut(target->global_cstr_tmp, cmd);
    return cmd;
  }
}


/*
 * evlEnvlInfoGetTemplateCmd()
 */
char*
evlEnvlInfoGetTemplateCmd(EnvlInfo *target)
{
  char 	*name;

  if ( target->templates == NULL )
    return NULL;

  name = evlPoolGet(target->templates, NULL);
  if ( name == NULL ) {
    while ( name = evlPoolGet(target->templates_tmp, NULL ) )
      evlPoolPut(target->templates, name);
    return NULL;
  }
  else {
    evlPoolPut(target->templates_tmp, name);
    return name;
  }
}


/*
 * evlEnvlInfoPrint()
 */
void
evlEnvlInfoPrint(void *target)
{
  EnvlInfo	*op;

  op = target;
  if ( op == NULL ) return;

  fprintf(stderr, "-- EnvlInfo --\n");
  evlPoolPrint(op->add_to_agent_dir);
  evlPoolPrint(op->add_to_function_dir);
  evlPoolPrint(op->add_to_method_dir);
  evlPoolPrint(op->add_to_global_cstr);
  evlPoolPrint(op->templates);

  return;
}


/*
 * evlEnvlInfoInternalPrint()
 */
void
evlEnvlInfoInternalPrint(void *target)
{
  char	*op;

  if ( op == NULL ) return;

  fprintf(stderr, "cmd = %s\n", op);
  return;
}

/*** END OF FILE ***/
