/*
 * file name : evlCreateSrc.c
 *
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include 	<unistd.h>
#include 	<sys/stat.h>
#include	"evlCreateSrc.h"
#include	"evlHiaParse.h"
#include	"evlHiaStruct.h"
#include	"evlEnvlInfo.h"
#include	"envldef.h"


/*
 * evlCreateSrcForAgent()
 */
int
evlCreateSrcForAgent(HiaStruct *bottom_hop)
{
  FILE		*fp;
  HiaStruct	*stack[256], *upper, *current;
  EnvlInfo	*info;
  char		*env_name, *env_id, *agent_proc_id;
  char		*agent_name;
  char		file_name[256], file_name1[256];
  char		*cmd;
  int		stack_cnt = 0, prm_flag = 0;
  int		permission, amode, mode, status;
  int		i;

  prm_flag = evlHiaStructIsParam(bottom_hop);

  agent_proc_id = evlHiaStructGetMyAid(bottom_hop);
  agent_name = evlHiaStructGetMyLogicalName(bottom_hop);

  current = bottom_hop;

  while ( 1 ) {
    upper = evlHiaStructGetUpper(current);

    stack[stack_cnt] = upper;
    stack_cnt++;

    if ( !strcmp("user", evlHiaStructGetInEnv(upper)) )
      break;

    current = upper;
  }

  strcpy(file_name, "../cmd_");
  strcat(file_name, agent_name);

  amode = F_OK;
  permission = access(file_name, amode);
  if ( permission != 0 ) {
    mode = S_IRWXU | S_IRWXG | S_IRWXO;
    status = mkdir(file_name, mode);
    if ( status != 0 ) {
      fprintf(stderr, "Can not make %s directry.\n", file_name);
      exit(0);
    }
  }

  strcat(file_name, "/");
  strcat(file_name, agent_name);
  strcat(file_name, "_env_.c");

  strcpy(file_name1, agent_name);
  strcat(file_name1, "_env_.c");

  fp = fopen(file_name, "w");
  if ( fp == NULL ) {
    fprintf(stderr, "Can not open %s\n", file_name);
    exit(0);
  }

  fprintf(fp, "/*\n * file name : %s\n *\n */\n\n", file_name1);
  fprintf(fp, "#include		<stdio.h>\n");
  fprintf(fp, "#include		<helios/envdef.h>\n");
  fprintf(fp, "#include		<helios/eInit.h>\n");
  fprintf(fp, "#include		<helios/Henv.h>\n");
  fprintf(fp, "#include		<helios/HeAgSv.h>\n");
  fprintf(fp, "#include		<helios/HeAgSvDef.h>\n");
  fprintf(fp, "#include		<helios/HeAgSvFun.h>\n\n");
  fprintf(fp, "static	int	e_init_agent_server(void);\n");
  fprintf(fp, "static	int	e_init_global_pool(void);\n\n");
  fprintf(fp, "int\n");
  fprintf(fp, "init_environment(int argc, char **argv)\n");
  fprintf(fp, "{\n");
  fprintf(fp, "  e_init_agent_server();\n");
  fprintf(fp, "  e_init_global_pool();\n\n");
  fprintf(fp, "  eInitArg(argc, argv);\n");
  fprintf(fp, "  eInitStart();\n");

  for ( i = stack_cnt-1; i >= 0; i-- ) {
    current = stack[i];
    env_name = evlHiaStructGetMyEnv(current);
    env_id = evlHiaStructGetMyAid(current);

    fprintf(fp, "  eInitSetEnv(\"%s\", \"%s\");\n",
	    env_name, env_id);
    if ( i == 0 && prm_flag == 0 ) {
      fprintf(fp, "  eInitMyAid(\"%s\");\n", agent_proc_id);
    }
  }

  if ( prm_flag == 1 ) {
    agent_proc_id = evlHiaStructGetMyAid(bottom_hop);
    agent_name = evlHiaStructGetMyLogicalName(bottom_hop);

    fprintf(fp, "  eInitSetEnv(\"%s_env\", \"%s\");\n",
	    agent_name, agent_proc_id);
  }

  for ( i = stack_cnt-1; i >= 0; i-- ) {
    current = stack[i];
    info = evlHiaStructGetInfo(current);
    while ( cmd = evlEnvlInfoGetTemplateCmd(info) ) {
      fprintf(fp, "  %s\n", cmd);
    }
  }

  fprintf(fp, "  eInitEnd();\n");
  fprintf(fp, "  return NORMAL;\n");
  fprintf(fp, "}\n\n\n");

  fprintf(fp, "static\n");
  fprintf(fp, "int\n");
  fprintf(fp, "e_init_agent_server(void)\n");
  fprintf(fp, "{\n");

  for ( i = stack_cnt-1; i >= 0; i-- ) {
    current = stack[i];
    info = evlHiaStructGetInfo(current);
    while ( cmd = evlEnvlInfoGetAgentDirCmd(info) ) {
      fprintf(fp, "  %s\n", cmd);
    }
  }
  fprintf(fp, "\n");

  for ( i = stack_cnt-1; i >= 0; i-- ) {
    current = stack[i];
    info = evlHiaStructGetInfo(current);
    while ( cmd = evlEnvlInfoGetFunctionDirCmd(info) ) {
      fprintf(fp, "  %s\n", cmd);
    }
  }
  fprintf(fp, "\n");

  for ( i = stack_cnt-1; i >= 0; i-- ) {
    current = stack[i];
    info = evlHiaStructGetInfo(current);
    while ( cmd = evlEnvlInfoGetMethodDirCmd(info) ) {
      fprintf(fp, "  %s\n", cmd);
    }
  }
  fprintf(fp, "  return NORMAL;\n");
  fprintf(fp, "}\n\n\n");

  fprintf(fp, "static\n");
  fprintf(fp, "int\n");
  fprintf(fp, "e_init_global_pool(void)\n");
  fprintf(fp, "{\n");

  for ( i = stack_cnt-1; i >= 0; i-- ) {
    current = stack[i];
    info = evlHiaStructGetInfo(current);
    while ( cmd = evlEnvlInfoGetGlobalCstrCmd(info) ) {
      fprintf(fp, "  %s\n", cmd);
    }
  }
  fprintf(fp, "  return NORMAL;\n");
  fprintf(fp, "}\n\n");
  fprintf(fp, "/*** END OF FILE ***/\n");

  fclose(fp);
  return NORMAL;
}

/*** END OF FILE ***/
