%{
 /*** definition section ***/
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"envl.h"
#include	"evlHiaParse.h"
#include	"evlHiaStruct.h"
#include	"evlHiaPool.h"
#include	"evlEnvlInfo.h"
#include	"evlPool.h"
#include	"evlErrCheckObj.h"
#include	"envldef.h"

extern	int	current_state;
extern	int	lineno;

Pool	*pool_for_check;

HiaStruct	*current_hop;
char	*current_env_name = NULL;
char	*current_env_id = NULL;

char	*function_name1 = NULL;
char	*function_name2 = NULL;
char	*agent_name2 = NULL;
char	*old_method = NULL;
char	*new_method = NULL;

char	*common_type_name_p = NULL;
char	*constant_name_p = NULL;
char	*expression_p = NULL;
char	*template_name = NULL;

char	*buf[256];

int	lineno_of_name_in_agdir;
int	lineno_of_name_in_funcdir;
int	lineno_of_name_in_methdir;
int	lineno_of_template_name;
%}

%union {
  char	*string;
}

%token <string> STRING
%token <string> AND_ENVIRONMENT
%token <string> AND_COMMON_TYPE
%token <string> AND_AGENT_DIR 
%token <string> AND_FUNCTION_DIR
%token <string> AND_METHOD_DIR
%token <string> AND_GLOBAL_CONST
%token <string> SUBSTITUTION_SYMBOL
%token <string> AND_TEMPLATES
%%
envl_statement		: environment_definition
	                  common_type_file
          	          agent_directory
                          other_statements
                        ;


environment_definition	: AND_ENVIRONMENT environment_name ';'
                        ;

environment_name	: STRING 
                          { 
                           #ifdef DEBUG
                            printf("environment = %s\n", $1);
                            printf("current_state = %d\n",
				   current_state);
                           #endif
			    if ( strcmp($1, current_env_name) ) {
			      fprintf(stderr,
			      "Warning! %s.evl:%d: %s is different from file name.\n",
				      current_env_name, lineno,
				      current_env_name);
			    }
			   }
                        ;

common_type_file	: AND_COMMON_TYPE file_name ';'
                        ;

file_name		: STRING 
                          {
                           #ifdef DEBUG
                            printf("file_name = %s\n", $1);
                            printf("current_state = %d\n", current_state);
                           #endif
			  }
                        ;

agent_directory		: AND_AGENT_DIR agent_name_list ';'
                        ;

agent_name_list		: agent_name
               		| agent_name_list ',' agent_name
                        ;

agent_name		: STRING 
                          { 
                           #ifdef DEBUG
                            printf("agent_name = %s\n", $1);
                           #endif
                            if ( current_state == AGENT_DIR_STATE ) {
			      lineno_of_name_in_agdir = lineno;
                              set_agent_dir_cmd($1);
			    }
			    else if ( current_state ==
  				          FUNCTION_DIR_STATE ) {
			      lineno_of_name_in_funcdir = lineno;
			      set_function_dir_cmd(function_name1, $1);
			    }
			  }
                        ;

other_statements	: 
                         /* empty */
                        | other_statements function_directory
                        | other_statements method_directory
                        | other_statements agent_templates
	                | other_statements global_constant
                        ;


function_directory	: AND_FUNCTION_DIR function_couple_list ';' 
                        ;

function_couple_list	: function_couple
                    	| function_couple_list ',' function_couple 
                        ;

function_couple		: '{' function_name1 ',' agent_name_list '}' 
                        ;

function_name1		: STRING 
                          { 
                           #ifdef DEBUG
                            printf("function_name1 = %s\n", $1);
                           #endif
			    function_name1 = strdup($1);
 			  }
                        ;

method_directory	: AND_METHOD_DIR method_couple_list ';'
                        ;

method_couple_list	: method_couple
	                | method_couple_list ',' method_couple 
                        ;

method_couple		: '{' old_method ',' new_method_list '}' 
                        ;

old_method		: '{' function_name2 ',' old_method_name '}' 
                        ;

function_name2		: STRING
                          { 
                           #ifdef DEBUG
                            printf("function_name2 = %s\n", $1);
                           #endif
			    function_name2 = strdup($1);
 			  }
                        ;

old_method_name		: STRING 
                          { 
                           #ifdef DEBUG
                            printf("old_method_name = %s\n", $1);
                           #endif
			    old_method = strdup($1);
 			  }
                        ;

new_method_list		: new_method
              		| new_method_list ',' new_method 
                        ;

new_method		: '{' agent_name2 ',' new_method_name '}'
                        ;

agent_name2		: STRING 
                          {
                           #ifdef DEBUG
                            printf("agent_name2 = %s\n", $1);
                           #endif
			    lineno_of_name_in_methdir = lineno;
			    agent_name2 = strdup($1);
 			  }
                        ;

new_method_name		: STRING 
                          { 
                           #ifdef DEBUG
                            printf("new_method_name = %s\n", $1);
                           #endif
			    new_method = strdup($1);
			    set_method_dir_cmd(function_name2,
					       old_method,
					       agent_name2, 
					       new_method);
 			  }
                        ;

global_constant		: AND_GLOBAL_CONST constant_definition_list ';' 
                        ;

constant_definition_list: constant_definition
	                | constant_definition_list ',' constant_definition
                        ;

constant_definition	: common_type_name constant_name 
	                  SUBSTITUTION_SYMBOL expression 
                        ;

common_type_name	: STRING 
                          { 
                           #ifdef DEBUG
                            printf("common_type_name = %s\n", $1);
                           #endif
			    common_type_name_p = strdup($1);
 			  }
                        ;

constant_name		: STRING 
                          { 
                           #ifdef DEBUG
                            printf("constant_name = %s\n", $1);
                           #endif
			    constant_name_p = strdup($1);
 			  }
                        ;

expression		: STRING 
                          { 
                           #ifdef DEBUG
                            printf("expression = %s\n", $1);
                           #endif
			    expression_p = strdup($1);
			    set_gl_const_cmd(common_type_name_p,
					     constant_name_p,
					     expression_p);
 			  }
                        ;

agent_templates		: AND_TEMPLATES template_name_list ';'
                        ;

template_name_list	: template_name
                  	| template_name_list ',' template_name 
                        ;

template_name		: STRING 
                          { 
                           #ifdef DEBUG
                            printf("template_name = %s\n", $1);
                           #endif
			    lineno_of_template_name = lineno;
			    template_name = strdup($1);
			    set_param($1);
 			  }
                        ;

%%

extern	FILE	*yyin;

int
main(int argc, char **argv)
{
  HiaStruct	*hia_top;

  if ( argc != 2 ) {
    fprintf(stderr, "Usage: cmd top_agent_name\n");
    exit(0);
  }

  hia_top = evlHiaParse(argv[1]);
  if ( hia_top == NULL ) exit(0);

#ifdef DEBUG
  fprintf(stderr, "finished HiaParse()\n");
#endif

  /*** for checking directory ***/
  pool_for_check = evlPoolNew(evlErrCheckObjMatch, evlErrCheckObjPrint);
  if ( pool_for_check == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  /******************************/

  while ( current_hop = evlHiaPoolGet() ) {
    if ( evlHiaStructGetAgentType(current_hop) == 0 ) continue;
    current_env_name = evlHiaStructGetMyEnv(current_hop);
    current_env_id = evlHiaStructGetMyAid(current_hop);

#ifdef DEBUG
    fprintf(stderr, "current_env_name = %s\n", current_env_name);
#endif

    lineno = 1;
    LexSetNextFile(current_env_name);
    yyparse();
  }

  while ( current_hop = evlHiaPoolGet() ) {
    if ( evlHiaStructGetAgentType(current_hop) != 0 ) continue;
    
    evlCreateSrcForAgent(current_hop);
  }

  return NORMAL;
}


int
set_agent_dir_cmd(char *agent_name)
{
  Pool		*pool;
  HiaStruct	*op, *upper, *check;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, agent_name);
  if ( err_op != NULL &&
      !strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is multiple defined\n",
	    current_env_name, lineno_of_name_in_agdir, agent_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else if ( err_op != NULL ) {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  /******************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, agent_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_name_in_agdir, agent_name);
    return ERROR;
  }

  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  /*** for checking directory ***/
  if ( strcmp(current_env_name, evlHiaStructGetInEnv(op)) ) {
    fprintf(stderr,
	    "Warning! %s.evl:%d: \"%s\" is conflicting between %s.evl and helios.hia file.\n",
	    current_env_name, lineno_of_name_in_agdir, agent_name, current_env_name);
    return ERROR;
  }
  /******************************/

  /*** for checking directory ***/
  err_op = evlErrCheckObjNew(agent_name, current_env_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  /******************************/

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

#ifdef DEBUG
  fprintf(stderr, "upper = %s\n", HiaStructGetMyEnv(upper));
#endif

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf, "add_to_agent_directory(\"%s\", \"%s\", \"%s\");",
	  current_env_id, agent_name, aid);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutAgentDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_function_dir_cmd(char *function, char *agent_name)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, agent_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_funcdir, agent_name);
    fprintf(stderr, "\tif \"%s\" is template_agent, ignore this warning message.\n",
	    agent_name);
  }
  else if ( strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_funcdir, agent_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  /******************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, agent_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_name_in_funcdir, agent_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf, "add_to_function_directory(\"%s\", \"%s\", \"%s\");",
	  current_env_id, function, aid);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutFunctionDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_method_dir_cmd(char *function, char *old_method,
		   char *agent_name, char *new_method)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, agent_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_methdir, agent_name);
    fprintf(stderr, "\tif \"%s\" is template_agent, ignore this warning message.\n",
	    agent_name);
  }
  else if ( strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_methdir, agent_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  /********************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, agent_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_name_in_methdir, agent_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf,
	  "add_to_method_directory(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\");",
	  current_env_id, function, old_method, aid, new_method);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutMethodDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_param(char *template_name)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, template_name);
  if ( err_op != NULL && 
       !strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr,
	    "Warning! %s.evl:%d: \"%s\" of template is multiple defined.\n",
	    current_env_name, lineno_of_template_name, template_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else if ( err_op != NULL ) {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }

  err_op = evlErrCheckObjNew(template_name, current_env_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "memory shortage!\n");
  }
  if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  /********************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, template_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_template_name, template_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  evlHiaStructSetParam(op);

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf, "add_to_agent_directory(\"%s\", \"%s\", \"%s\");",
	  current_env_id, template_name, aid);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutAgentDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  sprintf(tmpbuf, "eInitSetPrmInfo(\"%s\", \"%s\", \"%s\");",
	  current_env_id, aid, template_name);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutTemplate(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_gl_const_cmd(common_type_name, constant_name, expression)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*cmd;
  char		tmpbuf[512];

  pool = evlHiaParseGetPoolForEnv();
  op = evlPoolGet(pool, current_env_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warnig! : \"%s\" is not in helios.hia file\n", current_env_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  sprintf(tmpbuf, "add_to_global_pool(\"%s\", \"%s\", \"%s\", \"%s\");",
	  current_env_id, common_type_name_p,
	  constant_name_p, expression_p);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutGlobalCstr(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}

/*** END OF FILE ***/

