%{
  /* definition section */
#include	<stdio.h>
#include	"y.tab.h"
#include	"envl.h"

extern	char	*current_env_name;

int	current_state = INITIAL_STATE;
int	lineno = 1;

%}
%%

[\t ]+ ;

&environment		{ 
                          yylval.string = yytext;
                          current_state = ENVIRONMENT_STATE;
                          return AND_ENVIRONMENT; }

&common_type		{ 
                          yylval.string = yytext;
                          current_state = COMMON_TYPE_STATE;
                          return AND_COMMON_TYPE; }

&agent_dir 		{ 
                          yylval.string = yytext;
                          current_state = AGENT_DIR_STATE;
                          return AND_AGENT_DIR; }

&function_dir		{ 
                          yylval.string = yytext;
                          current_state = FUNCTION_DIR_STATE;
                          return AND_FUNCTION_DIR; }

&method_dir 		{ 
                          yylval.string = yytext;
                          current_state = METHOD_DIR_STATE;
                          return AND_METHOD_DIR; }

&agent_templates	{ 
                          yylval.string = yytext;
                          current_state = AGENT_TEMPLATES_STATE;
                          return AND_TEMPLATES; }

&global_cstr            { 
                          yylval.string = yytext;
                          current_state = GLOBAL_CSTR_STATE;
                          return AND_GLOBAL_CONST; }


";"                     { 
                          return ';' ; }

"," 			{ 
                          return ',' ; }

\{                      { 
                          return '{' ; }

\}                      { 
                          return '}' ; }

:=                      { 
                          yylval.string = yytext;
                          return SUBSTITUTION_SYMBOL ; }

[-a-zA-Z0-9._+=/*]+     { 
                             yylval.string = yytext;
 			     return STRING; }

\n			{ lineno++; }

. 	                { ECHO; }
%%

void
LexSetNextFile(char *env_name)
{
  FILE	*fp;
  char	file_name[256];

  strcpy(file_name, env_name);
  strcat(file_name, ".evl");

  fp = fopen(file_name, "r");
  if ( fp == NULL ) {
    fprintf(stderr, "Can not open %s\n", file_name);
    exit(0);
  }

  yyin = fp;

  return;
}

void
yyerror(char *msg)
{
  fprintf(stderr, "%s.evl:%d: %s  %s\n",
		  current_env_name, lineno, msg, yytext);
}

/*** END OF FILE ***/
