/* ----------------------------------------------------
                  H E L I O S  ver1.0

          <<< $B%(!<%8%'%s%H%G%#%l%/%H%j%W!<%k(B >>>

                By H.Kijima [IMS]  1994/6

                   FILE : ags_pool.c
      
      - - - - - - - - - - - - - - - - - - - - - - - -

              Public Functions and Subroutines

     (1) void add_to_agent_directory();
         $B%(!<%8%'%s%H%G%#%l%/%H%j$K%G!<%?$rEPO?(B

     (2) void add_to_function_directory();
         $B%U%!%s%/%7%g%s%G%#%l%/%H%j$K%G!<%?$rEPO?(B

     (3) void add_to_method_directory();
         $B%a%=%C%I%G%#%l%/%H%j$K%G!<%?$rEPO?(B

     (4) void quit_agent_server();
         $B%(!<%8%'%s%H%5!<%P$N=*N;(B

     (5) void dump_agent_server();
         $B%G%#%l%/%H%jFbMF$N%@%s%W(B

     (6) void ags_trace();
         trace on

     (7) void ags_notrace();
         trace off

   ----------------------------------------------------        
*/

#include <stdio.h>
#include <helios/HeAgSvDef.h>
#include <helios/HeAgSv.h>


/* Prototype Difinition */
void add_to_agent_directory();
void add_to_function_directory();
void add_to_method_directory();
int  H_ch_exist_env();
int  H_ch_exist_mtd_data();
void quit_agent_server();
void H_quit_agent_directory();
void H_quit_function_directory();
void H_quit_method_directory();
void H_quit_method_directory2();
void H_free_agent_dir_link();
void H_free_func_dir_link();
void H_free_method_dir_link();
void dump_agent_server();
void H_dump_agent_directory();
void H_dump_function_directory();
void H_dump_method_directory();
void H_dump_method_directory2();

void ags_trace();
void ags_notrace();

CHARs *H_ags_gen_cell();
CHARs *H_ags_cp_chars();
CHARs *H_ags_rcp_chars();
void H_ags_cell_print();
void H_ags_free();

extern char *H_malloc_str();

/* extern void debug_dprint(); */

H_AGS *H_Envs[H_ENV_N];      /* $B4D6-(BObj$B$rJ]4I$9$kG[Ns(B */
char  *H_EnvNames[H_ENV_N];  /* $B4D6-L>$rJ]4I$9$kG[Ns(B */

int H_EnvC    = 0;           /* $B4D6-?t(B */
int AgsInitSt = H_SUC;       /* $B%(!<%8%'%s%H%5!<%P=i4|2=7k2L(B */

int H_AgsTraceSt = H_OFF;     /* $B%H%l!<%9%b!<%I(B */
int H_AgsConneSt = H_OFF;    /* $B0[<oJ,;66(D4LdBj2r7h7O$K@\B3(B */


/* $B%(!<%8%'%s%H%G%#%l%/%H%j$K%(!<%8%'%s%HO@M}L>$H%(!<%8%'%s%H(BID$B$r(B
 $B!!EPO?$9$k!#(B 
   [I/O]
   +Env:       $B4D6-$r4^$`J#9g%(!<%8%'%s%H$N%(!<%8%'%s%H(BID
   +AgentName: $B%(!<%8%'%s%HO@M}L>(B 
   -AgentID$B!!!!%(!<%8%'%s%H(BID
   */
void add_to_agent_directory(Env, AgentName, AgentID)
char *Env, *AgentName, *AgentID;
{
    H_AGS    *e;
    H_AG_DIR *p, *q;
    char     *s;
    int      index;
    int      state;
    
    /* $B%G%#%l%/%H%j=i4|2==hM}Cf$K%(%i!<$,5/$-$F$$$J$1$l$P(B */
    if ( AgsInitSt != H_SUC ) return;

    /* $B4{$K4D6-L>$,EPO?$5$l$F$$$l$P(BIndex$B$r<hF@(B */
    state = H_ch_exist_env(Env,&index);
    if (state == H_TRUE) {
        q = H_Envs[index] -> agent_dir;

    /* $BL$EPO?$G$"$l$P(B */
    } else {
        if ( NULL !=  (s = H_malloc_str(Env))) {

	    /* $B4D6-L>$rEPO?(B */
            strcpy(s, Env);
            H_EnvNames[H_EnvC] = s;
            if ( NULL != (e = (H_AGS *) malloc( sizeof(H_AGS)))) {

 	        /* $B$=$N4D6-L>$KBP1~$9$k9=B$BN$rMQ0U(B */
                e->method_dir = NULL;
                e->func_dir = NULL;
                e->global_pool = NULL;
                e->ags_pont = NULL;
		e->p_dir = NULL;
                H_Envs[H_EnvC] = e;
                H_EnvC++;
	    } else {
 	        AgsInitSt = H_MEMERR;
                return;
	    }
	} else {
	    AgsInitSt = H_MEMERR;
            return;
        }
    }
    /* $BEPO?(B */
    if ( NULL != (p = (H_AG_DIR *) (malloc( sizeof( H_AG_DIR ) )))) {
        if ( NULL !=  (s = H_malloc_str(AgentName))) {
            strcpy(s, AgentName);
            p->agent_name = s;
            if ( NULL !=  (s = H_malloc_str(AgentID))) {
                strcpy(s, AgentID);
                p->agent_id = s;
                if (state != H_TRUE) {
                      p -> next = NULL;
                      e->agent_dir = p;
                 } else {
                      p -> next = q;
                      H_Envs[index]->agent_dir = p;
	         }
                 AgsInitSt = H_SUC;
	      }
	  }
      }
  }


/* $B%U%!%s%/%7%g%s%G%#%l%/%H%j$K5!G=L>$H%(!<%8%'%s%H(BID$B$r(B
 $B!!EPO?$9$k!#(B
   [I/O]
     +Env      : $B4D6-$r4^$`J#9g%(!<%8%'%s%H$N(BID
     +Function : $B5!G=L>(B
     -AgentID  : $B%(!<%8%'%s%H(BID
*/
void add_to_function_directory(Env, Function, AgentID)
char *Env, *Function, *AgentID;
{
    H_AGS      *e;
    H_FUNC_DIR *p, *q;
    char       *s;
    int        index;
    int        state;

/*    H_ags_dprint("%s \n","In add-function-dir"); */

    if ( AgsInitSt != H_SUC ) return;

    state = H_ch_exist_env(Env,&index);
    if (state == H_TRUE) {
        q = H_Envs[index]->func_dir;

    } else {            
        if ( NULL !=  (s = H_malloc_str(Env))) {
            strcpy(s, Env);
            H_EnvNames[H_EnvC] = s;

            if ( NULL != (e = (H_AGS *) malloc( sizeof(H_AGS)))) {
                e->method_dir = NULL;
                e->agent_dir = NULL;
                e->global_pool = NULL;
                e->ags_pont = NULL;
		e->p_dir = NULL;
                H_Envs[H_EnvC] =e;
                H_EnvC++;

	     } else {
                AgsInitSt = H_MEMERR;
		return;
	    }
         } else {
            AgsInitSt = H_MEMERR;
	    return;
	 }
    }

    /* $BEPO?(B */
    if ( NULL != (p = (H_FUNC_DIR *) (malloc( sizeof( H_FUNC_DIR ) )))) {
        if ( NULL !=  (s = H_malloc_str(Function))) {
            strcpy(s, Function);
            p->func_name = s;

	    if ( NULL !=  (s = H_malloc_str(AgentID))) {
                strcpy(s, AgentID);
                p->agent_id = s;
   
                if (state != H_TRUE) {
                    p -> next = NULL;
                    e ->func_dir = p;
                } else {
                    p -> next = q;
                    H_Envs[index]->func_dir = p;
                }
                AgsInitSt = H_SUC;
	      }
	  }
      }
  }


/* $B%a%=%C%I%G%#%l%/%H%j$N99?7(B
   [I/O]
     +Env      : $B4D6-$r4^$`J#9g%(!<%8%'%s%H$N(BID
     +Function : $B5!G=L>(B
     +Method   : $B%a%=%C%IL>(B
     -AgentID  : $B%(!<%8%'%s%H(BID
     -AL_Method: $B%a%=%C%IJQ99L>(B | NULL
*/
void add_to_method_directory(Env, Function, Method, AgentID, AL_Method)
char *Env, *Function, *Method, *AgentID, *AL_Method;
{
    H_AGS        *e;
    H_MTD_DIR    *p, *q;
    char         *s;
    int          index;
    int          state, state2;
    H_MTD_DIR2   *d1, *d2;

/*    H_ags_dprint("%s \n","In add-method-dir"); */

    /* $B%G%#%l%/%H%j=i4|2==hM}Cf$K%(%i!<$,5/$-$F$$$l$P(B*/
    if ( AgsInitSt != H_SUC ) return;

    /* $B4{$K4D6-L>$,EPO?$5$l$F$$$l$P(BIndex$B$r<hF@(B */
    state = H_ch_exist_env(Env,&index);

    if (state == H_TRUE) {
        /* $B4{$KF1$85!G=L>$H%a%=%C%IL>$,EPO?$5$l$F$$$k$J$i(B */
        if ((state2 = H_ch_exist_mtd_data(index,
                         Function,Method,&d1)) == H_TRUE) {

            if ( NULL !=  (d2 = (H_MTD_DIR2 *)
                             malloc( sizeof(H_MTD_DIR2) ))) {
                /* $B%(!<%8%'%s%H(BID$B$HJQ99%a%=%C%IL>$rJ]4I$9$k9=B$BN$rDI2C(B */
                d2->next = d1;
		H_Envs[index]->method_dir->dir = d2;

                if ( NULL !=  (s = H_malloc_str(AgentID))) {
                    /* $B%(!<%8%'%s%H(BID$B$rEPO?(B */
                    strcpy(s, AgentID);
                    d2->agent_id = s;

                    if (NULL !=  (s = H_malloc_str(AL_Method))) {
                        /* $BJQ99%a%=%C%IL>$rEPO?(B */
                        strcpy(s, AL_Method);
                        d2->method_name = s;

		      } else {
   		        AgsInitSt = H_MEMERR;
                        return; }
		  } else {
 		    AgsInitSt = H_MEMERR;
                    return; }
	      } else {
  	        AgsInitSt = H_MEMERR;
                return; }
	  
        /* $BF1$85!G=L>$H%a%=%C%IL>$,EPO?$5$l$F$$$J$$>l9g(B */
        } else {
            if ( NULL != (p = (H_MTD_DIR *) 
                          (malloc( sizeof( H_MTD_DIR ) )))) {

                if ( NULL !=  (s = H_malloc_str(Function))) {
                    /* $B5!G=L>$rEPO?(B */
                    strcpy(s, Function);
                    p->func_name = s;

                    if ( NULL !=  (s = H_malloc_str(Method))) {
                        /* $B%a%=%C%IL>$rEPO?(B */
                        strcpy(s, Method);
                        p->method_name = s;

                        if ( NULL !=  (d1 = (H_MTD_DIR2 *) 
                                       malloc( sizeof(H_MTD_DIR2) ))) {
                            p->dir = d1;

                            if ( NULL !=  (s = H_malloc_str(AgentID))) {
                                /* $B%(!<%8%'%s%H(BID$B$rEPO?(B */
                                strcpy(s, AgentID);
                                d1->agent_id = s;

                                if (NULL !=  (s = H_malloc_str(AL_Method))) {
                                    /* $BJQ99%a%=%C%IL>$rEPO?(B */
                                    strcpy(s, AL_Method);
                                    d1->method_name = s;
		                    d1->next = NULL;

                                    if (state2 == H_NONDAT) {
                                        p->next = NULL;
                                        H_Envs[index]->method_dir = p;

				    } else {
                                        p ->next = H_Envs[index]->method_dir;
                                        H_Envs[index]->method_dir = p;
				      }
				  } else {
                                    AgsInitSt = H_MEMERR;
                                    return; }
			      } else {
  	                        AgsInitSt = H_MEMERR;
                                return; }
			  } else {
  	                    AgsInitSt = H_MEMERR;
                            return; }
		      } else {
       	                AgsInitSt = H_MEMERR;
                        return; }
		  } else {
  	            AgsInitSt = H_MEMERR;
                    return; }
	      } else {
  	        AgsInitSt = H_MEMERR;
                return; }  }
    
    /* $BL$EPO?$G$"$l$P(B */
    } else {

        if ( NULL !=  (s = H_malloc_str(Env))) {

            /* $B4D6-L>$rEPO?(B */
            strcpy(s, Env);
            H_EnvNames[H_EnvC] = s;

            if ( NULL != (e = (H_AGS *) malloc( sizeof(H_AGS)))) {

 		/* $B$=$N4D6-L>$KBP1~$9$k9=B$BN$rMQ0U(B */
                e->agent_dir = NULL;
                e->func_dir = NULL;
                e->global_pool = NULL;
                e->ags_pont = NULL;
		e->p_dir = NULL;
                H_Envs[H_EnvC] = e;
                H_EnvC++;

	      } else {
 		AgsInitSt = H_MEMERR;
                return; }
	  } else {
	    AgsInitSt = H_MEMERR;
            return; }

        if ( NULL != (p = (H_MTD_DIR *) (malloc( sizeof( H_MTD_DIR ) )))) {

            if ( NULL !=  (s = H_malloc_str(Function))) {
                 /* $B5!G=L>$rEPO?(B */
                 strcpy(s, Function);
                 p->func_name = s;

                 if ( NULL !=  (s = H_malloc_str(Method))) {
                      /* $B%a%=%C%IL>$rEPO?(B */
                      strcpy(s, Method);
                      p->method_name = s;

                      if ( NULL !=  (d1 = (H_MTD_DIR2 *) 
                                  malloc( sizeof(H_MTD_DIR2) ))) {
                           p->dir = d1;

                           if ( NULL !=  (s = H_malloc_str(AgentID))) {
                                /* $B%(!<%8%'%s%H(BID$B$rEPO?(B */
                                strcpy(s, AgentID);
                                d1->agent_id = s;

                                if (NULL !=  (s = H_malloc_str(AL_Method))) {
                                    /* $BJQ99%a%=%C%IL>$rEPO?(B */
                                    strcpy(s, AL_Method);
                                    d1->method_name = s;
                                    d1->next = NULL;
                                    p -> next = NULL;
                                    e->method_dir = p;

			         } else {
                                    AgsInitSt = H_MEMERR;
                                    return; }
			  } else {
                             AgsInitSt = H_MEMERR;
                             return; }
		      } else {
                        AgsInitSt = H_MEMERR;
                        return;}
		 } else {
                   AgsInitSt = H_MEMERR;
                   return; }
            } else {
              AgsInitSt = H_MEMERR;
              return; }
       } else {
         AgsInitSt = H_MEMERR;
         return; } 
   }
}


/* $B4{$KJQ99%a%=%C%IL>$,EPO?$5$l$F$$$k$+$r%A%'%C%/(B
   [I/O]
      +index    : $BEPO?$5$l$F$$$k4D6->pJs$N%$%s%G%C%/%9HV9f(B
      +Function : $B5!G=L>(B
      +Method   : $B%a%=%C%IL>(B
      -dir2     : $BEPO?$5$l$F$$$k;~$N(BDirectory$B$r;X$9%]%$%s%?(B
*/
int H_ch_exist_mtd_data(index,Function,Method,dir2)
int  index;
char *Function;
char *Method;
H_MTD_DIR2 **dir2;
{
    H_MTD_DIR *d;

    d = H_Envs[index]->method_dir;
    if (d == NULL) { return(H_NONDAT); }

    while( d != NULL ) {
        if ( strcmp(Function, d->func_name) == H_EQ &&
             strcmp(Method, d->method_name) == H_EQ ) {
	    (*dir2) = d->dir;
            return( H_TRUE );
        }
        d = d ->next;
    }
    return( H_FAIL );
  }


/* $B3F%G%#%l%/%H%j$N%@%s%W(B */
void dump_agent_server()
{
    int i;

    for(i=0 ; i < H_EnvC ; i++) {
        H_ags_dprint("Environment: << %s >>\n", H_EnvNames[i]);
        H_dump_agent_directory(i);
        H_dump_function_directory(i);
        H_dump_method_directory(i);
        H_ags_dprint("%s\n","");
      }
}


/* $B%(!<%8%'%s%H%G%#%l%/%H%j$N%@%s%W(B
    [I/O]
       +i :  $B4D6-$N%$%s%G%C%/%9HV9f(B
*/
void H_dump_agent_directory(i)
int i;
{
    H_AG_DIR *dir;
    
    if ( H_AgsTraceSt == H_OFF ) return;
    H_ags_dprint("  %s\n","+agent directory");

    dir = H_Envs[i]->agent_dir;

    while( NULL != dir ) {
        H_ags_dprint("    %s :: ", dir->agent_name);
        H_ags_dprint("%s\n", dir->agent_id);
        dir = dir -> next;
      }
}


/* $B%U%!%s%/%7%g%s%G%#%l%/%H%j$N%@%s%W(B
    [I/O]
       +i :  $B4D6-$N%$%s%G%C%/%9HV9f(B
*/
void H_dump_function_directory(i)
int i;
{
    H_FUNC_DIR *dir;
    
    if ( H_AgsTraceSt == H_OFF ) return;
    H_ags_dprint("  %s\n","+function directory");

    dir = H_Envs[i]->func_dir;

    while( NULL != dir ) {
        H_ags_dprint("    %s :: ", dir->func_name);
        H_ags_dprint("%s\n", dir->agent_id);
        dir = dir -> next;
      }
}


/* $B%a%=%C%I%G%#%l%/%H%j$N%@%s%W(B
    [I/O]
       +i :  $B4D6-$N%$%s%G%C%/%9HV9f(B
*/
void H_dump_method_directory(i)
int i;
{
    H_MTD_DIR *d;

    if ( H_AgsTraceSt == H_OFF ) return;
    H_ags_dprint("  %s\n","+method directory");

    d = H_Envs[i]->method_dir;

    while( NULL != d ) {
        H_ags_dprint("   [ %s : ", d->func_name);
        H_ags_dprint("%s ] :: ", d->method_name);
        H_dump_method_directory2(d->dir);
        d = d -> next;  
    }
}


/*  [I/O]
      +d : $BJQ99%a%=%C%IL>$,EPO?$5$l$F$$$k(BSub Directory$B$X$N%]%$%s%?(B
*/
void H_dump_method_directory2(d)
H_MTD_DIR2 *d;
{
    H_MTD_DIR2 *dd;

    H_ags_dprint("{ %s ; ", d->agent_id);
    H_ags_dprint("%s }", d->method_name);
    dd = d->next;

    while( dd != NULL ) {
        H_ags_dprint("{ %s ; ", dd->agent_id);
        H_ags_dprint("%s }", dd->method_name);
        dd = dd -> next;
    }
    H_ags_dprint("%s\n","");
}


/* $B%(!<%8%'%s%H%5!<%P$N=*N;(B */
void quit_agent_server()
{
    int i;

    for(i=0; i < H_EnvC ; i++) {
        H_quit_agent_directory(i);
        H_quit_function_directory(i);
        H_quit_method_directory(i);
      }

    for(i=0; i < H_EnvC ; i++) {
        H_free_agent_dir_link(H_Envs[i]);
        H_free_func_dir_link(H_Envs[i]);
        H_free_method_dir_link(H_Envs[i]);
        free(H_EnvNames[i]);
      }
}


/* $B%(!<%8%'%s%H%G%#%l%/%H%j$N2rJ|(B
    [I/O]
      +env : $B4D6-(BObj
*/
void H_free_agent_dir_link(env)
H_AGS *env;
{
  H_AG_DIR *dir1, *dir2;

  dir1 = env->agent_dir;

    while( dir1 != NULL ) {
       dir2 = dir1->next;
       free(dir1);
       dir1 = dir2;
    }
}


/* $B%U%!%s%/%7%g%s%G%#%l%/%H%j$N2rJ|(B
    [I/O]
      +env : $B4D6-(BObj
*/
void H_free_func_dir_link(env)
H_AGS *env;
{
    H_FUNC_DIR *dir1,*dir2;

    dir1 = env->func_dir;

    while( dir1 != NULL ) {
       dir2 = dir1->next;
       free(dir1);
       dir1 = dir2;
    }
}


/* $B%a%=%C%I%G%#%l%/%H%j$N2rJ|(B
    [I/O]
      +env : $B4D6-(BObj
*/
void H_free_method_dir_link(env)
H_AGS *env;
{
    H_MTD_DIR *dir1, *dir2;

    dir1 = env->method_dir;

    while( dir1 != NULL ) {
       dir2 = dir1->next;
       free(dir1);
       dir1 = dir2;
     }
  }


/* $B%(!<%8%'%s%H%G%#%l%/%H%j$N=*N;(B
     [I/O]
       +i : $B4D6-$N%$%s%G%C%/%9HV9f(B
*/
void H_quit_agent_directory(i)
int i;
{
    H_AG_DIR *dir;
    
    dir = H_Envs[i]->agent_dir;

    while( NULL != dir ) {
        free(dir->agent_name);
        free(dir->agent_id);
        dir = dir -> next;
      }    
}


/* $B%U%!%s%/%7%g%s%G%#%l%/%H%j$N=*N;(B
     [I/O]
       +i : $B4D6-$N%$%s%G%C%/%9HV9f(B
*/
void H_quit_function_directory(i)
int i;
{
    H_FUNC_DIR *dir;
    
    dir = H_Envs[i]->func_dir;

    while( NULL != dir ) {
        free(dir->func_name);
        free(dir->agent_id);
        dir = dir -> next;
      }    
}


/* $B%a%=%C%I%G%#%l%/%H%j$N=*N;(B
     [I/O]
       +i : $B4D6-$N%$%s%G%C%/%9HV9f(B
*/
void H_quit_method_directory(i)
int i;
{
    H_MTD_DIR *d;

    d = H_Envs[i]->method_dir;

    while( NULL != d ) {
        free(d->func_name);
        free(d->method_name);
        H_quit_method_directory2(d->dir);
        d = d -> next;
      }        
}


/*   [I/O]
       +dir2 : $BJQ99%a%=%C%IL>$,EPO?$5$l$F$$$k(BSub Directory$B$r;X$9%]%$%s%?(B
*/
void H_quit_method_directory2(dir2)
H_MTD_DIR2 *dir2;
{
    H_MTD_DIR2 *d;

    d = dir2;

    while( d != NULL ) {
        free(d->agent_id);
        free(d->method_name);
        d = d->next;
      }
  }


/* ----------------- E T C ------------------ */

/* $B4D6-L>$,EPO?$5$l$F$$$k$+G!2?$r%A%'%C%/(B
   [I/O]
     +Env :   $B4D6-$r4^$`J#9g%(!<%8%'%s%H$NL>A0(B
     -Index : $BEPO?$5$l$F$$$k$=$N4D6-$N%$%s%G%C%/%9HV9f(B
*/
int H_ch_exist_env(Env,Index)
char *Env;
int  *Index;
{
    int i;

    for(i = 0; i < H_EnvC; i++){
        if (strcmp(H_EnvNames[i],Env) == H_EQ) {
            *Index = i;
            return( H_TRUE );
	  }
      }
    *Index = -1;
    return( H_FAIL );
  }


/* $B%(!<%8%'%s%H%5!<%P%H%l!<%9%*%s(B */
void ags_trace() { H_AgsTraceSt = H_ON; }

/* $B%(!<%8%'%s%H%5!<%P%H%l!<%9%*%U(B */
void ags_notrace() { H_AgsTraceSt = H_OFF; }


/* $B%;%k$N@8@.$H%9%H%j%s%0$N%3%T!<(B
    [I/O]
      +ss : $B%9%H%j%s%0(B
*/
CHARs *H_ags_gen_cell(ss)
    char *ss;
{
    CHARs *c;
    char  *s;
    int   n;

    if ( (c = (CHARs *) malloc( sizeof(CHARs) )) == NULL) {
        H_ags_eprint("%s \n","Memory shortge (H_ags_gen_cell)");
        return(NULL);
    }

    n = strlen(ss);

    if ( (s = (char *) malloc( 1 + n * sizeof(char))) == NULL) {
        H_ags_eprint("%s \n","Memory shortge (H_ags_gen_cell)");
        return(NULL);
    }

    strcpy(s,ss);
    c->str = s;
    c->next = NULL;
    return(c);
}


/* $B%;%k$NO":?$NI=<((B
   [I/O]
      +a : $BJ8;zNs$,EPO?$5$l$?%;%k(B
*/
void H_ags_cell_print(a)
     CHARs *a;
{
    CHARs *b;

    if ( a == NULL ) { H_ags_dprint("%s\n", ""); return; }
    
    H_ags_dprint("%s ", a->str);
    b = a->next;

    while( b != NULL) {
       H_ags_dprint("%s ", b -> str);
       b = b->next;
    }
    H_ags_dprint("%s\n", "");
}


/* $B%;%kO":?$N2rJ|(B
   [I/O]
      +a : $BJ8;zNs$,EPO?$5$l$?%;%k(B
*/
void H_ags_free(a)
     CHARs **a;
{
  CHARs *b, *t;
  b = *a;

  while( b != NULL ) {
    free(b->str);
    b = b -> next;
  }

  b = *a;
  while( b != NULL ) {
    t = b;
    b = b -> next;
    free(t);
  }
}

/* $B%;%k$N%3%T!<(B
   [I/O]
      +a : $BJ8;zNs$,EPO?$5$l$?%;%k(B
*/
CHARs *H_ags_cp_chars(a)
CHARs *a;
{

  CHARs *p, *top, *t;

  if ( a == NULL ) return( NULL );

  p = a;

  top = H_ags_gen_cell(p->str);
  p = p -> next;
  t = top;

  while( p != NULL ) {
    t -> next = H_ags_gen_cell(p->str);
    p = p -> next;
    t = t -> next;
  }
  return( top );
}


/* $B%;%k$NH?E>%3%T!<(B
   [I/O]
      +a : $BJ8;zNs$,EPO?$5$l$?%;%k(B
*/
CHARs *H_ags_rcp_chars(a)
CHARs *a;
{

  CHARs *p, *t, *temp;

  if ( a == NULL ) return( NULL );
  p = a;

  t = H_ags_gen_cell(p->str);
  p = p -> next;

  while( p != NULL ) {
    temp = t;
    t = H_ags_gen_cell(p->str);
    t -> next = temp;
    p = p -> next;
  }
  return( t );
}

    
