
/* ----------------------------------------------------
                  H E L I O S  ver1.0

     <<< $B%(!<%8%'%s%H%G%#%l%/%H%j%A%'%C%/%k!<%A%s(B >>>

                By H.Kijima [IMS]  1994/7

                   FILE : ags_check.c
      
      - - - - - - - - - - - - - - - - - - - - - - - -

              Public Functions and Subroutines

        (1) int check_directory();
         $B%(!<%8%'%s%H%G%#%l%/%H%j!"%U%!%s%/%7%g%s%G%#%l%/%H%j(B
         $B%a%=%C%I%G%#%l%/%H%j$N@09g@-$N%A%'%C%/(B

   ----------------------------------------------------        
*/

#include <stdio.h>
#include <helios/HeAgSvDef.h>
#include <helios/HeAgSv.h>


/* Prototype Difinition */
int check_directory();
int check_agent_directory();
int H_check_agent_directory2();
int check_function_directory();
int check_method_directory();
int H_check_method_directory2();
int H_agent_id_duplicate_of_func_dir();
int H_agent_id_duplicate_of_method_dir();
int H_agent_id_duplicate_of_method_dir2();

extern char *H_malloc_str();
extern void H_ags_dprint();
extern char *search_logical_agent_name();

/* extern void debug_dprint(); */

extern H_AGS *H_Envs[];             /* $B4D6-(BObj$B$rJ]4I$9$kG[Ns(B */
extern char  *H_EnvNames[];         /* $B4D6-L>$rJ]4I$9$kG[Ns(B */

extern int H_EnvC;                  /* $B4D6-?t(B */
extern int AgsInitSt;               /* $B%(!<%8%'%s%H%5!<%P=i4|2=7k2L(B */


/* $B%(!<%8%'%s%H%G%#%l%/%H%j!"%U%!%s%/%7%g%s%G%#%l%/%H%j!"(B
   $B%a%=%C%I%G%#%l%/%H%j$N@09g@-$r%A%'%C%/$9$k!#(B
    Return ::= H_SUC | H_FAIL 
 */
int check_directory()
{
  int i;
  int st0, st1, st2;
  int state;

  /* $B%G%#%l%/%H%j$N=i4|2=;~$K%(%i!<$,H/@8$7$F$$$l$P!J%a%b%j(Balloc$B%(%i!<!K(B */
  if ( AgsInitSt != H_SUC ) {
    H_ags_dprint("%s\n","agent server initial fail");
    return(H_FAIL);
  }

  state = H_SUC;

  /* $B3F4D6-$N%G%#%l%/%H%j$r%A%'%C%/(B */
  for(i=0 ; i < H_EnvC ; i++) {
    H_ags_dprint("Checking the Environment: << %s >>\n", H_EnvNames[i]);

    H_ags_dprint(" Checking in the agent directory %s\n", "");
    st0 = check_agent_directory(i);

    H_ags_dprint(" Checking in the method directory %s\n", "");
    st1 = check_method_directory(i);

    H_ags_dprint(" Checking in the function directory %s\n", "");
    st2 = check_function_directory(i);

    if (st0 == H_SUC && st1 == H_SUC && st2 == H_SUC) {
      H_ags_dprint("Complete!! %s\n\n","");
    } else {
      H_ags_dprint("%s\n\n","");
      state = H_FAIL;
    }
  }

  return( state );
}


/* $B%(!<%8%'%s%H%G%#%l%/%H%j$N%A%'%C%/(B
    [I/O]
     +i : $B4D6-$N%$%s%G%C%/%9HV9f(B
     Return : $B>uBV(B
*/ 
int check_agent_directory(i)
int i;
{
    H_AG_DIR *dir;
    char *name, *id;
    int state;
 
    dir = H_Envs[i]->agent_dir;

    if ( dir == NULL ) return( H_SUC );
    name = dir->agent_name;
    id = dir->agent_id;

    state = H_SUC;

    while( dir->next != NULL ){
      if ( H_check_agent_directory2(name,id,dir->next) != H_SUC) 
	state = H_FAIL;
      dir = dir->next;
      name = dir->agent_name;
      id = dir->agent_id;
    }

    return( state );
  }


/* $B;XDj$7$?%(!<%8%'%s%HL>$H%(!<%8%'%s%H(BID$B$K$D$$$F=EJ#$7$FEPO?$5$l$F(B
   $B$$$J$$$+%A%'%C%/(B
    [I/O]
      +Name : $B%(!<%8%'%s%HL>(B
      +id :   $B%(!<%8%'%s%H(BID
      +dir :  $B%(!<%8%'%s%H%G%#%l%/%H%j(B
      Return : $B>uBV(B
*/
int H_check_agent_directory2(name,id,dir)
char *name, *id;
H_AG_DIR *dir;
{
    int state;
    state = H_SUC;

    while( NULL != dir ) {
      if (strcmp(name,dir->agent_name) == H_EQ) {
	H_ags_dprint("  Logical agent name ( %s ) is duplicate.\n",name);
	state = H_FAIL;
      }

      if (strcmp(id,dir->agent_id) == H_EQ) {
	H_ags_dprint("  Agent id ( %s ) is duplicate.\n",id);
        state = H_FAIL;
      }
      dir = dir -> next;
    }

    return( state );
  }


/* $B%U%!%s%/%7%g%s%G%#%l%/%H%j$N%A%'%C%/(B 
    [I/O]
     +i : $B4D6-$N%$%s%G%C%/%9HV9f(B
     Return : $B>uBV(B
*/ 
int check_function_directory(i)
int i;
{
    H_FUNC_DIR *dir;
    int state;
    char *func, *id;

    dir = H_Envs[i]->func_dir;
    state = H_SUC;

    while( NULL != dir ) {
      if ( NULL == search_logical_agent_name(H_EnvNames[i],dir->agent_id)) {
	H_ags_dprint("  Logical agent name of ( %s ) is undefined.\n",
                     dir->agent_id);
        state = H_FAIL;
      }
      dir = dir -> next;
    }

    dir = H_Envs[i]->func_dir;

    if ( dir != NULL ) {
      if ( dir -> next != NULL ) {
        func = dir -> func_name;
        id   = dir -> agent_id;
        while( NULL != dir) {
          if ( H_FAIL == H_agent_id_duplicate_of_func_dir(func,id,dir->next)) 
	    state = H_FAIL;
          dir = dir -> next;
        }
      }
    }

    return( state );
}


/* $B%a%=%C%I%G%#%l%/%H%j$N%A%'%C%/(B
    [I/O]
     +i : $B4D6-$N%$%s%G%C%/%9HV9f(B
     Return : $B>uBV(B
*/ 
int check_method_directory(i)
int i;
{
    H_MTD_DIR *d;
    int state ;

    d = H_Envs[i]->method_dir;
    state = H_SUC;

    while( NULL != d ) {
        if (H_FAIL == H_check_method_directory2(H_EnvNames[i],d->dir))
	  state = H_FAIL;
        d = d -> next;  
    }

    d = H_Envs[i]->method_dir;

    while( NULL != d ) {
      if ( H_FAIL == H_agent_id_duplicate_of_method_dir(d)) 
	    state = H_FAIL;
      d = d -> next;
    }

    return( state );
}


/* $B;XDj4D6-$N%a%=%C%I%G%#%l%/%H%j$r%A%'%C%/(B
    [I/O]
     +env : $B4D6-L>(B 
     +d   : $B%a%=%C%I%G%#%l%/%H%j(B
*/
int H_check_method_directory2(env,d)
char *env;
H_MTD_DIR2 *d;
{
    H_MTD_DIR2 *dd;
    int state;
    
    state = H_SUC;

    if ( NULL == search_logical_agent_name(env,d->agent_id)) {
      H_ags_dprint("  Logical agent name of ( %s ) is undefined.\n",
		   d->agent_id);
      state = H_FAIL;
    }

    dd = d->next;
 
    while( dd != NULL ) {
      if ( NULL == search_logical_agent_name(env,dd->agent_id)) {
        H_ags_dprint("  Logical agent name of ( %s ) is undefined.\n",
		     dd->agent_id);
        state = H_FAIL;
      }
      dd = dd -> next;
    }

    return( state ); 
}


/* $B5!G=L>$H%(!<%8%'%s%H(BID$B$N=EJ#$r%A%'%C%/(B 
    [I/O] 
     +func : $B5!G=L>(B
     +id   : $B%(!<%8%'%s%H(BID
     +dir  : $B%U%!%s%/%7%g%s%G%#%l%/%H%j(B
     Return : $B>uBV(B
*/
int H_agent_id_duplicate_of_func_dir(func,id,dir)
     char *func;
     char *id;
     H_FUNC_DIR *dir;
{
  int state;

  state = H_SUC;

  while( dir != NULL ) {
    if ( strcmp(dir->func_name,func) == H_EQ &&
         strcmp(dir->agent_id,id) == H_EQ ) {
      H_ags_dprint("  The pair of Function and Agent ID is duplicate.%s\n","");
      H_ags_dprint("    Function: %s   ",func);
      H_ags_dprint("    Agent id: %s\n",id);
      state = H_FAIL;
    }
    dir = dir -> next;
  }

  return( state );
}


/* $B%(!<%8%'%s%H(BID$B$H%a%=%C%IL>$N%Z%"$N=EJ#$r%A%'%C%/(B 
    [I/O] 
     +dir  : $B%a%=%C%I%G%#%l%/%H%j(B
     Return : $B>uBV(B
*/ 
int H_agent_id_duplicate_of_method_dir(dir)
     H_MTD_DIR2 *dir;
{
  int state;
  char *id, *method;

  state = H_SUC;

  if (dir != NULL) {
    if (dir->next != NULL) {
      while( dir != NULL ) {
        id = dir -> agent_id;
        method = dir -> method_name;
	if (H_FAIL == H_agent_id_duplicate_of_method_dir2(id,method,dir->next))
	  state = H_FAIL;
	dir = dir -> next;
      }
    }
  }

  return( state );
}


/* $B%(!<%8%'%s%H(BID$B$H%a%=%C%IL>$N%Z%"$N=EJ#$r%A%'%C%/(B 
    [I/O] 
     +id   : $B%(!<%8%'%s%H(BID
     +method : $B%a%=%C%IL>(B
     +dir   : $B%a%=%C%I%G%#%l%/%H%j(B
     Return : $B>uBV(B
*/ 
int H_agent_id_duplicate_of_method_dir2(id,method,dir)
     char *id, *method;
     H_MTD_DIR2 *dir;
{
  int state;

  state = H_SUC;

  while( dir != NULL ) {
    if (strcmp(id, dir -> agent_id) == H_EQ &&
	strcmp(method, dir->method_name) == H_EQ) {
      H_ags_dprint("  The pair of Agent ID and Method is duplicate.%s\n","");
      H_ags_dprint("    Agent id: %s   ",id);
      H_ags_dprint("    Method:   %s\n",method);
      state = H_FAIL;
    }

    dir = dir -> next;
  } 

  return ( state );
}
