/* ----------------------------------------------------
                  H E L I O S  ver1.0              

               <<< $B%(!<%8%'%s%H%5!<%P(B >>>

                By H.Kijima [IMS]  1994/6

                    FILE : ag_server.c

     - - - - - - - - - - - - - - - - - - - - - - - - 
             Public Functions and Subroutines

     (1)char *search_logical_agent_name()
        $B%(!<%8%'%s%H(BID$B$+$i%(!<%8%'%s%HO@M}L>$r8!:w(B

     (2)char *search_agent_id();
        To-filed$B$r$b$H$KAw$j@h%(!<%8%'%s%H8uJd$NA*=P(B

   ----------------------------------------------------
*/

#include <stdio.h>
#include <helios/SMessage.h>
#include <helios/HeAgSv.h>
#include <helios/HeAgSvDef.h>


#define  H_AGN     1
#define  H_FUMAN   3
#define  H_FUMEMAN 5

extern H_AGS *H_Envs[];
extern char *H_EnvNames[];
extern int H_EnvC;
extern int AgsInitSt;
extern int H_AgsTraceSt;
extern int H_AgsConneSt;
extern int H_ch_exist_env();
extern char *H_malloc_str();
extern CHARs *H_ags_gen_cell();
extern CHARs *H_ags_cp_chars();
extern CHARs *H_ags_rcp_chars();
extern int H_bag_ofn();

char *H_search_agent_directory();
char *H_search_in_ag_dir();
char *search_logical_agent_name();
char *H_search_name_in_ag_dir();

CHARs *H_search_function_directory();
CHARs *H_search_in_func_dir();

CHARs *H_search_method_directory();
CHARs *H_search_in_method_dir();
CHARs *H_search_in_method_dir2();

char *search_agent_id();
int H_ch_mid_in_agspont();
int H_To_type();
void H_ags_classify();
void free_pointer_of_ag_server();

int H_add_to_ags_pointers();
char *H_next_candidate_pointer();

CHARs *H_get_all_agents();
void H_del_bag_of_n();
int  H_ch_bag_of_n();

void H_append_dir();
void H_append_dir2();

void H_delete_from_agent();


/* SMESSAGE reference functions */
extern char *CSGetToAFStr();
extern char *CSGetToManagementStr();
extern char *CSMGetToMethodStr();


/* global variables */
int H_GCsC = 0;        /* counter of the candidate pointer */
AGSPONT *H_GCsPs;      /* candidate pointer list */

/* --------------------------------------------------*/


/* $B8!:w%k!<%A%s$rDj5A$9$k(B */
/* 1. Agent Directory */
/*   [I/O]
       +Env       : $BJ#9g%(!<%8%'%s%H(BID   
       +AgentName : $B%(!<%8%'%s%HO@M}L>(B
*/
char *H_search_agent_directory(Env, AgentName)
     char *Env;
     char *AgentName;
{
  int index;
  char *id, *id2;

  if (H_ch_exist_env(Env,&index) == H_FAIL) return( NULL );

  if ((id = H_search_in_ag_dir(index,AgentName)) == NULL) return( NULL );
  id2 = H_malloc_str(id);
  strcpy(id2,id);
  return(id2);
}


/* $B%(!<%8%'%s%H(BID$B$N8!:w(B */
/*    [I/O]
        +index     : $B4D6-$N%$%s%G%C%/%9HV9f(B
        +AgentName : $B%(!<%8%'%s%HO@M}L>(B
*/
char *H_search_in_ag_dir(index,AgentName)
     int index;
     char *AgentName;
{
  H_AG_DIR *dir;

  dir = H_Envs[index]->agent_dir;

  while( dir != NULL ) {
    if (strcmp(dir->agent_name, AgentName) == H_EQ) return( dir->agent_id);
    dir = dir ->next;
  }
  return( NULL );
}


/* $B%(!<%8%'%s%H(BID$B$+$i%(!<%8%'%s%HO@M}L>$r8!:w(B */
/*   [I/O]
       +Env       : $BJ#9g%(!<%8%'%s%H(BID   
       +Agent_id  : $B%(!<%8%'%s%H(BID
*/
char *search_logical_agent_name(Env, Agent_id)
     char *Env;
     char *Agent_id;
{
  char *name, *name2;
  int index;

  if (H_ch_exist_env(Env,&index) == H_FAIL) return( NULL );
  if ((name = H_search_name_in_ag_dir(index,Agent_id)) == NULL) 
    return( NULL );
  name2 = H_malloc_str(name);
  strcpy(name2,name);
  return(name2);  
}


/* $B%(!<%8%'%s%HO@M}L>$N8!:w(B */
/*    [I/O]
        +index     : $B4D6-$N%$%s%G%C%/%9HV9f(B
        +Agent_id  : $B%(!<%8%'%s%H(BID
*/
char *H_search_name_in_ag_dir(index,Agent_id)
     int index;
     char *Agent_id;
{
  H_AG_DIR *dir;

  dir = H_Envs[index]->agent_dir;

  while( dir != NULL ) {
    if (strcmp(dir->agent_id, Agent_id) == H_EQ) 
       return( dir->agent_name);
    dir = dir ->next;
  }
  return( NULL );
}

  
/* 2. Function Directory */
/*    [I/O]
        +Env      : $BJ#9g%(!<%8%'%s%HL>(B
        +Function : $B5!G=L>(B
*/
CHARs *H_search_function_directory(Env, Function)
     char *Env;
     char *Function;
{
  CHARs *names, *names2;
  int index;

  if (H_ch_exist_env(Env,&index) == H_FAIL) return( NULL );
  if ((names = H_search_in_func_dir(index,Function)) == NULL) return( NULL );
/*  names2 = H_ags_cp_chars(names); 
  return( names2 ); */
  return( names );
}

 
/*    [I/O]
        +index     : $B4D6-$N%$%s%G%C%/%9HV9f(B
        +Function  : $B5!G=L>(B
*/
CHARs *H_search_in_func_dir(index,Function)
     int index;
     char * Function;
{
  H_FUNC_DIR *dir;
  CHARs *strs, *temp;

  strs = NULL;
  dir = H_Envs[index]->func_dir;

  while( dir != NULL ) {
    if (strcmp(dir->func_name, Function) == H_EQ) {
      if (strs == NULL) {
	strs = H_ags_gen_cell(dir->agent_id);
      } else {
        temp = strs;
	strs = H_ags_gen_cell(dir->agent_id);
        strs -> next = temp;
      }
    }
    dir = dir ->next;
  }
  return( strs );
}


/* 3. Method Directory */
/*    [I/O]
        +Env      : $BJ#9g%(!<%8%'%s%HL>(B
        +Function : $B5!G=L>(B
        +Method   : $B%a%=%C%IL>(B
*/
CHARs *H_search_method_directory(Env, Function, Method)
     char *Env;
     char *Function;
     char *Method;
{
  CHARs *names, *names2;
  int index;

  if (H_ch_exist_env(Env,&index) == H_FAIL) return( NULL );
  if ((names = H_search_in_method_dir(index,Function,Method)) == NULL) 
        return( NULL );
  names2 = H_ags_rcp_chars(names);
  /* free */
  H_ags_free(&names);

  return( names2 );
}


/*    [I/O]
        +index     : $B4D6-$N%$%s%G%C%/%9HV9f(B
        +Function  : $B5!G=L>(B
        +Method    : $B%a%=%C%IL>(B
*/
CHARs *H_search_in_method_dir(index,Function,Method)
int index;
char *Function;
char *Method;
{
  H_MTD_DIR *d;
  CHARs *strs;

  d = H_Envs[index]->method_dir;

  while( d != NULL ) {
    if (strcmp(d->func_name,Function)  == H_EQ &&
	strcmp(d->method_name, Method) == H_EQ) {
        strs = H_search_in_method_dir2(d->dir);
        return( strs );
      }
    d = d -> next;
  }
  return( NULL );
}

/*  [I/O]
      +dir    : $BJQ99%a%=%C%IL>$,EPO?$5$l$F$$$k(BSub Directory$B$r;X$9%]%$%s%?(B
*/
CHARs *H_search_in_method_dir2(dir)
H_MTD_DIR2 *dir;
{
  CHARs *strs, *temp, *temp2, *temp3, *tempx;
  H_MTD_DIR2 *d;

  if( dir == NULL ) return( NULL );
  d = dir;
  strs = H_ags_gen_cell(d->method_name);
  temp = H_ags_gen_cell(d->agent_id);
  strs -> next = temp;
  d = d->next;
  tempx = temp;

  while ( d != NULL ) {
    temp2 = H_ags_gen_cell(d->method_name);
    temp3 = H_ags_gen_cell(d->agent_id);
    temp2 -> next = temp3;
    tempx -> next = temp2;
    tempx = temp3;            
    d = d -> next;
  }
  return( strs );
}


/* 4. Agent Server (Management of the each Direcory) */
/*  To-filed$B$r$b$H$KAw$j@h%(!<%8%'%s%H8uJd$NA*=P(B */
/*   [I/O]
       +Env       : $BJ#9g%(!<%8%'%s%H(BID
       +Mid       : $B%a%C%;!<%8(BID
       +To        : To-Field
       +Method    : $B%a%=%C%IL>(B
       -NewMethod : $BJQ99%a%=%C%IL>(B
*/
char *search_agent_id(Env, Mid, From, To, ToMethod, NewMethod)
     char *Env;
     SMMid Mid;
     SMFrom From;
     SMTo To;
     char *ToMethod;       /* the method of SMessage */
     char **NewMethod;
{ 
     char  *AgentName, *Function, *Manage;
     char  *AgentID;
     CHARs *AgentIDs, *AgentIDs1, *AgentIDs2;
     int   type;
     int   state;
     int   n;

     /* To-Field$B$N%?%$%W(B */
     type = H_To_type(&To,&AgentName,&Function,ToMethod, &Manage);
     
     H_ags_dprint("Env : %s \n", Env);
     H_ags_dprint("Type: %d ",type);
     H_ags_dprint("AgNa: %s ",AgentName);
     H_ags_dprint("FuNa: %s ",Function);
     H_ags_dprint("MeNa: %s ",ToMethod);
     H_ags_dprint("MaNa: %s \n",Manage);

     switch (type) {

     /* $B%(!<%8%'%s%HO@M}L>$N>l9g(B */
     case H_AGN : 
       AgentID = H_search_agent_directory(Env,AgentName);
       *NewMethod = NULL;
       break;

     /* $B5!G=L>$N>l9g(B */
     case H_FUMAN :

       /* $B8uJd%j%9%H$,$J$1$l$P(B */
       if (H_ch_mid_in_agspont(Mid) == H_FAIL) {

         /* $B5!G=L>$,(Ball$B$J$i(B */
	 if (strcmp(Function, "all") == H_EQ ) {
           
	   if ((AgentIDs = H_get_all_agents(Env)) != NULL) {
	     H_ags_dprint("%s","DIR:"); H_ags_cell_print(AgentIDs);

	     /* $B=hM}L>$,(B{bag_of,N}$B$J$i$P(B */
             n = H_bag_ofn(Manage);   
	     H_ags_dprint("  n:bag_of:: %d\n",n);
             if ( n > 0 ) H_del_bag_of_n(&AgentIDs,n);
             H_ags_dprint("%s","DIR:"); H_ags_cell_print(AgentIDs); 

 	     AgentID = AgentIDs->str;
             *NewMethod = NULL;
             state = H_add_to_ags_pointers(Mid, &(AgentIDs->next));
	                if ( state == H_FAIL ) return( NULL );
             free(AgentIDs);        /* free a */
	   } else {
	     return( NULL );
	   }

         /* $B5!G=L>$,(Ball$B0J30$J$i(B */
	 } else {
	 
           /* $B%(!<%8%'%s%H8uJd$,$"$l$P(B */
           if ( (AgentIDs = H_search_function_directory(Env,Function))
	         != NULL ) {
             H_ags_dprint("%s","DIR:"); H_ags_cell_print(AgentIDs);

	     /* $BAw$j85$r:o=|(B */
             H_delete_from_agent(H_FUMAN,From,Function,&AgentIDs);
             if (AgentIDs == NULL ) return( NULL );

             AgentID = AgentIDs->str;
             *NewMethod = NULL;
             state = H_add_to_ags_pointers(Mid, &(AgentIDs->next));
             if ( state == H_FAIL ) return( NULL );
             free(AgentIDs);        /* free a */

	   } else {
	     return( NULL );
	   }
	 }

       /* $BEPO?8uJd%j%9%H$,$"$1$l$P(B */
       } else {
	 AgentID = H_next_candidate_pointer(Mid);
       }
       break;


     /* $B5!G=L>!\%a%=%C%IL>$N>l9g(B */     
     case H_FUMEMAN :

       /* $B8uJd%j%9%H$,$J$1$l$P(B */
       if (H_ch_mid_in_agspont(Mid) == H_FAIL) {

         /* $B5!G=L>$,(Ball$B$J$i(B */
	 if (strcmp(Function, "all") == H_EQ ) {
           
	   if ((AgentIDs = H_get_all_agents(Env)) != NULL) {
             H_ags_dprint("%s","DIR:"); H_ags_cell_print(AgentIDs);     

	     /* $B=hM}L>$,(B{bag_of,N}$B$J$i$P(B */
             n = H_bag_ofn(Manage);
             if ( n > 0 ) H_del_bag_of_n(&AgentIDs,n);
             /* H_ags_cell_print(AgentIDs); */

	     AgentID = AgentIDs->str;
             *NewMethod = NULL;
             state = H_add_to_ags_pointers(Mid, &(AgentIDs->next));
	                if ( state == H_FAIL ) return( NULL );
             free(AgentIDs);        /* free a */

	   } else {
	     return( NULL );
	   }

         /* $B5!G=L>$,(Ball$B0J30$J$i(B */
	 } else {

           AgentIDs1 = H_search_method_directory(Env,Function,ToMethod);
           H_ags_dprint("%s","MTD DIR:");
           H_ags_cell_print(AgentIDs1);

           AgentIDs2 = H_search_function_directory(Env,Function);
           H_ags_dprint("%s","FUNC DIR:");
           H_ags_cell_print(AgentIDs2); 

 	   /* $B%(!<%8%'%s%H8uJd$,$"$l$P(B */
           if ( AgentIDs1 != NULL || AgentIDs2 != NULL ) {
             H_append_dir(&AgentIDs1,&AgentIDs2,ToMethod);

	     /* $BAw$j85$r:o=|(B */
             H_delete_from_agent(H_FUMEMAN,From,Function,&AgentIDs1);
             if (AgentIDs1 == NULL ) return( NULL );
              H_ags_dprint("%s","DEL:"); H_ags_cell_print(AgentIDs1);

	     /* $B=hM}L>$,(B{bag_of,N}$B$J$i$P(B */
             n = H_bag_ofn(Manage);
             if ( n > 0 ) H_del_bag_of_n(&AgentIDs1,n);
             /* H_ags_dprint("%s","DIR:"); H_ags_cell_print(AgentIDs1); */

             AgentID = AgentIDs1->str;
             *NewMethod = AgentIDs1->next->str;
             state = H_add_to_ags_pointers(Mid, &(AgentIDs1->next->next));
             if ( state == H_FAIL ) return( NULL );
             free(AgentIDs1->next);        /* free a */
             free(AgentIDs1);              /* free a */

	   } else {
	     return( NULL );
	   }
	 }

       /* $BEPO?8uJd%j%9%H$,$"$l$P(B */
       } else {
	 if (strcmp(Function, "all") == H_EQ ) {
           AgentID = H_next_candidate_pointer(Mid);
	   *NewMethod = NULL;
         } else {
	   AgentID = H_next_candidate_pointer(Mid);
           *NewMethod = H_next_candidate_pointer(Mid);
	 }
       }
       break;

     default:
        /* $B$"$j$($J$$(B */
     }
     return( AgentID );
}


/* $B$=$N(BMID$B$K4X$9$k%(!<%8%'%s%H8uJd%j%9%H$,B8:_$9$k$+(B */
/*   [I/O]
       +Mid : $B%a%C%;!<%8(BID
*/
int H_ch_mid_in_agspont(Mid)
char *Mid;
{
  AGSPONT *t;

  if ( H_GCsC == 0 ) return(H_FAIL);
  t = H_GCsPs;
  if (strcmp(t->mid,Mid) == H_EQ) return( H_TRUE );
  t = t->next;

  while( t != NULL ) {
    if (strcmp(t->mid,Mid) == H_EQ) return( H_TRUE );
    t = t->next;
  }
  return( H_FAIL );
}


/* Get the type of To-field */
/*    [I/O]
       +To        : To-Field
       -AgentName : $B%(!<%8%'%s%HO@M}L>(B
       -Function  : $B5!G=L>(B
       -Method    : $B%a%=%C%IL>(B
       +Manage    : $B=hM}L>(B
*/
int H_To_type(To, AgentName, Function, Method, Manage)
SMTo *To;
char **AgentName;
char **Function;
char *Method;
char **Manage;
{
  char *ToAF, *ToME, *ToMA;

#ifdef H_USE_SM
  ToAF = CSGetToAFStr(*To);
  *Manage = CSGetToManagementStr(*To);
#else
  ToAF = (*To)->AF;                          /* refer SMessage */
  *Manage = (*To)->management;               /* refer SMessage */
#endif

  H_ags_classify(&ToAF,AgentName,Function,Manage);

  /* $B%(!<%8%'%s%HO@M}L>$N>l9g(B */
  if ( *AgentName != NULL ) {
    return( H_AGN );

  /* $B5!G=L>!\%a%=%C%IL>$N>l9g(B */
  } else if ( *Function != NULL && Method != NULL &&
              *Manage != NULL ) {
    return( H_FUMEMAN );

  /* $B5!G=L>$N>l9g(B */
  } else if ( *Function != NULL && *Manage != NULL ) {
    return( H_FUMAN );
  }
}


/* To-field$B$NFbMF$r%(!<%8%'%s%HL>!"5!G=L>(B */    
/*    [I/O]
       +ToAF      : To-Field$B$N%a%s%P(B
       -AgentName : $B%(!<%8%'%s%HO@M}L>(B
       -Function  : $B5!G=L>(B
       +Manage    : $B=hM}L>(B
*/
void H_ags_classify(ToAF,AgentName,Function,Manage)
char **ToAF;
char **AgentName;
char **Function;
char **Manage;
{
  /* $B%(!<%8%'%s%HO@M}L>$G$"$l$P(B */
  if ( *Manage == NULL ) {
    *AgentName = *ToAF;
    *Function = NULL;

  /* $B5!G=L>$J$i$P(B */
  } else  {
    *AgentName = NULL;
    *Function = *ToAF;
  }
}


/* $B<!8uJd(Bpointer$B$N2rJ|(B no_need */
/*   [I/O]
       +Mid : $B%a%C%;!<%8(BID
*/
void free_pointer_of_ag_server(Mid)
     SMMid Mid;
{
}


/* $B<!8uJd%j%9%H$NEPO?(B */
/*   [I/O]
       +Mid : $B%a%C%;!<%8(BID
       +Cs  : $B<!8uJd%(!<%8%'%s%H%j%9%H(B
*/
int H_add_to_ags_pointers(Mid, Cs)
char  *Mid;
CHARs **Cs;
{
    AGSPONT *p, *temp;
    char *s;

    /* MID$B$K$D$$$F$N=i$a$F$NEPO?$J$i$P(B */
    if ( H_GCsC == 0 ) {
      H_GCsC++;
      if ( ( p = (AGSPONT *) malloc( sizeof(AGSPONT) )) == NULL ) {
	H_ags_eprint("%s \n","Memory shortage ( H_add_to_ags_pointers )");
	return( H_FAIL );
      }
      if ( NULL == (s = H_malloc_str(Mid))) {
	return( H_FAIL );
      }

      strcpy(s,Mid);
      p -> candidate = *Cs;
      p -> mid   = s;
      p -> next  = NULL;
      H_GCsPs = p;        /* $BEPO?(B */
    
    } else {

      H_GCsC++;
      if ( ( p = (AGSPONT *) malloc( sizeof(AGSPONT) )) == NULL ) {
	H_ags_eprint("%s \n","Memory shortage ( H_add_to_ags_pointers )");
	return( H_FAIL );
      }
      if ( NULL == (s = H_malloc_str(Mid))) {
	return( H_FAIL );
      }

      strcpy(s,Mid);

      /* temp$B$KCV$$$FCV$-$+$($k(B */
      temp = H_GCsPs;
      p -> candidate = *Cs;
      p -> mid   = s;
      p -> next  = temp;
      H_GCsPs = p;
    }
  }


/* $B<!$N%(!<%8%'%s%H8uJd$r<h$j=P$9(B */			
/*   [I/O]
      +Mid : $B%a%C%;!<%8(BID
*/
char *H_next_candidate_pointer(Mid)
char *Mid;
{
  AGSPONT *t, *pre;
  char *Agent_id;
  CHARs *tt;

  if (H_GCsC == 0) return( NULL );
  t = H_GCsPs;
  pre = NULL;


  while( t != NULL ) {

    /* $B%(!<%8%'%s%H8uJd%j%9%H$,B8:_$9$l$P(B */
    if ( strcmp(Mid,t->mid) == H_EQ ) {
/*
      printf("Mid: %s %s\n",Mid,t->mid);
      printf(" :: EnvCount: %d\n",H_GCsC);
*/
      /* $B8uJd$,$J$1$l$P(B */
      if ( t->candidate == NULL ) {
	free(t->mid);
/*        if (pre != NULL) {
          pre->next = t->next;
	}
*/
	/* 5 below lines added by k3sato on July 7th. */
	if (pre == NULL) {
	    H_GCsPs = t->next;
	} else {
	    pre->next = t->next;
	}

        free( t );
        H_GCsC--;
        return( NULL );

      /* $B8uJd$,$"$l$P(B */      
      } else {

        tt = t->candidate;
        Agent_id = t->candidate->str;
        t->candidate = t->candidate->next;
        free(tt);
	return( Agent_id );
      }
    }
    pre = t;
    t = t -> next;
  }
}
    

/* $B4D6-$KEPO?$5$l$F$$$kA4$F$N%(!<%8%'%s%H$rCj=P(B */  
/*   [I/O]
       +Env : $BJ#9g%(!<%8%'%s%HL>(B
*/
CHARs *H_get_all_agents(Env)
char *Env;
{
  int index;
  H_AG_DIR *dir;
  CHARs *t, *temp;

  if (H_ch_exist_env(Env,&index) == H_FAIL) return( NULL );
  dir = H_Envs[index]->agent_dir;

  t = NULL;
  
  while( dir != NULL ) {
    if ( t == NULL ) {
      t = H_ags_gen_cell(dir->agent_id);
    } else {
      temp = t;
      t = H_ags_gen_cell(dir->agent_id);
      t -> next = temp;
    }
    dir = dir -> next;
  }
  return( t );
}
  

/* bag_of$B$N8D?tJ,$K%j%9%H$r$1$E$k(B */  
/*   [I/O]
       ss : $B%9%H%j%s%0$,6qBN2=$5$l$?%j%9%H(B
       n  : $B:o=|8D?t(B
*/
void H_del_bag_of_n(ss,n)
CHARs **ss;
int   n;
{
  CHARs *t, *old;

  if (n < 1) return;

  t = *ss;
  old = NULL;

  while( n != 0 && t != NULL ) {
    old = t;
    t = t -> next;
    n--;
  }

  if ( t == NULL ) return;

  H_ags_free(&t);
  old->next = NULL;
}


/* Append the candidates on the method directory and
   ones on the function directory 
    [I/O]
      +AgentIDs1 : $B%a%=%C%I%G%#%l%/%H%j$+$i$N8uJd%j%9%H(B
      +AgentIDs2 : $B%U%!%s%/%7%g%s%G%#%l%/%H%j$+$i$N8uJd%j%9%H(B
*/
void H_append_dir(AgentIDs1,AgentIDs2,ToMethod)
     CHARs **AgentIDs1,**AgentIDs2;
     char *ToMethod;
{
  CHARs *aids;

  aids = *AgentIDs2;

  while( aids != NULL ) {
    /* H_ags_dprint("CH:append_dir func-agent: %s\n",aids->str); */
    H_append_dir2(&(aids->str),AgentIDs1,ToMethod);
    aids = aids -> next;
  }
}


/* append the function info to candidate-list 
   [I/O]
     +AgentID : $B%(!<%8%'%s%H(BID
     +AgentIDs :$B8uJd%(!<%8%'%s%H%j%9%H(B
     +Method : $B%a%=%C%IL>(B
*/
void H_append_dir2(AgentID,AgentIDs,Method)
     char  **AgentID;
     CHARs **AgentIDs;
     char  *Method;
{
  CHARs *pre, *aids, *cs1, *cs2;
  char  *s;

  if ( AgentID == NULL ) return;
  aids = *AgentIDs;
  pre  = *AgentIDs;

  /* $B8uJd%(!<%8%'%s%H%j%9%H$r<j7+$k(B 
     [AgentID1,Method1, AgentID2,Method2, .....] */
  while( aids != NULL ) {
    if (strcmp(*AgentID,aids->str) == H_EQ) return;
    /* H_ags_dprint("CH:append_dir mtd agent: %s\n",aids->str); */
    aids = aids -> next;
    pre  = aids;
    aids = aids -> next;
  }

  /* add the new candidate agent */
  if ( (s = H_malloc_str(Method)) == NULL ) return;
  if ( (cs1 = (CHARs *) malloc( sizeof(CHARs) )) == NULL ) return;
  if ( (cs2 = (CHARs *) malloc( sizeof(CHARs) )) == NULL ) return;

  strcpy(s, Method);
  cs1 -> str = *AgentID;
  cs2 -> str = s;
  cs2 -> next = NULL;
  cs1 -> next = cs2;
  if (pre == NULL) { 
    *AgentIDs = cs1; 
  } else {pre -> next = cs1;}
}


/* $BAw$j85%(!<%8%'%s%H$r=|$/(B */
void H_delete_from_agent(type,From,Function,AgentIDs)
int   type;
char  *From;
char  *Function;
CHARs **AgentIDs;
{
  CHARs *pre, *aids;
  
  aids = *AgentIDs;
  pre  = NULL;

  if (strcmp(Function,"fast") == H_EQ ||
      strcmp(Function,"sequential") == H_EQ) return;

  while(aids != NULL) {
    if (strcmp(aids->str, From) == H_EQ) {
      if (pre == NULL) {
        switch(type) {
          case H_FUMAN : 
	    *AgentIDs = aids->next;
            free(aids->str);
            free(aids);
            break;
          case H_FUMEMAN :
	    *AgentIDs = aids->next->next;
            free(aids->str);
            free(aids->next->str);
            free(aids->next);
            free(aids);
            break;
	default:
	}
      } else {
        switch(type) {
          case H_FUMAN : 
            pre->next = aids->next;
            free(aids->str);
            free(aids);
            break;
          case H_FUMEMAN :
            pre->next = aids->next->next;
            free(aids->str);
            free(aids->next->str);
            free(aids->next);
            free(aids);
            break;
	default:
	}
      }
      return;
    } 

    if (H_FUMEMAN == type) {
      aids = aids->next;
      pre = aids;
      aids = aids->next;
    } else {
      pre = aids;
      aids = aids->next;
    }
  }
}
  
