/*
 * file name: eWaitObj.c
 *
 */

#include	<stdio.h>
#include	"eWaitObj.h"
#include	"eAmes.h"


/*
 * eWaitObjNew()
 */
void*
eWaitObjNew(char *Ames, char *to_aid, int size)
{
  WaitObj	*op;

  op = (WaitObj*)malloc( sizeof(WaitObj) );
  if ( op == NULL ) return (NULL);

  op->Ames = Ames;
  op->to_aid = (char*)malloc( strlen(to_aid)+1 );
  if ( op->to_aid == NULL ) return (NULL);
  strcpy(op->to_aid, to_aid);
  op->size = size;
  return (op);
}


/*
 * eWaitObjDelete()
 */
void
eWaitObjDelete(WaitObj *target)
{
  if ( target == NULL ) return;
  if ( target->Ames != NULL ) free(target->Ames);
  if ( target->to_aid != NULL ) free(target->to_aid);
  target->Ames = NULL;
  target->to_aid = NULL;
  target->size = 0;
  free(target);
}


/*
 * eWaitObjGetAmes()
 */
char*
eWaitObjGetAmes(WaitObj *target)
{
  return ( target->Ames );
}


/*
 * eWaitObjGetTo()
 */
char*
eWaitObjGetTo(WaitObj *target)
{
  return ( target->to_aid );
}


/*
 * eWaitObjGetSize()
 */
int
eWaitObjGetSize(WaitObj *target)
{
  return ( target->size );
}


/*
 * eWaitObjPrint()
 */
void
eWaitObjPrint(WaitObj *target)
{
  /* not implemented yet! */
  if ( target == NULL ) return;
  fprintf(stderr, "\tWaitObj\n");
  eAmesPrintHdr(target->Ames);
  fprintf(stderr, "to_aid = %s\n", eWaitObjGetTo(target));
  fprintf(stderr, "size   = %d\n", eWaitObjGetSize(target));
}


/*** END OF FILE ***/
