/*
 * file name : eUtil.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<helios/envdef.h>
#include	"eUtil.h"


/*
 * eUtilSetString()
 */
int
eUtilSetString(char **dest, char *src)
{
  int	length;

  if ( src == NULL ) {
    *dest = NULL;
    return (NORMAL);
  }
  else {
    length = strlen(src) + 1;
    *dest = (char*)malloc(length);
    if ( *dest == NULL ) return (EALLOC);
    strcpy(*dest, src);
    return (NORMAL);
  }
}


/*
 * eUtilGetUid()
 */
char*
eUtilGetUid(char *mid)
{
  int	len;
  char	*uid, *p;

  p = mid;
  len = 0;
  while ( *p != '.' ) {
    p++;
    len++;
  }
  uid = (char*)calloc(len+1, 1);
  if ( uid == NULL ) return (NULL);

  strncpy(uid, mid, len);
  return (uid);
}


/*
 * eUtilIsLogNameParam()
 */
int
eUtilIsLogNameParam(char *to)
{
  char	*p;
  int	status = 0;

  p = to;
  while ( *p ) {
    if ( status == 0 && *p == '(' ) status += 1;
    else if ( status == 1 && *p == ')' ) status += 1;
    p++;
  }
  if ( status == 0 ) return (FALSE);
  else if ( status == 2 ) return (TRUE);
  else return (ERROR);
}


/*
 * eUtilGetTemplateName()
 */
char*
eUtilGetTemplateName(char *to)
{
  char	*p, *sp, *namep;
  int	len;

  p = to;
  while ( *p == ' ' ) p++;
  sp = p;
  len = 0;
  while ( *p != ' ' && *p != '(' ) {
    len++; p++;
  }

  namep = (char*)calloc(len+1, 1);
  if ( namep == NULL ) return (NULL);
  strncpy(namep, sp, len);
  return (namep);
}


/*
 * eUtilGetInstanceName()
 */
char*
eUtilGetInstanceName(char *to)
{
  char	*p, *sp, *instancep;
  int	len;

  p = to;
  while ( *p != '(' ) p++;
  p++;
  while ( *p == ' ' ) p++;
  sp = p;
  len = 0;
  while ( *p != ' ' && *p != ')' ) {
    p++; len++;
  }
  instancep = (char*)calloc(len+1, 1);
  if ( instancep == NULL ) return (NULL);
  strncpy(instancep, sp, len);
  return (instancep);
}

/*** END OF FILE ***/
