/*
 * file name : eUpper.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eUpper.h"
#include	"eSMessage.h"
#include	"eMidObj.h"
#include	"eAidAdm.h"
#include	"eSAConv.h"
#include	"eSendError.h"
#include	"eCom.h"
#include	"eCapOfEnv.h"


/*
 * eUpperSendReply()
 */
int
eUpperSendReply(SMessage Smes, MidObj *mobj)
{
  SMessage	upperSmes;
  char	*Ames;
  char	*env, *from, *upper_env;
  int	size, rpc_id;
  int	status;

  env = eMidObjGetEnv(mobj);
  from = eMidObjGetFromProc(mobj);

  eAidAdmSetAidOfCurrentEnv(env);
  status = eAidAdmMoveToAidOfUpperEnv();
  if ( status == NORMAL ) {
    upper_env = eAidAdmGetAidOfCurrentEnv();
  }
  else if ( status == TOP_ENV ) {
    upper_env = USER_ENV_LEVEL;
  }

  /* convert reply Smessage. in-->out */
  upperSmes = eCapOfEnv(env, Smes, 1);

  status = eSAConvStoA(env, from, NORMAL_STR, upper_env, NULL, upperSmes,
		       &Ames, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(from, &rpc_id, Ames, size);
  status = eSendErrorCheck(status, Ames, from, size);
  return (status);
}

/*** END OF FILE ***/
