/*
 * file name: eToEnv.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	<helios/HeAgSvFun.h>
#include	"eToEnv.h"
#include	"eSMessage.h"
#include	"eSmes.h"
#include	"eAmes.h"
#include	"eQAdm.h"
#include	"eAidAdm.h"
#include	"eAgntDir.h"
#include	"eCom.h"
#include	"eSendError.h"
#include	"eDummy.h"

static	int	get_instance_names_proc(SMessage Smes);
static  int	get_global_const_proc(SMessage Smes);
static	int	get_my_name_proc(SMessage Smes);


/*
 * eToEnvSendProc()
 */
int
eToEnvSendProc(SMessage Smes)
{
  char	*method;
  int	status;

  method = eSmesGetSmethod(Smes);

  if ( !strcmp(GET_INSTANCES, method) ) {
    status = get_instance_names_proc(Smes);
    return (status);
  }
  else if ( !strcmp(GET_GLOBAL_CONST, method) ) {
    status = get_global_const_proc(Smes);
    eDummySend();
    return (status);
  }
  else if ( !strcmp(GET_MY_NAME, method) ) {
    status = get_my_name_proc(Smes);
    eDummySend();
    return status;
  }

  return (NORMAL);
}


/*
 * eToEnvInstanceNameReply()
 */
int
eToEnvInstanceNameReply(char *Ames)
{
  SMessage	Smes;
  char	*all_name, *mid;
  int	status;

  all_name = eAmesGetAInfo(Ames);
  mid = eAmesGetAEnv(Ames);

  Smes = eSmesNew(REPLY, NULL, mid, ENV_STR, OFF, NULL, NULL,
		  NORMAL_STR, NULL, all_name);
  if ( Smes == NULL ) return (EALLOC);

  status = eQAdmPut(RTN_SMES_Q, Smes);
  if ( status != NORMAL ) return (status);

  return (NORMAL);
}


/*
 * get_instance_names_proc()
 */
static
int
get_instance_names_proc(SMessage Smes)
{
  SMessage	newSmes, Smes_for_prm;
  SMTo	to_field;
  char	*debug, *mid, *from, *template_name, *method;
  char	*to_aid, *new_method = NULL;
  char	*current_env, *my_aid, *Ames;
  int	size, rpc_id;
  int	status;

  debug = eSmesGetSdebug(Smes);
  mid = eSmesGetSmid(Smes);
  from = eSmesGetSfrom(Smes);
  template_name = eSmesGetSdata(Smes);

  newSmes = eSmesNew(ASK, debug, mid, from, OFF, template_name,
		     NULL, NULL, NULL, NULL);
  if ( newSmes == NULL ) return (EALLOC);

  /* move to bottom env */
  eAidAdmMoveToBottomEnv();

  to_field = eSmesGetSto(newSmes);
  method = eSmesGetSmethod(newSmes);
  from = eSmesGetSfrom(newSmes);

  while ( 1 ) {
    current_env = eAidAdmGetAidOfCurrentEnv();    

    to_aid = eAgntDirSearchAgentId(newSmes, current_env, mid, from,
                                   to_field, method,
				   &new_method, &Smes_for_prm);
    if ( to_aid == NULL ) {
      if ( eAidAdmMoveToAidOfUpperEnv() == TOP_ENV ) {
	/* template_name was nothing */
      }
      else {
	continue;
      }
    }
    else break;
  }

  /* to_aid is template_aid */
  my_aid = eAidAdmGetMyProcAid();
  
  status = eAmesNew(my_aid, to_aid, GET_ALL_INSTANCE_NAME,
		    current_env, mid, NULL, &Ames, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(to_aid, &rpc_id, Ames, size);
  status = eSendErrorCheck(status, Ames, to_aid, size);
  if ( status != NORMAL ) return (ERROR);

  return (NORMAL);
}


/*
 * get_global_const_proc()
 */
static
int
get_global_const_proc(SMessage Smes)
{
  SMessage	replySmes;
  char	*env, *const_name, *const_type, *const_value;
  char	*debug, *from, *mid;
  int	mflag, status;

  debug = eSmesGetSdebug(Smes);
  from = eSmesGetSfrom(Smes);
  mid = eSmesGetSmid(Smes);
  mflag = eSmesGetSmflag(Smes);

  const_name = eSmesGetSdata(Smes);

  eAidAdmMoveToBottomEnv();
  do {
    env = eAidAdmGetAidOfCurrentEnv();

    /* global constant pool interface */
    const_value = get_value(env, const_name, &const_type);
    if ( const_value != NULL ) break;
    if ( eAidAdmMoveToAidOfUpperEnv() == TOP_ENV ) break;
  } while ( 1 );

  replySmes = eSmesNew(REPLY, debug, mid, ENV_STR, mflag, from,
		       NULL, NORMAL_STR, NULL, const_value);
  if ( replySmes == NULL ) return (EALLOC);

  eSmesDelete(Smes);
  free(const_type);

  status = eQAdmPut(RTN_SMES_Q, replySmes);
  return (status);
}


/*
 * get_my_name_proc()
 */
static
int
get_my_name_proc(SMessage Smes)
{
  SMessage	replySmes;
  char	*my_name;
  char	*debug, *from, *mid;
  int	mflag, status;

  debug = eSmesGetSdebug(Smes);
  from = eSmesGetSfrom(Smes);
  mid = eSmesGetSmid(Smes);
  mflag = eSmesGetSmflag(Smes);

  my_name = eAidAdmGetMyName();

  replySmes = eSmesNew(REPLY, debug, mid, ENV_STR, mflag, from,
		       NULL, NORMAL_STR, GET_MY_NAME, my_name);
  if ( replySmes == NULL ) return (EALLOC);

  eSmesDelete(Smes);

  status = eQAdmPut(RTN_SMES_Q, replySmes);
  return (status);
}

/*** END OF FILE ***/






