/*
 * file name : eTimeOut.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eBagOf.h"
#include	"eTimeObj.h"
#include	"eMidObj.h"
#include	"eQAdm.h"
#include	"ePAdm.h"
#include	"eUpper.h"


#define	BAGOF_TIME	10000000

static int	time_out_time = BAGOF_TIME;
static int	on_off_flag = OFF;

/*
 * eTimeOutSetTime()
 */
void
eTimeOutSetTime(int time)
{
  time_out_time = time;
}


/*
 * eTimeOutGetTime()
 */
int
eTimeOutGetTime(void)
{
  return ( time_out_time );
}


/*
 * eTimeOutSwitch()
 */
void
eTimeOutSwitch(int flag)
{
  on_off_flag = flag;
}


/*
 * eTimeOutUse()
 */
int
eTimeOutUse(void)
{
  if ( on_off_flag == ON ) return (TRUE);
  return (FALSE);
}


/*
 * eTimeOutGenDataNum()
 */
int
eTimeOutGenDataNum(void)
{
  static int	s_num = 1;
  int	tmp;

  tmp = s_num;
  s_num += 2;
  return (tmp);
}


/*
 * eTimeOutRegister()
 */
int
eTimeOutRegister(int msec, int interval, int data, char *mid)
{
  TimeObj	*tp;

  tp = eTimeObjNew(data, mid);
  if ( tp == NULL ) return (EALLOC);

#ifndef ENV_DEBUG
  register_timer(msec, interval, data);
#endif
  return ( ePAdmPut(TIME_OBJ_POOL, tp) );
}


/*
 * eTimeOutProc()
 */
int
eTimeOutProc(int data)
{
  SMessage	Smes;
  MidObj	*mobj;
  TimeObj	*tp;
  char	*mid;
  int	status, mode;

  tp = ePAdmGet(TIME_OBJ_POOL, &data);
  if ( tp == NULL ) return (NORMAL);

  mid = eTimeObjGetMid(tp);
  mobj = ePAdmGet(BAGOF_MID_POOL, mid);
  if ( mobj == NULL ) {
    eTimeObjDelete(tp);
    return (NORMAL);
  }

  status = eBagOfTimeOutComposeResult(mobj, &Smes);
  if ( status != NORMAL ) return (status);

  mode = eMidObjGetFromUpperFlag(mobj);
  if ( mode == 0 && Smes != NULL ) {
    eQAdmPut(RTN_SMES_Q, Smes);
  }
  else if ( mode == 1 && Smes != NULL ) {
    eUpperSendReply(Smes, mobj);
  }

  eMidObjSetTimeOutFlag(mobj, 1);
  ePAdmPut(BAGOF_MID_POOL, mobj);

  eTimeObjDelete(tp);
  return (NORMAL);
}

/*** END OF FILE ***/
