/*
 * file name : eTimeObj.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<helios/envdef.h>
#include	"eTimeObj.h"
#include	"eUtil.h"


/*
 * eTimeObjNew()
 */
void*
eTimeObjNew(int data, char *mid)
{
  TimeObj	*tp;

  tp = (TimeObj*)malloc( sizeof(TimeObj) );
  if ( tp == NULL ) return (NULL);

  tp->data = data;

  if ( eUtilSetString(&(tp->mid), mid) == EALLOC )
    return (NULL);

  return (tp);
}


/*
 * eTimeObjDelete()
 */
void
eTimeObjDelete(TimeObj *target)
{
  if ( target->mid != NULL ) free(target->mid);
  target->data = 0;
  target->mid = NULL;
  free(target);
}


/*
 * eTimeObjGetData()
 */
int
eTimeObjGetData(TimeObj *target)
{
  return ( target->data );
}


/*
 * eTimeObjGetMid()
 */
char*
eTimeObjGetMid(TimeObj *target)
{
  return ( target->mid );
}


/*
 * eTimeObjMatch()
 */
int
eTimeObjMatch(void *target, void *lookfor)
{
  if ( ((TimeObj*)target)->data == *(int*)lookfor ) return (TRUE);
  return (FALSE);
}


/*
 * eTimeObjPrint()
 */
void
eTimeObjPrint(void *target)
{
  TimeObj *tp;

  tp = target;
  fprintf(stderr, "\tTimeObj\n");
  fprintf(stderr, "data = %d\n", tp->data);
  fprintf(stderr, "mid  = %s\n", tp->mid);
  return;
}

/*** END OF FILE ***/
