/*
 * file name: eSmes.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	<helios/envdef.h>
#include	"eSmes.h"
#include	"eUtil.h"

/*
 * SMESLIB is defined in Makefile
 */


/*** function definition ***/


/*
 * eSmesNew()
 */
SMessage
eSmesNew(int type, char *debug, char *mid, char *from, int  mflag, char *AF,
              char *management, char *ts, char *method, char *data)
{
#if	SMESLIB
  SMessage	Smes;

  Smes = CSMInit();
  if ( Smes == NULL ) return (NULL);

  if ( type == ASK ) CSMTypeAsk(Smes);
  else if ( type == REPLY ) CSMTypeReply(Smes);
  else if ( type == CONTROL ) CSMTypeControl(Smes);
  else {
    CSMDelete(Smes);
    return (NULL);
  }

  if ( CSMPutDebuginfoStr(Smes, debug) == NULL ) {
    return (NULL);
  }
  if ( CSMPutMidStr(Smes, mid) == NULL ) {
    return (NULL);
  }
  if ( CSMPutFromAidStr(Smes, from) == NULL ) {
    return (NULL);
  }

  if ( CSMPutToAFStr(Smes, AF) == NULL ) {
    return (NULL);
  }
  if(management != NULL && *management != '\n'){
    if ( CSMPutToManagementStr(Smes, management) == NULL ) {
      return (NULL);
    }
  }
  /* set method directory flag */
  if ( mflag == ON ) CSMSetToMethod(Smes);
  else if ( mflag == OFF ) CSMResetToMethod(Smes);
  else {
    CSMDelete(Smes);
    return (NULL);
  }

  if ( CSMIsTypeAsk(Smes) ) {
    if ( CSMPutTidStr(Smes, ts) == NULL ) {
      return (NULL);
    }
  }
  else if ( CSMIsTypeReply(Smes) ) {
    if ( CSMPutStatusStr(Smes, ts) == NULL ) {
      return (NULL);
    }
  }

  if ( CSMPutMethodStr(Smes, method) == NULL ) {
    return (NULL);
  }
  if ( CSMPutDataStr(Smes, data) == NULL ) {
    return (NULL);
  }
  
  return (Smes);

#else
  SMessage	Smes;

  Smes = (SMessage)malloc( sizeof(SMessage_m) );
  if ( Smes == NULL ) {
    return (NULL);
  }

  /* set type */
  Smes->mtype = (SMType)malloc( sizeof(SMType_m) );
  if ( Smes->mtype == NULL ) {
    return (NULL);
  }
  Smes->mtype->type = type;

  /* set debug */
  if ( eUtilSetString(&(Smes->mtype->debug), debug) == EALLOC )
    return (NULL);

  /* set mid */
  if ( eUtilSetString(&(Smes->mid), mid) == EALLOC )
    return (NULL);

  /* set from */
  if ( eUtilSetString(&(Smes->from), from) == EALLOC ) 
    return (NULL);

  /* set AF */
  Smes->to = (SMTo)malloc( sizeof(SMTo_m) );
  if ( Smes->to == NULL ) {
    return (NULL);
  }
  Smes->to->method = mflag;

  if ( eUtilSetString(&(Smes->to->AF), AF) == EALLOC )
    return (NULL);

  /* set management */
  if ( eUtilSetString(&(Smes->to->management), management) == EALLOC )
    return (NULL);

  /* set ts */
  if ( eUtilSetString(&(Smes->ts), ts) == EALLOC ) 
    return (NULL);
  
  /* set method */
  if ( eUtilSetString(&(Smes->method), method) == EALLOC ) 
    return (NULL);

  /* set data */
  if ( eUtilSetString(&(Smes->data), data) == EALLOC )
    return (NULL);

  return (Smes);
#endif
}


/*
 * eSmesDelete()
 */
void
eSmesDelete(SMessage Smes)
{
#if	SMESLIB
  CSMDelete(Smes);

#else
  if ( Smes == NULL ) return;
  if ( Smes->mtype != NULL ) {
    if ( Smes->mtype->debug ) free(Smes->mtype->debug);
    Smes->mtype->debug = NULL;
    Smes->mtype->type  = 0;
    free(Smes->mtype);
  }
  if ( Smes->mid != NULL ) free(Smes->mid);
  if ( Smes->from != NULL ) free(Smes->from);
  if ( Smes->to != NULL ) {
    if ( Smes->to->AF != NULL ) free(Smes->to->AF);
    if ( Smes->to->management ) free(Smes->to->management);
    Smes->to->AF = NULL;
    Smes->to->management = NULL;
    free(Smes->to);
  }
  if ( Smes->ts != NULL ) free(Smes->ts);
  if ( Smes->method != NULL ) free(Smes->method);
  if ( Smes->data != NULL ) free(Smes->data);
  Smes->mtype = NULL;
  Smes->mid = NULL;
  Smes->from = NULL;
  Smes->to = NULL;
  Smes->ts = NULL;
  Smes->method = NULL;
  Smes->data = NULL;
  free(Smes);
#endif
}


/*
 * eSmesDuplicate()
 */
SMessage
eSmesDuplicate(SMessage Smes)
{
  SMessage	newSmes;
  int	type, mflag;
  char	*debug, *mid, *from, *AF, *manag, *ts, *method, *data;

  mflag = eSmesGetSmflag(Smes);
  type = eSmesGetStype(Smes);
  debug = eSmesGetSdebug(Smes);
  mid = eSmesGetSmid(Smes);
  from = eSmesGetSfrom(Smes);
  AF = eSmesGetSAF(Smes);
  manag = eSmesGetSmanag(Smes);
  ts = eSmesGetSts(Smes);
  method = eSmesGetSmethod(Smes);
  data = eSmesGetSdata(Smes);

  newSmes = eSmesNew(type, debug, mid, from, mflag, AF,
                     manag, ts, method, data);
  return (newSmes);
}


/*
 * eSmesSetSmethod()
 */
int
eSmesSetSmethod(SMessage Smes, char *method)
{
  Smes->method = (char*)malloc( strlen(method) + 1 );
  if ( Smes->method == NULL ) return(EALLOC);

  strcpy(Smes->method, method);
  return (NORMAL);
}


/*
 * eSmesSetSfrom()
 */
int
eSmesSetSfrom(SMessage Smes, char *from)
{
  Smes->from = (char*)malloc( strlen(from) + 1 );
  if ( Smes->from == NULL ) return(EALLOC);

  strcpy(Smes->from, from);
  return (NORMAL);
}


/*
 * eSmesSetSAF()
 */
int
eSmesSetSAF(SMessage Smes, char *AF)
{
  return ( eUtilSetString(&(Smes->to->AF), AF) );
}


/*
 * eSmesSetSmanag()
 */
int
eSmesSetSmanag(SMessage Smes, char *manag)
{
  return ( eUtilSetString(&(Smes->to->management), manag) );
}


/*
 * eSmesGetStype()
 */
int
eSmesGetStype(SMessage Smes)
{
#if	SMESLIB
  if ( CSMIsTypeAsk(Smes) ) return (ASK);
  else if ( CSMIsTypeReply(Smes) ) return (REPLY);
  else if ( CSMIsTypeControl(Smes) ) return (CONTROL);
  return (ERROR);
#else
  return (Smes->mtype->type);
#endif
}


/*
 * eSmesGetSdebug()
 */
char*
eSmesGetSdebug(SMessage Smes)
{
#if	SMESLIB
  return ( CSMGetDebuginfoStr(Smes) );
#else
  return (Smes->mtype->debug);
#endif
}


/*
 * eSmesGetSmid()
 */
char*
eSmesGetSmid(SMessage Smes)
{
#if	SMESLIB
  return( CSMGetMidStr(Smes) );
#else
  return (Smes->mid);
#endif
}


/*
 * eSmesGetSfrom()
 */
char*
eSmesGetSfrom(SMessage Smes)
{
#if	SMESLIB
  return( CSMGetFromAidStr(Smes) );
#else
  return (Smes->from);
#endif
}


/*
 * eSmesGetSto()
 */
SMTo
eSmesGetSto(SMessage Smes)
{
#if	SMESLIB
  return ( CSMGetTo(Smes) );
#else
  return ( Smes->to );
#endif
}


/*
 * eSmesGetSmflag()
 */
int
eSmesGetSmflag(SMessage Smes)
{
#if	SMESLIB
  if ( CSMGetToMethodStr(Smes) == NULL ) return (OFF);
  else return (ON);
#else
  return (Smes->to->method);
#endif
}


/*
 * eSmesGetSAF()
 */
char*
eSmesGetSAF(SMessage Smes)
{
#if	SMESLIB
  return( CSMGetToAFStr(Smes) );
#else
  return (Smes->to->AF);
#endif
}


/*
 * eSmesGetSmanag()
 */
char*
eSmesGetSmanag(SMessage Smes)
{
#if	SMESLIB
  return ( CSMGetToManagementStr(Smes) );
#else
  return (Smes->to->management);
#endif
}


/*
 * eSmesGetSts()
 */
char*
eSmesGetSts(SMessage Smes)
{
#if	SMESLIB
  if ( CSMIsTypeAsk(Smes) )
    return ( CSMGetTidStr(Smes) );
  else if ( CSMIsTypeReply(Smes) )
    return ( CSMGetStatusStr(Smes) );
#else
  return (Smes->ts);
#endif
}


/*
 * eSmesGetSmethod()
 */
char*
eSmesGetSmethod(SMessage Smes)
{
#if	SMESLIB
  return( CSMGetMethodStr(Smes) );
#else
  return (Smes->method);
#endif
}


/*
 * eSmesGetSdata()
 */
char*
eSmesGetSdata(SMessage Smes)
{
#if	SMESLIB
  return ( CSMGetDataStr(Smes) );
#else
  return (Smes->data);
#endif
}


/*
 * eSmesPrint()
 */
void
eSmesPrint(SMessage Smes)
{
  if ( Smes == NULL ) return;
  fprintf(stderr, "     SMessage\n");
  fprintf(stderr, "Smes type       = %d\n", eSmesGetStype(Smes));
  fprintf(stderr, "Smes debug      = %s\n", eSmesGetSdebug(Smes));
  fprintf(stderr, "Smes mid        = %s\n", eSmesGetSmid(Smes));
  fprintf(stderr, "Smes from       = %s\n", eSmesGetSfrom(Smes));
  fprintf(stderr, "Smes mflag      = %d\n", eSmesGetSmflag(Smes));
  fprintf(stderr, "Smes AF         = %s\n", eSmesGetSAF(Smes));
  fprintf(stderr, "Smes management = %s\n", eSmesGetSmanag(Smes));
  fprintf(stderr, "Smes ts         = %s\n", eSmesGetSts(Smes));
  fprintf(stderr, "Smes method     = %s\n", eSmesGetSmethod(Smes));
  fprintf(stderr, "Smes data       = %s\n", eSmesGetSdata(Smes));
  fprintf(stderr, "\n");
}


/*
 * eSmesIsBagOf()
 */
int
eSmesIsBagOf(SMessage Smes)
{
  char	*management;

  management = eSmesGetSmanag(Smes);
  if ( management == NULL ) return (FALSE);
  if ( strcmp(management, BAGOF_STR) ) return (FALSE);
  return (TRUE);
}


/*
 * eSmesIsBagOf2()
 */
int
eSmesIsBagOf2(SMessage Smes)
{
  char	*management;

  management = eSmesGetSmanag(Smes);
  if ( management == NULL ) return (FALSE);
  if ( strcmp(management, BAGOF2_STR) ) return (FALSE);
  return (TRUE);
}


/*
 * eSmesIsBagOfNum()
 */
int
eSmesIsBagOfNum(SMessage Smes)
{
  char	*management;

  management = eSmesGetSmanag(Smes);
  if ( management == NULL ) return (FALSE);
  if ( strncmp(management, BAGOFNUM_STR, strlen(BAGOFNUM_STR)) ) {
    return (FALSE);
  }
  return (TRUE);
}


/*
 * eSmesIsFast()
 */
int
eSmesIsFast(SMessage Smes)
{
  char	*management;

  management = eSmesGetSmanag(Smes);
  if ( management == NULL ) return (FALSE);
  if ( strcmp(management, FAST_STR) ) return (FALSE);
  return (TRUE);
}


/*
 * eSmesIsSeq()
 */
int
eSmesIsSeq(SMessage Smes)
{
  char	*management;

  management = eSmesGetSmanag(Smes);
  if ( management == NULL ) return (FALSE);
  if ( strcmp(management, SEQ_STR) ) return (FALSE);
  return (TRUE);
}


/*
 * eSmesIsEnv()
 */
int
eSmesIsEnv(SMessage Smes)
{
  char	*to;

  to = eSmesGetSAF(Smes);
  if ( to == NULL ) return(FALSE);
  if ( strcmp(to, ENV_STR) ) return(FALSE);
  return (TRUE);
}

/*** END OF FILE ***/
