/*
 * file name: eSeq.c
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<helios/envdef.h>
#include	"eSeq.h"
#include	"eEnv.h"
#include	"eESObj.h"
#include	"eMidObj.h"
#include	"eSMessage.h"
#include	"eSmes.h"
#include	"eAidAdm.h"
#include	"eAgntDir.h"
#include	"eDispatch.h"
#include	"ePAdm.h"
#include	"eQAdm.h"
#include	"eInterEnv.h"
#include	"eAmes.h"
#include	"ePrm.h"
#include	"eTrace.h"
#include	"ePrmAidObj.h"
#include	"eUpper.h"


/*
 * eSeqSendProc()
 *    mode == 0 : message from substance
 *    mode == 1 : message from upper environment
 */
int
eSeqSendProc(SMessage Smes, int mode, char *Afrom, char *env)
{
  SMessage	rSmes, Smes_for_prm;
  SMTo	to_field;
  MidObj	*mobj;
  char	*func, *management;
  char	*to_aid, *current_env, *mid, *from, *method, *new_method = NULL;
  char  *from_aid;
  int	status;

  if ( mode == 0 ) {
    eAidAdmMoveToBottomEnv();
  }
  else if ( mode == 1 ) {
    eAidAdmSetAidOfCurrentEnv(env);
  }

  if ( ePrmIsParam() == TRUE ) {
    eAidAdmMoveToAidOfUpperEnv();
  }

  current_env = eAidAdmGetAidOfCurrentEnv();
  mid = eSmesGetSmid(Smes);
  to_field = eSmesGetSto(Smes);
  method = eSmesGetSmethod(Smes);
  from = eSmesGetSfrom(Smes);
  func = eSmesGetSAF(Smes);
  management = eSmesGetSmanag(Smes);

  if ( mode == 0 ) {
    from_aid = eAidAdmGetMyProcAid();
  }
  else if ( mode == 1 ) {
    from_aid = NULL;
  }

  to_aid = eAgntDirSearchAgentId(Smes, current_env, mid, from, to_field,
                                 method, &new_method, &Smes_for_prm);

  /* not send myself */
  if ( from_aid != NULL && to_aid != NULL && !strcmp(to_aid, from_aid) ) {
    free(to_aid);
    if ( new_method != NULL ) free(new_method);
    new_method = NULL;
    to_aid = eAgntDirSearchAgentId(Smes, current_env, mid, from,
                                   to_field, method, 
				   &new_method, &Smes_for_prm);
  }

  if ( to_aid == NULL && mode == 0 ) {
    rSmes = eSmesNew(REPLY, NULL, mid, "func", ON, 
                       NULL, NULL, "no_substance", "method", NULL);
    if ( rSmes == NULL ) return (EALLOC);
    if ( new_method != NULL ) free(new_method);
    eQAdmPut(RTN_SMES_Q, rSmes);
    eSmesDelete(Smes);
    return (NORMAL);
  }
  else if ( to_aid == NULL && mode == 1 ) {
    /* bad description of CAPL!! */
    /* not implemeted yet!! */
  }
  else if ( ePrmAidObjIsPrmAid(to_aid) == TRUE &&
	    Smes_for_prm == NULL ) {
    if ( mode == 0 ) {
      from_aid = NULL;
    }
    else if ( mode == 1 ) {
      from_aid = Afrom;
    }
    status = eInterEnvSendToPrm(SEQ_MID_POOL, to_aid, current_env,
				from_aid, Smes);
    free(to_aid);
    return (status);
  }
  else {
    if ( Smes_for_prm == NULL ) {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes, new_method);
      }
      status = eDispatchSendSmes(Smes, to_aid, NULL);
    }
    else {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes_for_prm, new_method);
      }
      status = eDispatchSendSmes(Smes_for_prm, to_aid, NULL);
    }

    if ( status != NORMAL ) return (status);
    free(to_aid);

    if ( mode == 0 ) {
      from_aid = eAidAdmGetMyProcAid();
    }
    else if ( mode == 1 ) {
      from_aid = Afrom;
    }

    mobj = eMidObjNew(mid, from_aid, current_env, func, management);
    if ( mobj == NULL ) return (EALLOC);
    eMidObjSetFromUpperFlag(mobj, mode);
    eMidObjIncrTotalSendNum(mobj);
    ePAdmPut(SEQ_MID_POOL, mobj);
    if ( new_method != NULL && Smes_for_prm == NULL ) {
      free( eSmesGetSmethod(Smes) );
      eSmesSetSmethod(Smes, method);
      free(method);
      method = eSmesGetSmethod(Smes);
      free(new_method);
      new_method = NULL;
    }
    eMidObjSetSmes(mobj, Smes);
  }

  if ( mode == 0 ) {
    from_aid = eAidAdmGetMyProcAid();
  }
  else if ( mode == 1 ) {
    from_aid = NULL;
  }

  while ( 1 ) {
    to_aid = eAgntDirSearchAgentId(Smes, current_env, mid, from, to_field,
                                   method, &new_method, &Smes_for_prm);
    if ( to_aid == NULL ) {
      if ( new_method != NULL ) free(new_method);
      break;
    }

    if ( mode == 0 && !strcmp(to_aid, from_aid) ) {
      free(to_aid);
      if ( new_method != NULL ) free(new_method);
      new_method = NULL;
      continue;
    }

    if ( ePrmAidObjIsPrmAid(to_aid) == TRUE && 
	 Smes_for_prm == NULL ) {
      status = eInterEnvSendToPrm2(mobj, to_aid, current_env, Smes);
      free(to_aid);
      return (status);
    }

    if ( Smes_for_prm == NULL ) {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes, new_method);
      }
      status = eDispatchSendSmes(Smes, to_aid, NULL);
    }
    else {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes_for_prm, new_method);
      }
      status = eDispatchSendSmes(Smes_for_prm, to_aid, NULL);
      eSmesDelete(Smes_for_prm);
    }

    if ( status != NORMAL ) return (status);
    free(to_aid);

    eMidObjIncrTotalSendNum(mobj);
    if ( new_method != NULL && Smes_for_prm == NULL ) {
      free( eSmesGetSmethod(Smes) );
      eSmesSetSmethod(Smes, method);
      free(method);
      method = eSmesGetSmethod(Smes);
      free(new_method);
      new_method = NULL;
    }
  }
  eSmesDelete(Smes);
  return (NORMAL);
}


/*
 * eSeqSendProcToPrm()
 */
int
eSeqSendProcToPrm(MidObj *mobj, char *Ames)
{
  SMessage	orgSmes, Smes, Smes_for_prm;
  SMTo	to_field;
  char	*AF, *management;
  char	*mid, *env, *method, *new_method = NULL, *from;
  char	*all_name_aid, *to_aid, *inst_name, *inst_aid;
  char	*my_aid;
  int	i=0, status;
  int	mode;

  mode = eMidObjGetFromUpperFlag(mobj);

  if ( mode == 0 ) {
    my_aid = eAidAdmGetMyProcAid();
  }
  else if ( mode == 1 ) {
    my_aid = "-----";
  }

  all_name_aid = eAmesGetAInfo(Ames);
  orgSmes = eMidObjGetSmes(mobj);
  Smes = eSmesDuplicate(orgSmes);

  inst_name = strtok(all_name_aid, " ");
  while ( inst_name ) {
    i++;
    AF = eSmesGetSAF(Smes);
    management = eSmesGetSmanag(Smes);
    free(AF);
    free(management);
    status = eSmesSetSAF(Smes, inst_name);
    if ( status != NORMAL ) return (status);
    status = eSmesSetSmanag(Smes, NULL);
    if ( status != NORMAL ) return (status);

    inst_aid = strtok(NULL, " ");
    to_aid = inst_aid;

    if ( strcmp(my_aid, inst_aid) ) {
      if ( i != 1 ) {
	eMidObjIncrTotalSendNum(mobj);
      }

      status = eDispatchSendSmes(Smes, to_aid, NULL);
      if ( status != NORMAL ) return (status);
    }

    inst_name = strtok(NULL, " ");
  }
  eSmesDelete(Smes);

  mid = eMidObjGetMid(mobj);
  env = eMidObjGetEnv(mobj);
  method = eSmesGetSmethod(orgSmes);
  from = eAidAdmGetMyProcAid();
  to_field = eSmesGetSto(orgSmes);

  while ( 1 ) {
    to_aid = eAgntDirSearchAgentId(orgSmes, env, mid, 
				   from, to_field, method,
				   &new_method, &Smes_for_prm);
    if ( to_aid == NULL ) {
      if ( new_method != NULL )  free(new_method);
      break;
    }
    
    if ( mode == 0 && !strcmp(to_aid, from) ) {
      /* not send myself */
      free(to_aid);
      if ( new_method != NULL ) free(new_method);
      new_method = NULL;
      continue;
    }

    if ( ePrmAidObjIsPrmAid(to_aid) == TRUE ) {
      status = eInterEnvSendToPrm2(mobj, to_aid, env, orgSmes);
      free(to_aid);
      return (status);
    }
    
    if ( new_method != NULL ) {
      eSmesSetSmethod(Smes, new_method);
    }

    status = eDispatchSendSmes(Smes, to_aid, NULL);
    if ( status != NORMAL ) return (status);
    
    eMidObjIncrTotalSendNum(mobj);
    if ( new_method != NULL ) {
      free( eSmesGetSmethod(Smes) );
      eSmesSetSmethod(Smes, method);
      free(method);
      method = eSmesGetSmethod(Smes);
      free(new_method);
      new_method = NULL;
    }
    free(to_aid);
  }
  free(Ames);
  eSmesDelete(Smes);
  return (NORMAL);
}


/*
 * eSeqRecvProc()
 */
int
eSeqRecvProc(ESObj *sobj, MidObj *mobj)
{
  SMessage	endSmes, Smes;
  char	*env;
  char	*mid, *func, *from_proc;
  int	total_num, recv_num;
  int 	mode;

  mode = eMidObjGetFromUpperFlag(mobj);

  if ( mode == 0 ) {
    /* move to bottom env and convert S_message */
    eEnvMoveToBottomEnv(sobj);
  }
  else if ( mode == 1 ) {
    env = eESObjGetEnv(sobj);
    Smes = eESObjGetSmes(sobj);
    eTraceMessage(env, Smes);
  }

  /* increment number of reply message */
  eMidObjIncrRecvNum(mobj);

  if ( mode == 0 ) {
    eQAdmPut(RTN_SMES_Q, eESObjGetSmes(sobj) );
  }
  else if ( mode == 1 ) {
    eUpperSendReply(eESObjGetSmes(sobj), mobj);
  }

  eESObjDeleteExceptSmes(sobj);

  total_num = eMidObjGetTotalSendNum(mobj);
  recv_num = eMidObjGetRecvNum(mobj);

  if ( total_num == recv_num ) {
    mid = eMidObjGetMid(mobj);
    func = eMidObjGetFunc(mobj);
    from_proc = eMidObjGetFromProc(mobj);

    /* make Smes for end of all result */
    endSmes = eSmesNew(REPLY, NULL, mid, from_proc, OFF, 
                       NULL, NULL, NORMAL_STR, NULL, "end_async");
    if ( endSmes == NULL ) return (EALLOC);

    if ( mode == 0 ) {
      eQAdmPut(RTN_SMES_Q, endSmes);
    }
    else if ( mode == 1 ) {
      eUpperSendReply(endSmes, mobj);
    }

    ePAdmGet(SEQ_MID_POOL, mid); /* don't delete */
    eMidObjDelete(mobj);
  }
  return (NORMAL);
}

/*** END OF FILE ***/
