/*
 * file name : eSendError.c
 *
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<errno.h>
#include	<helios/envdef.h>
#include	"eSendError.h"
#include	"eWaitObj.h"
#include	"eQAdm.h"

#include	"eAmes.h"

/*
 * eSendErrorCheck()
 */
int
eSendErrorCheck(int status, char *Ames, char *to_aid, int size)
{
  WaitObj	*wp;

  if ( status == -ENOENT ) { /* agent is nothing */
/*** for dbg ***
fprintf(stderr, "send_a_message() rtn = -ENOENT\n");
eAmesPrintHdr(Ames);
***************/
    free(Ames);
    status = NOAGENT;
  }
  else if ( status == -EAGAIN || status == -ENOMEM ) { /* send error */
						       /* */
/*** for dbg ***
fprintf(stderr,"send_message() rtn = -EAGAIN or -ENOMEM\n");
eAmesPrintHdr(Ames);
***************/
    /* if write will be ready, this message will be sent */
    wp = eWaitObjNew(Ames, to_aid, size);
    if ( wp == NULL ) return (EALLOC);
    eQAdmPut(WAIT_OBJ_Q, wp);
    status = NORMAL;
  }
  else { /* send ok */
/*** for dbg ***
fprintf(stderr,"send_a_message() OK\n");
**************/
    free(Ames);
    status = NORMAL;
  }
  return (status);
}

/*** END OF FILE ***/
