/*
 * file name: eRSmes.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eRSmes.h"
#include	"eRAmes.h"
#include	"eAmes.h"
#include	"eSAConv.h"
#include	"eEAObj.h"
#include	"eESObj.h"
#include	"eQAdm.h"
#include	"eSMessage.h"


/*
 * eRSmesMake()
 */
int
eRSmesMake(void)
{
  SMessage	Smes;
  ESObj	*sop;
  char	*from_proc, *to_proc, *env, *info, *Ames;
  int	rpc_id, size;
  int	status;

  while ( 1 ) {
    status = eRAmesGet(&Ames, &size, &rpc_id);
    if ( status == ERROR ) break;

    from_proc = eAmesGetAFrom(Ames);
    to_proc = eAmesGetATo(Ames);
    env = eAmesGetAEnv(Ames);
    info = eAmesGetAInfo(Ames);
    Smes = eSAConvAtoS(Ames);
    if ( Smes == NULL ) return (ERROR);

    sop = eESObjNew(Smes, rpc_id, from_proc, to_proc, env, info);
    if ( sop == NULL ) return (ERROR);

    eAmesDelete(Ames);

    eQAdmPut(ESOBJ_QUEUE, sop);
  }
  return (NORMAL);
}

/*** END OF FILE ***/
