/*
 * file name: eRAmes.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<helios/envdef.h>
#include	"eRAmes.h"
#include	"eEAObj.h"
#include	"eESObj.h"
#include	"ePAdm.h"
#include	"eCom.h"

/*** for dbg ****/
int	Ames_cnt=0;
/****************/

static	char	s_buf[ENV_BUF_SIZE];


/*
 * eRAmesReadAll()
 */
int
eRAmesReadAll(void)
{
  EAObj	*op;
  char	*Ames;
  int	size, rpc_id, status;

  while ( 1 ) {
    size = ENV_BUF_SIZE;
    bzero(s_buf, ENV_BUF_SIZE);

    status = eComRecvAMessage(&rpc_id, s_buf, &size);
    if ( status < 0 ) break;

    Ames = (char*)malloc(size);
    if ( Ames == NULL ) return (EALLOC);

    bcopy(s_buf, Ames, size);

    op = eEAObjNew(Ames, size, rpc_id);
    if ( op == NULL ) {
      return (EALLOC);
    }
    ePAdmPut(EAOBJ_POOL, op);
  }
  return (NORMAL);
}


/*
 * eRAmesGet()
 */
int
eRAmesGet(char **Ames, int *size, int *rpc_id)
{
  EAObj	*op;

  op = ePAdmGet(EAOBJ_POOL, NULL);
  if ( op == NULL ) return (ERROR);

  *Ames = eEAObjGetAmes(op);
  *size = eEAObjGetSize(op);
  *rpc_id = eEAObjGetRpcId(op);
  
  eEAObjDeleteExceptAmes(op);
  return (NORMAL);
}


/*
 * eRAmesCntlNotNormal()
 */
int
eRAmesCntlNotNormal(char **Ames, int *size, int *rpc_id)
{
  EAObj	*op;

  op = ePAdmGet(EAOBJ_POOL, "not_normal");
  if ( op == NULL ) return (ERROR);

  *Ames = eEAObjGetAmes(op);
  *size = eEAObjGetSize(op);
  *rpc_id = eEAObjGetRpcId(op);
  return (NORMAL);
}

/*** END OF FILE ***/
