/*
 * file name: eQueue.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eQueue.h"
#include	"eLL.h"

/*
 * eQueueNew()
 */
void*
eQueueNew( void (*print)() )
{
  return ( eLLNew(NULL, print) );
}


/*
 * eQueueDelete()
 */
void
eQueueDelete(Queue *target)
{
  eLLDelete((LinkedList*)target);
}


/*
 * eQueuePut()
 */
int
eQueuePut(Queue *target, void *object)
{
  return ( eLLAddTail((LinkedList*)target, object) );
}


/*
 * eQueuePutBack()
 */
int
eQueuePutBack(Queue *target, void *object)
{
  return ( eLLAddHead((LinkedList*)target, object) );
}


/*
 * eQueueGet()
 */
void*
eQueueGet(Queue *target)
{
  return ( eLLRetrieveHead((LinkedList*)target) );
}


/*
 * eQueuePrint()
 */
void
eQueuePrint(Queue *target)
{
  eLLPrint(target);
}

/*** END OF FILE ***/


