/*
 * file name : eQAdm.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eQAdm.h"
#include	"eQueue.h"

static	Queue	*QArray[256];

/*** staitc function ***/
static	void	registerQ(int Qid, Queue *qobj);
static  Queue*	getQ(int Qid);

/*
 * eQAdmInit()
 */
int
eQAdmInit(int targetID, void (*print)())
{
  Queue	*queue;

  queue = eQueueNew(print);
  if ( queue == NULL ) return(EALLOC);

  registerQ(targetID, queue);
  return (NORMAL);
}


/*
 * eQAdmPut()
 */
int
eQAdmPut(int targetID, void *obj)
{
  Queue	*queue;
  queue = getQ(targetID);
  return ( eQueuePut(queue, obj) );
}


/*
 * eQAdmPutBack()
 */
int
eQAdmPutBack(int targetID, void *obj)
{
  Queue	*queue;

  queue = getQ(targetID);
  return ( eQueuePutBack(queue, obj) );
}


/*
 * eQAdmGet()
 */
void*
eQAdmGet(int targetID)
{
  Queue	*queue;

  queue = getQ(targetID);
  return ( eQueueGet(queue) );
}


/*
 * registerQ()
 */
static
void
registerQ(int Qid, Queue *Qobj)
{
  QArray[Qid] = Qobj;
}


/*
 * getQ()
 */
static
Queue*
getQ(int Qid)
{
  return (QArray[Qid]);
}

/*** END OF FILE ***/
