/*
 * file name : ePrmAidObj.c
 *
 */
#include	<stdio.h>
#include	<helios/envdef.h>
#include	"ePrmAidObj.h"
#include	"ePAdm.h"
#include	"eUtil.h"


/*
 * ePrmAidObjNew()
 */
void*
ePrmAidObjNew(char *env_id, char *agent_id, char *template_name)
{
  PrmAidObj	*op;
  int	status;

  op = (PrmAidObj*)malloc( sizeof(PrmAidObj) );
  if ( op == NULL ) return (NULL);

  status = eUtilSetString(&(op->env_id), env_id);
  if ( status == EALLOC ) return (NULL);

  status = eUtilSetString(&(op->agent_id), agent_id);
  if ( status == EALLOC ) return (NULL);
  
  status = eUtilSetString(&(op->template_name), template_name);
  if ( status == EALLOC ) return (NULL);

  return (op);
}


/*
 * ePrmAidObjDelete()
 */
void
ePrmAidObjDelete(PrmAidObj *target)
{
  if ( target == NULL ) return;

  if ( target->env_id != NULL ) {
    free(target->env_id);
    target->env_id = NULL;
  }

  if ( target->agent_id != NULL ) {
    free(target->agent_id);
    target->agent_id = NULL;
  }

  if ( target->template_name != NULL ) {
    free(target->template_name);
    target->template_name = NULL;
  }

  free(target);
}


/*
 * ePrmAidObjGetEnvID()
 */
char*
ePrmAidObjGetEnvID(PrmAidObj *target)
{
  return (target->env_id);
}


/*
 * ePrmAidObjGetAgentID()
 */
char*
ePrmAidObjGetAgentID(PrmAidObj *target)
{
  return (target->agent_id);
}


/*
 * ePrmAidObjGetTempName()
 */
char*
ePrmAidObjGetTempName(PrmAidObj *target)
{
  return (target->template_name);
}


/*
 * ePrmAidObjMatch()
 */
int
ePrmAidObjMatch(void *target, void *lookfor)
{
  PrmAidObj	*op;

  op = target;
  if ( !strcmp(op->agent_id, (char*)lookfor) ) return (TRUE);
  return (FALSE);
}


/*
 * ePrmAidObjPrint()
 */
void
ePrmAidObjPrint(void *target)
{
  PrmAidObj	*op;

  op = target;
  fprintf(stderr, "\tPrmAidObj\n");
  fprintf(stderr, "env_id = %s\n", op->env_id);
  fprintf(stderr, "agent_id = %s\n", op->agent_id);
  fprintf(stderr, "template_name = %s\n", op->template_name);
}


/*
 * ePrmAidObjIsPrmAid()
 */
int
ePrmAidObjIsPrmAid(char *aid)
{
  PrmAidObj	*op;

  op = ePAdmGet(PRMAID_OBJ_POOL, aid);
  if ( op == NULL ) return (FALSE);

  ePAdmPut(PRMAID_OBJ_POOL, op);
  return (TRUE);
}

/*** END OF FILE ***/
