/*
 * file name : ePrm.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"ePrm.h"
#include	"eQueue.h"
#include	"eUtil.h"

/* for representative element of parametric agent */
static	char	*s_template_name = NULL;
static	char	*s_env_id = NULL;
static	char	*s_max_agent_id = NULL;
static	int	s_max_local_id = 0;
static	Queue	*s_old_instance_Q = NULL;
static	Queue	*s_new_instance_Q = NULL;
static	int	s_ack_recv_cnt = 0;
static	char	*s_user_id = NULL;

/* for all instances of template agent */
static	char	*s_my_parameter = NULL;

static	int	prmflag = FALSE;


/*
 * ePrmSetMyParameter()
 */
int
ePrmSetMyParameter(char *parameter)
{
  return ( eUtilSetString(&s_my_parameter, parameter) );
}


/*
 * ePrmGetMyParameter()
 */
char*
ePrmGetMyParameter(void)
{
  return ( s_my_parameter );
}


/*
 * ePrmSetTempName()
 */
int
ePrmSetTempName(char *template_name)
{
  return ( eUtilSetString(&s_template_name, template_name) );
}


/*
 * ePrmSetEnvID()
 */
int
ePrmSetEnvID(char *env_id)
{
  return ( eUtilSetString(&s_env_id, env_id) );
}


/*
 * ePrmSetUserID()
 */
int
ePrmSetUserID(char *user_id)
{
  return ( eUtilSetString(&s_user_id, user_id) );
}


/*
 * ePrmGetTempName()
 */
char*
ePrmGetTempName(void)
{
  return (s_template_name);
}


/*
 * ePrmGetEnvID()
 */
char*
ePrmGetEnvID(void)
{
  return (s_env_id);
}


/*
 * ePrmGetMaxAgentID()
 */
char*
ePrmGetMaxAgentID(void)
{
  return (s_max_agent_id);
}


/*
 * ePrmGetMaxID()
 */
int
ePrmGetMaxID(void)
{
  return (s_max_local_id);
}


/*
 * ePrmGetAckRecvCnt()
 */
int
ePrmGetAckRecvCnt(void)
{
  return (s_ack_recv_cnt);
}


/*
 * ePrmGetUserID()
 */
char*
ePrmGetUserID(void)
{
  return (s_user_id);
}


/*
 * ePrmSetAckRecvCnt()
 */
void
ePrmSetAckRecvCnt(int cnt)
{
  s_ack_recv_cnt = cnt;
}


/*
 * ePrmIncrID()
 */
int
ePrmIncrID(void)
{
  int	len;
  char	buf[16];
  char	*p;

  s_max_local_id++;
  if ( s_max_agent_id != NULL ) free(s_max_agent_id);

  if ( s_env_id == NULL ) return(ERROR);
  len = strlen(s_env_id);

  sprintf(buf, "%d", s_max_local_id);
  len += strlen(buf) + 2;
  p = (char*)malloc( len );
  if ( p == NULL ) return (EALLOC);

  strcpy(p, s_env_id);
  strcat(p, ".");
  strcat(p, buf);

  s_max_agent_id = p;
  return (NORMAL);
}


/*
 * ePrmPutOldInstance()
 */
int
ePrmPutOldInstance(char *name, char *id, char *parameter)
{
  PrmInstance	*op;
  int	status;

  op = (PrmInstance*)malloc( sizeof(PrmInstance) );
  if ( op == NULL ) return ( EALLOC );

  status = eUtilSetString(&(op->agent_name), name);
  if ( status == EALLOC ) return ( EALLOC );

  status = eUtilSetString(&(op->agent_id), id);
  if ( status == EALLOC ) return ( EALLOC );

  status = eUtilSetString(&(op->parameter), parameter);
  if ( status == EALLOC ) return ( EALLOC );

  if ( s_old_instance_Q == NULL ) {
    s_old_instance_Q = eQueueNew(ePrmInstancePrint);
    if ( s_old_instance_Q == NULL ) return (EALLOC);
  }

  status = eQueuePut(s_old_instance_Q, op);
  if ( status == EALLOC ) return ( EALLOC );

  return ( NORMAL );
}


/*
 * ePrmGetOldInstance()
 */
int
ePrmGetOldInstance(char **name, char **id, char **parameter)
{
  PrmInstance	*op;

  if ( s_old_instance_Q == NULL ) return (ERROR);

  op = eQueueGet(s_old_instance_Q);
  if ( op == NULL ) return (ERROR);

  *name = op->agent_name;
  *id = op->agent_id;
  *parameter = op->parameter;
  
  return ( NORMAL );
}


/*
 * ePrmPutNewInstance()
 */
int
ePrmPutNewInstance(char *name, char *id, char *parameter)
{
  PrmInstance	*op;
  int	status;

  op = (PrmInstance*)malloc( sizeof(PrmInstance) );
  if ( op == NULL ) return ( EALLOC );

  status = eUtilSetString(&(op->agent_name), name);
  if ( status == EALLOC ) return ( EALLOC );

  status = eUtilSetString(&(op->agent_id), id);
  if ( status == EALLOC ) return ( EALLOC );

  status = eUtilSetString(&(op->parameter), parameter);
  if ( status == EALLOC ) return ( EALLOC );

  if ( s_new_instance_Q == NULL ) {
    s_new_instance_Q = eQueueNew(ePrmInstancePrint);
    if ( s_new_instance_Q == NULL ) return (EALLOC);
  }

  status = eQueuePut(s_new_instance_Q, op);
  if ( status == EALLOC ) return ( EALLOC );

  return ( NORMAL );
}


/*
 * ePrmGetNewInstance()
 */
int
ePrmGetNewInstance(char **name, char **id, char **parameter)
{
  PrmInstance	*op;

  if ( s_new_instance_Q == NULL ) return (ERROR);

  op = eQueueGet(s_new_instance_Q);
  if ( op == NULL ) return ( ERROR );

  *name = op->agent_name;
  *id = op->agent_id;
  *parameter = op->parameter;

  return ( NORMAL );
}


/*
 * ePrmInstancePrint()
 */
void
ePrmInstancePrint(void *target)
{
  PrmInstance	*op;

  op = target;
  fprintf(stderr, "\tPrmInstance\n");
  fprintf(stderr, "agent_name = %s\n", op->agent_name);
  fprintf(stderr, "agent_id = %s\n", op->agent_id);
}


/*
 * ePrmSet()
 */
void
ePrmSet(void)
{
  prmflag = TRUE;
}


/*
 * ePrmIsParam()
 */
int
ePrmIsParam(void)
{
  return (prmflag);
}

/*** END OF FILE ***/
