/*
 * file name: ePool.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"ePool.h"
#include	"eLL.h"


/*
 * ePoolNew()
 */
void*
ePoolNew(int (*match)(), void (*print)() )
{
  return ( eLLNew(match, print) );
}


/*
 * ePoolDelete()
 */
void
ePoolDelete(Pool *target)
{
  eLLDelete( (LinkedList*)target );
}


/*
 * ePoolPut()
 */
int
ePoolPut(Pool *target, void *object)
{
  return ( eLLAddTail((LinkedList*)target, object) );
}


/*
 * ePoolGet()
 */
void*
ePoolGet(Pool *target, void *lookfor)
{
  if ( lookfor == NULL ) {
    return ( eLLRetrieveHead((LinkedList*)target) );
  }

  if ( eLLMatch((LinkedList*)target, lookfor) ) {
    return ( eLLRetrieveCurrent((LinkedList*)target) );
  }
  return (NULL);
}


/*
 * ePoolPrint()
 */
void
ePoolPrint(Pool *target)
{
  eLLPrint(target);
}

/*** END OF FILE ***/

