/*
 * file name : ePAdm.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"ePAdm.h"
#include	"ePool.h"

static	Pool	*PArray[256];

/*** static function ***/
static void	registerP(int Pid, Pool *Pobj);
static Pool*	getP(int Pid);

/*
 * ePAdmInit()
 */
int
ePAdmInit(int targetID, int (*match)(), void (*print)())
{
  Pool	*pool;

  pool = ePoolNew(match, print);
  if ( pool == NULL ) return (EALLOC);

  registerP(targetID, pool);
  return (NORMAL);
}


/*
 * ePAdmPut()
 */
int
ePAdmPut(int targetID, void *obj)
{
  Pool	*pool;

  pool = getP(targetID);
  return ( ePoolPut(pool, obj) );
}


/*
 * ePAdmGet()
 */
void*
ePAdmGet(int targetID, void *lookfor)
{
  Pool	*pool;

  pool = getP(targetID);
  return ( ePoolGet(pool, lookfor) );
}


/*
 * registerP()
 */
static
void
registerP(int Pid, Pool *Pobj)
{
  PArray[Pid] = Pobj;
}


/*
 * getP()
 */
static
Pool*
getP(int Pid)
{
  return (PArray[Pid]);
}

/*** END OF FILE ***/
