/*
 * file name: eNormal.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eNormal.h"
#include	"eESObj.h"
#include	"eAidAdm.h"
#include	"eMidObj.h"
#include	"eSmes.h"
#include	"eAgntDir.h"
#include	"eCapOfEnv.h"
#include        "eTrace.h"
#include        "eDispatch.h"
#include        "eEnv.h"
#include        "eQAdm.h"
#include	"eUtil.h"


/*
 * eNormalSendProc()
 */
int
eNormalSendProc(SMessage Smes)
{
  SMessage	upperSmes, currentSmes, SmesForPrm, Smes_for_prm;
  SMTo	to_field;
  char	*agt_log_name;
  char	*to_aid, *current_env, *mid, *from, *method, *new_method;
  int	to_is_prm;
  char	*p_dbg, *p_mid, *p_from, *p_ts, *p_mtd, *p_data, *template_name;
  char	*instance;
  int	p_type, p_mflag;
  int	status;
  char	*user_id, *tmp_mid; /* 10/25 */

  /* move to bottom env */
  eAidAdmMoveToBottomEnv();

  /* get agent logical name from S_message */
  agt_log_name = eSmesGetSAF(Smes);

  if ( (to_is_prm = eUtilIsLogNameParam(agt_log_name)) == TRUE ) {
    p_type = eSmesGetStype(Smes);
    p_dbg = eSmesGetSdebug(Smes);
    p_mid = eSmesGetSmid(Smes);
    p_from = eSmesGetSfrom(Smes);
    p_mflag = eSmesGetSmflag(Smes);
    p_ts = eSmesGetSts(Smes);
    p_mtd = eSmesGetSmethod(Smes);
    p_data = eSmesGetSdata(Smes);
    template_name = eUtilGetTemplateName(agt_log_name);
    instance = eUtilGetInstanceName(agt_log_name);
    SmesForPrm = eSmesNew(p_type, p_dbg, p_mid, p_from, p_mflag, template_name,
                          NULL, p_ts, p_mtd, p_data);
    if ( SmesForPrm == NULL ) return (EALLOC);
  }

  current_env = eAidAdmGetAidOfCurrentEnv();

  if ( to_is_prm == TRUE ) {
    currentSmes = SmesForPrm;
  }
  else {
    currentSmes = Smes;
  }
  while ( 1 ) {
    current_env = eAidAdmGetAidOfCurrentEnv();
    mid = eSmesGetSmid(currentSmes);
    to_field = eSmesGetSto(currentSmes);
    method = eSmesGetSmethod(currentSmes);
    from = eSmesGetSfrom(currentSmes);

    to_aid = eAgntDirSearchAgentId(currentSmes, current_env, mid, from,
                                   to_field, method, &new_method,
				   &Smes_for_prm);
    if ( to_aid == NULL ) {
      /* move to upper env, because entry is not in this env */
      /* convert Smessage. in-->out */
      upperSmes = eCapOfEnv(current_env, currentSmes, 1);

      if ( eAidAdmMoveToAidOfUpperEnv() == TOP_ENV ) {
	/* send this message to user, because this env is top */
/**** 10/25 ****/
        tmp_mid = eSmesGetSmid(upperSmes);
        user_id = eUtilGetUid(tmp_mid);
        if ( user_id == NULL ) return (EALLOC);

        status = eDispatchSendSmes(upperSmes, user_id, NULL);
        if ( status != NORMAL ) return (status);

        free(user_id);
        eSmesDelete(upperSmes);
        if ( new_method != NULL ) free(new_method);
        new_method = NULL;
        return (NORMAL);
/***************/
      }
      if ( upperSmes != NULL ) {
	currentSmes = upperSmes;
	eTraceMessage(current_env, upperSmes);
      }
      continue;
    }
    else {
      if ( new_method != NULL ) {
	eSmesSetSmethod(currentSmes, new_method);
	free(method);
      }
      if ( to_is_prm == TRUE ) {
	eSmesDelete(currentSmes);
	SmesForPrm = eSmesNew(p_type, p_dbg, p_mid, p_from, p_mflag,
			      instance, NULL, p_ts, p_mtd, p_data);
	if ( SmesForPrm == NULL ) return (EALLOC);
	currentSmes = SmesForPrm;
	eSmesDelete(Smes);
      }
      status = eDispatchSendSmes(currentSmes, to_aid, NULL);
      if ( status != NORMAL ) return (status);
      free(to_aid);

      eSmesDelete(currentSmes);
      return (NORMAL);
    }
  }
}


/*
 * eNormalRecvProc()
 */
int
eNormalRecvProc(ESObj *sobj)
{
  /* move bottom env and convert S_message */
  eEnvMoveToBottomEnv(sobj);

  /* store return Smes in queue */
  eQAdmPut(RTN_SMES_Q, eESObjGetSmes(sobj) );
  eESObjDeleteExceptSmes(sobj);

  return (NORMAL);
}


/*** END OF FILE ***/
