/*
 * file name: eMidObj.h
 *
 */

#ifndef	EMIDOBJ
#define EMIDOBJ

#include	"ePool.h"
#include	"eQueue.h"
#include	"eESObj.h"
#include	"eSMessage.h"

typedef struct _AidOfSameMid {
  char			*dest_aid;
  int			order;
} AidOfSameMid;

typedef	struct _Instance {
  char		*name;
  char		*aid;
  char		*template_name;
} Instance;

typedef	struct _MidObj {
  SMessage	Smes;
  char		*mid;
  char		*from_proc;
  char		*env;
  char		*func;
  char		management[16];
  char		*wait_prm_aid;
  Queue		*wait_ESObj_queue;
  Pool		*dest_aid_pool;
  Pool		*name_and_aid;
  int		effective_order;
  int		total_send_num;
  int		recv_num;
  int		normal_reply_num;
  int		time_out_flag;
  int		from_upper_flag;
} MidObj;

void*		eMidObjNew(char *mid, char *from_proc, char *env, char *func,
                           char *management);
void		eMidObjDelete(MidObj *target);

int		eMidObjSetWaitPrmAid(MidObj *target, char *aid);
char*		eMidObjGetWaitPrmAid(MidObj *target);

int		eMidObjESObjQPut(MidObj *target, ESObj *sobj);
ESObj*		eMidObjESObjQGet(MidObj *target);

int		eMidObjDestAidPPut(MidObj *target, char *dest_aid, int
				   order);
char*		eMidObjDestAidPGet(MidObj *target);
int		eMidObjGetOrderOfMatchedAid(MidObj *target, char *lookfor);
void		eMidObjInstancePrint(void *target);

int		eMidObjPutInstance(MidObj *target, char *name,
				   char *aid, char *template_name);
char*		eMidObjGetInstanceName(MidObj *target, char *aid,
				       char **template_name);
int		eMidObjMatchInstance(void *target, void *lookfor);

void		eMidObjSetSmes(MidObj *target, SMessage Smes);
void		eMidObjSetTimeOutFlag(MidObj *target, int flag);
void		eMidObjSetEffectiveOrder(MidObj *target, int efct_order);
void		eMidObjSetNormalReplyNum(MidObj *target, int num);
void		eMidObjSetFromUpperFlag(MidObj *target, int flag);

void		eMidObjIncrTotalSendNum(MidObj *target);
void		eMidObjIncrRecvNum(MidObj *target);
void		eMidObjIncrNormalReplyNum(MidObj *target);

SMessage	eMidObjGetSmes(MidObj *target);
char*		eMidObjGetMid(MidObj *target);
char*		eMidObjGetFromProc(MidObj *target);
char*		eMidObjGetEnv(MidObj *target);
char*		eMidObjGetFunc(MidObj *target);
char*		eMidObjGetManagement(MidObj *target);
int		eMidObjGetEffectiveOrder(MidObj *target);
int		eMidObjGetTotalSendNum(MidObj *target);
int		eMidObjGetRecvNum(MidObj *target);
int		eMidObjGetNormalReplyNum(MidObj *target);
int		eMidObjGetTimeOutFlag(MidObj *target);
int		eMidObjGetFromUpperFlag(MidObj *mobj);

int		eMidObjMatch(void *target, void *lookfor);
void		eMidObjPrint(void *target);

int		eMidObjMatchAid(void *target, void *lookfor);
void		eMidObjAidPrint(void *target);

#endif

/*** END OF FILE ***/
