/*
 * file name: eMidObj.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	<helios/envdef.h>
#include	"eMidObj.h"
#include	"eSmes.h"
#include	"eUtil.h"



/*** static function ***/
static	AidOfSameMid*	AidOfSameMid_get(MidObj *target);


/*
 * eMidObjNew()
 */
void*
eMidObjNew(char *mid, char *from_proc, char *env, char *func, char *management)
{
  MidObj	*op;

  op = (MidObj*)malloc( sizeof(MidObj) );
  if ( op == NULL ) return (NULL);

  op->Smes = NULL;

  if ( eUtilSetString(&(op->mid), mid) == EALLOC )
    return (NULL);

  if ( eUtilSetString(&(op->from_proc), from_proc) == EALLOC )
    return (NULL);

  if ( eUtilSetString(&(op->env), env) == EALLOC )
    return (NULL);

  if ( eUtilSetString(&(op->func), func) == EALLOC )
    return (NULL);

  if ( management == NULL ) {
    (op->management)[0] = NULL;
  }
  else {
    strcpy(op->management, management);
  }

  op->wait_prm_aid = NULL;
  op->wait_ESObj_queue = NULL;
  op->dest_aid_pool = NULL;
  op->name_and_aid = NULL;
  op->effective_order = 1;
  op->total_send_num = 0;
  op->recv_num = 0;
  op->normal_reply_num = 0;
  op->time_out_flag = FALSE;
  op->from_upper_flag = 0;

  return (op);
}

  
/*
 * eMidObjDelete()
 */
void
eMidObjDelete(MidObj *target)
{
  ESObj	*sobj;
  AidOfSameMid	*aidp;
  char	*name, *tn;

  if ( target == NULL ) return;
  if ( target->mid != NULL ) free(target->mid);
  if ( target->from_proc != NULL ) free(target->from_proc);
  if ( target->env != NULL ) free(target->env);
  if ( target->func != NULL ) free(target->func);
  while ( (sobj = eMidObjESObjQGet(target)) != NULL ) {
    eSmesDelete( eESObjGetSmes(sobj) );
    eESObjDeleteExceptSmes(sobj);
  }
  if ( target->wait_ESObj_queue != NULL )
    eQueueDelete(target->wait_ESObj_queue);
  if ( target->dest_aid_pool != NULL ) {
    while ( (aidp = AidOfSameMid_get(target)) != NULL ) {
      if ( aidp->dest_aid != NULL ) free(aidp->dest_aid);
      free(aidp);
    }
    ePoolDelete(target->dest_aid_pool);
  }
  if ( target->name_and_aid != NULL ) {
    while ( (name = eMidObjGetInstanceName(target, NULL, &tn)) != NULL ) {
      free(name);
      free(tn);
    }
    ePoolDelete(target->name_and_aid);
  }
  target->Smes = NULL;
  target->mid = NULL;
  target->from_proc = NULL;
  target->env = NULL;
  target->func = NULL;
  target->wait_ESObj_queue = NULL;
  target->dest_aid_pool = NULL;
  target->name_and_aid = NULL;
  target->effective_order = 0;
  target->total_send_num = 0;
  target->recv_num = 0;
  target->normal_reply_num = 0;
  target->time_out_flag = 0;
  free(target);
}


/*
 * eMidObjSetWaitPrmAid()
 */
int
eMidObjSetWaitPrmAid(MidObj *target, char *aid)
{
  if ( target->wait_prm_aid != NULL ) free(target->wait_prm_aid);

  if ( eUtilSetString(&(target->wait_prm_aid), aid) == EALLOC )
    return EALLOC;

  return NORMAL;
}


/*
 * eMidObjGetWaitPrmAid()
 */
char*
eMidObjGetWaitPrmAid(MidObj *target)
{
  return target->wait_prm_aid;
}


/*
 * eMidObjESObjQPut()
 */
int
eMidObjESObjQPut(MidObj *target, ESObj *sobj)
{
  Queue	*queue;

  if ( target->wait_ESObj_queue == NULL ) {
    queue = eQueueNew(eESObjPrint);
    if ( queue == NULL ) return (EALLOC);
    target->wait_ESObj_queue = queue;
  }
  else {
    queue = target->wait_ESObj_queue;
  }

  eQueuePut(queue, sobj);
  return (NORMAL);
}


/*
 * eMidObjESObjQGet()
 */
ESObj*
eMidObjESObjQGet(MidObj *target)
{
  Queue	*queue;

  if ( (queue = target->wait_ESObj_queue) == NULL ) return (NULL);

  return ( eQueueGet(queue) );
}


/*
 * eMidObjDestAidPPut()
 */
int
eMidObjDestAidPPut(MidObj *target, char *dest_aid, int order)
{
  Pool	*pool;
  AidOfSameMid	*aidp;

  if ( target->dest_aid_pool == NULL ) {
    pool = ePoolNew(eMidObjMatchAid, eMidObjAidPrint);
    if ( pool == NULL ) return (EALLOC);
    target->dest_aid_pool = pool;
  }
  else {
    pool = target->dest_aid_pool;
  }

  aidp = (AidOfSameMid*)malloc( sizeof(AidOfSameMid) );
  if ( aidp == NULL ) return (EALLOC);

  aidp->dest_aid = (char*)malloc( strlen(dest_aid) + 1 );
  if ( aidp->dest_aid == NULL ) {
    return (EALLOC);
  }

  strcpy(aidp->dest_aid, dest_aid);
  aidp->order = order;

  ePoolPut(pool, aidp);
  return (NORMAL);
}


/*
 * eMidObjDestAidPGet()
 */
char*
eMidObjDestAidPGet(MidObj *target)
{
  AidOfSameMid	*p;
  char	*aid;

  p = AidOfSameMid_get(target);
  if ( p == NULL ) return (NULL);
  aid = p->dest_aid;
  p->dest_aid = NULL;
  p->order = 0;
  free(p);
  return (aid);
}


/*
 * eMidObjGetOrderOfMatchedAid()
 */
int
eMidObjGetOrderOfMatchedAid(MidObj *target, char *lookfor)
{
  Pool	*pool;
  AidOfSameMid	*aidp;

  pool = target->dest_aid_pool;
  aidp = ePoolGet(pool, lookfor);
  if ( aidp == NULL ) return (FALSE);
  ePoolPut(pool, aidp);

  return (aidp->order);
}


/*
 * eMidObjPutInstance()
 */
int
eMidObjPutInstance(MidObj *target, char *name, char *aid,
		   char *template_name)
{
  Pool		*pool;
  Instance	*instp;
  int	status;

  if ( target->name_and_aid == NULL ) {
    pool = ePoolNew(eMidObjMatchInstance, eMidObjInstancePrint);
    if ( pool == NULL ) return (EALLOC);
    target->name_and_aid = pool;
  }
  else {
    pool = target->name_and_aid;
  }

  instp = (Instance*)malloc( sizeof(Instance) );
  if ( instp == NULL ) return (EALLOC);

  status = eUtilSetString(&(instp->name), name);
  if ( status != NORMAL ) return (status);

  status = eUtilSetString(&(instp->aid), aid);
  if ( status != NORMAL ) return (status);

  status = eUtilSetString(&(instp->template_name), template_name);
  if ( status != NORMAL ) return (status);

  ePoolPut(pool, instp);
  return (NORMAL);
}


/*
 * eMidObjGetInstanceName()
 */
char*
eMidObjGetInstanceName(MidObj *target, char *aid, char **template_name)
{
  Instance	*instp;
  char	*p;

  if ( target->name_and_aid == NULL ) return NULL;

  instp = ePoolGet(target->name_and_aid, aid);
  if ( instp == NULL ) return (NULL);

  p = instp->name;
  *template_name = instp->template_name;
  if ( instp->aid != NULL )
    free(instp->aid);

  instp->name = NULL;
  instp->aid = NULL;
  instp->template_name = NULL;

  free(instp);
  return (p);
}


/*
 * eMidObjMatchInstance()
 */
int
eMidObjMatchInstance(void *target, void *lookfor)
{
  Instance	*instp;

  instp = (Instance*)target;
  if ( !strcmp(instp->aid, (char*)lookfor) ) return (TRUE);
  return (FALSE);
}

/*
 * eMidObjInstancePrint()
 */
void
eMidObjInstancePrint(void *target)
{
  Instance	*instp;

  instp = (Instance*)target;
  fprintf(stderr, "\tInstance\n");
  fprintf(stderr, "name = %s\n", instp->name);
  fprintf(stderr, "aid = %s\n", instp->aid);
}


/*
 * eMidObjSetSmes()
 */
void
eMidObjSetSmes(MidObj *target, SMessage Smes)
{
  target->Smes = Smes;
}


/*
 * eMidObjSetTimeOutFlag()
 */
void
eMidObjSetTimeOutFlag(MidObj *target, int flag)
{
  target->time_out_flag = flag;
}


/*
 * eMidObjSetEffectiveOrder()
 */
void
eMidObjSetEffectiveOrder(MidObj *target, int efct_order)
{
  target->effective_order = efct_order;
}


/*
 * eMidObjSetNormalReplyNum()
 */
void
eMidObjSetNormalReplyNum(MidObj *target, int num)
{
  target->normal_reply_num = num;
}


/*
 * eMidObjSetFromUpperFlag()
 */
void
eMidObjSetFromUpperFlag(MidObj *target, int flag)
{
  target->from_upper_flag = flag;
}


/*
 * eMidObjIncrTotalSendNum()
 */
void
eMidObjIncrTotalSendNum(MidObj *target)
{
  target->total_send_num += 1;
}


/*
 * eMidObjIncrRecvNum()
 */
void
eMidObjIncrRecvNum(MidObj *target)
{
  target->recv_num += 1;
}


/*
 * eMidObjIncrNormalReplyNum()
 */
void
eMidObjIncrNormalReplyNum(MidObj *target)
{
  target->normal_reply_num += 1;
}


/*
 * eMidObjGetSmes()
 */
SMessage
eMidObjGetSmes(MidObj *target)
{
  return (target->Smes);
}


/*
 * eMidObjGetMid()
 */
char*
eMidObjGetMid(MidObj *target)
{
  return (target->mid);
}


/*
 * eMidObjGetFromProc()
 */
char*
eMidObjGetFromProc(MidObj *target)
{
  return (target->from_proc);
}


/*
 * eMidObjGetEnv()
 */
char*
eMidObjGetEnv(MidObj *target)
{
  return (target->env);
}


/*
 * eMidObjGetFunc()
 */
char*
eMidObjGetFunc(MidObj *target)
{
  return (target->func);
}


/*
 * eMidObjGetManagement()
 */
char*
eMidObjGetManagement(MidObj *target)
{
  return (target->management);
}


/*
 * eMidObjGetEffectiveOrder()
 */
int
eMidObjGetEffectiveOrder(MidObj *target)
{
  return (target->effective_order);
}


/*
 * eMidObjGetTotalSendNum()
 */
int
eMidObjGetTotalSendNum(MidObj *target)
{
  return (target->total_send_num);
}


/*
 * eMidObjGetRecvNum()
 */
int
eMidObjGetRecvNum(MidObj *target)
{
  return (target->recv_num);
}


/*
 * eMidObjGetNormalReplyNum()
 */
int
eMidObjGetNormalReplyNum(MidObj *target)
{
  return (target->normal_reply_num);
}


/*
 * eMidObjGetTimeOutFlag()
 */
int
eMidObjGetTimeOutFlag(MidObj *target)
{
  return (target->time_out_flag);
}


/*
 * eMidObjGetFromUpperFlag()
 */
int
eMidObjGetFromUpperFlag(MidObj *target)
{
  return ( target->from_upper_flag );
}


/*
 * eMidObjMatch()
 */
int
eMidObjMatch(void *target, void *lookfor)
{
  if ( !strcmp(((MidObj*)target)->mid, lookfor) ) return (TRUE);
  return (FALSE);
}


/*
 * eMidObjPrint()
 */
void
eMidObjPrint(void *target)
{
  MidObj	*op;

  op = target;
  fprintf(stderr, "\n     MidObj\n");
  fprintf(stderr, "Smes addr = %x\n", op->Smes);
  if ( op->Smes != NULL ) eSmesPrint(op->Smes);
  fprintf(stderr, "mid = %s\n", op->mid);
  fprintf(stderr, "from_proc = %s\n", op->from_proc);
  fprintf(stderr, "env = %s\n", op->env);
  fprintf(stderr, "func = %s\n", op->func);
  fprintf(stderr, "management = %s\n", op->management);
  fprintf(stderr, "wait_ESObj_queue = %x\n", op->wait_ESObj_queue);
  fprintf(stderr, "dest_aid_pool = %x\n", op->dest_aid_pool);
  fprintf(stderr, "effective_order = %d\n", op->effective_order);
  fprintf(stderr, "total_send_num = %d\n", op->total_send_num);
  fprintf(stderr, "recv_num = %d\n", op->recv_num);
  fprintf(stderr, "normal_reply_num = %d\n", op->normal_reply_num);
  fprintf(stderr, "time_out_flag = %d\n", op->time_out_flag);
  if ( op->wait_ESObj_queue != NULL ) eQueuePrint(op->wait_ESObj_queue);
  if ( op->dest_aid_pool != NULL ) ePoolPrint(op->dest_aid_pool);
}


/*
 * eMidObjMatchAid()
 */
int
eMidObjMatchAid(void *target, void *lookfor)
{
  if ( !strcmp(((AidOfSameMid*)target)->dest_aid, lookfor) ) return (TRUE);
  return (FALSE);
}


/*
 * eMidObjAidPrint()
 */
void
eMidObjAidPrint(void *target)
{
  AidOfSameMid	*aidp;

  aidp = target;
  fprintf(stderr, "\n	dest_aid = %s\n", aidp->dest_aid);
  fprintf(stderr, "	order = %d\n", aidp->order);
}



/*** static function ***/

/*
 * AidOfSameMid_get()
 */
static
AidOfSameMid*
AidOfSameMid_get(MidObj *target)
{
  Pool	*pool;

  pool = target->dest_aid_pool;
  return ( ePoolGet(pool, NULL) );
}

/*** END OF FILE ***/
