/*
 * file name: eLink.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<helios/envdef.h>
#include	"eLink.h"



/*
 * eLinkNew()
 */
void*
eLinkNew(void *new_content)
{
  Link	*lp;

  lp = (Link*)malloc( sizeof(Link) );
  if ( lp == NULL ) return (NULL);

  eLinkSetNext(lp, NULL);
  eLinkSetContents(lp, new_content);

  return (lp);
}


/*
 * eLinkDelete()
 */
void
eLinkDelete(Link *target)
{
  if ( target == NULL ) return;
  target->next = NULL;
  target->contents = NULL;
  free(target);
}


/*
 * eLinkSetNext()
 */
void
eLinkSetNext(Link *target, Link *next)
{
  target->next = next;
}


/*
 * eLinkSetContents()
 */
void
eLinkSetContents(Link *target, void *contents)
{
  target->contents = contents;
}


/*
 * eLinkGetNext()
 */
Link*
eLinkGetNext(Link *target)
{
  return ( target->next );
}

/*
 * eLinkGetContents()
 */
void*
eLinkGetContents(Link *target)
{
  return ( target->contents );
}

/*** END OF FILE ***/
