/*
 * file name: eLL.h
 *
 */

#ifndef ELL
#define ELL

#include	"eLink.h"

typedef	struct _LinkedList {
  Link		*head;
  Link		*tail;
  Link		*current;
  int		(*match)();
  void		(*print)();
} LinkedList;

void*		eLLNew(int (*match)(), void (*print)() );
void		eLLDelete(LinkedList *target);

void		eLLHead(LinkedList *target);
void		eLLNext(LinkedList *target);
void		eLLTail(LinkedList *target);
int		eLLIsTail(LinkedList *target);

int		eLLAddHead(LinkedList *target, void *obj);
int		eLLAddTail(LinkedList *target, void *obj);
void*		eLLRetrieveHead(LinkedList *target);
void*		eLLRetrieveCurrent(LinkedList *target);
int		eLLMatch(LinkedList *target, void *look);
void*		eLLRefCurrent(LinkedList *target);
void		eLLPrint(LinkedList *target);

#endif

/*** END OF FILE ***/
