/*
 * file name: eLL.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<helios/envdef.h>
#include	"eLink.h"
#include	"eLL.h"


/*
 * eLLNew()
 */
void*
eLLNew(int (*match)(), void (*print)() )
{
  LinkedList	*llp;

  llp = (LinkedList*)malloc( sizeof(LinkedList) );
  if ( llp == NULL ) return (NULL);

  llp->head = NULL;
  llp->tail = NULL;
  llp->current = NULL;
  llp->match = match;
  llp->print = print;

  return (llp);
}


/*
 * eLLDelete()
 */
void
eLLDelete(LinkedList *target)
{
  if ( target == NULL ) return;
  target->head = NULL;
  target->tail = NULL;
  target->current = NULL;
  target->match = NULL;
  target->print = NULL;
  free( target );
}


/*
 * eLLHead()
 */
void
eLLHead(LinkedList *target)
{
  target->current = target->head;
}

/*
 * eLLNext()
 */
void
eLLNext(LinkedList *target)
{
  if ( !eLLIsTail(target) ) {
    target->current = eLinkGetNext(target->current);
  }
}


/*
 * eLLTail()
 */
void
eLLTail(LinkedList *target)
{
  target->current = target->tail;
}


/*
 * eLLIsTail()
 */
int
eLLIsTail(LinkedList *target)
{
  if ( target->tail == target->current ) return (1);
  return (0);
}


/*
 * eLLAddHead()
 */
int
eLLAddHead(LinkedList *target, void *obj)
{
  Link	*lp;

  lp = eLinkNew(obj);
  if ( lp == NULL ) return (EALLOC);

  if ( target->head == NULL ) { /* LinkedList is empty */
    target->head = lp;
    target->tail = lp;
    target->current = lp;
    eLinkSetNext(lp, NULL);
    return (NORMAL);
  }

  eLinkSetNext(lp, target->head);
  target->head = lp;
  return (NORMAL);
}


/*
 * eLLAddTail()
 */
int
eLLAddTail(LinkedList *target, void *obj)
{
  Link	*lp;

  lp = eLinkNew(obj);
  if ( lp == NULL ) return (EALLOC);

  if ( target->head == NULL ) {	/* LinkedList is empty */
    target->head = lp;
    target->tail = lp;
    target->current = lp;
    eLinkSetNext(lp, NULL);
    return (NORMAL);
  }

  eLinkSetNext(target->tail, lp);
  eLinkSetNext(lp, NULL);
  target->tail = lp;

  return (NORMAL);
}


/*
 * eLLRetrieveHead()
 */
void*
eLLRetrieveHead(LinkedList *target)
{
  Link	*lp;
  void	*objp;

  lp = target->head;
  if ( lp == NULL ) return (NULL);
  target->head = eLinkGetNext(lp);
  if ( target->current == lp ) {
    target->current = eLinkGetNext(lp);
  }
  if ( target->tail == lp ) {
    target->tail = NULL;
  }
  objp = eLinkGetContents(lp);
  eLinkDelete(lp);
  return (objp);
}


/*
 * eLLRetrieveCurrent()
 */
void*
eLLRetrieveCurrent(LinkedList *target)
{
  Link	*cp, *lp;
  void	*objp;

  if ( target->head == NULL ) return (NULL);

  if ( target->current == target->head ) {
    return ( eLLRetrieveHead(target) );
  }

  cp = target->current;
  
  for ( lp = target->head; cp != eLinkGetNext(lp);
                                lp = eLinkGetNext(lp) ) {}
  objp = eLinkGetContents(cp);
  eLinkSetNext(lp, eLinkGetNext(cp));

  if ( eLLIsTail(target) ) {
    target->current = lp;
    target->tail = lp;
  }
  else {
    target->current = eLinkGetNext(cp);
  }

  eLinkDelete(cp);
  return (objp);
}


/*
 * eLLMatch()
 */
int
eLLMatch(LinkedList *target, void *look)
{
  Link	*lp;
  void	*objp;

  eLLHead(target);
  while ( 1 ) {
    lp = eLLRefCurrent(target);
    if ( lp == NULL ) return (0);
    objp = eLinkGetContents(lp);
    if ( (*(target->match))(objp, look) ) return (1);
    if ( eLLIsTail(target) ) return (0);
    eLLNext(target);
  }
}


/*
 * eLLRefCurrent()
 */
void*
eLLRefCurrent(LinkedList *target)
{
  return (target->current);
}


/*
 * eLLPrint()
 */
void
eLLPrint(LinkedList *target)
{
  Link	*lp;
  void	*objp;

  eLLHead(target);
  while ( 1 ) {
    lp = eLLRefCurrent(target);
    if ( lp == NULL ) return;
    objp = eLinkGetContents(lp);
    (*(target->print))(objp);
    if ( eLLIsTail(target) ) return;
    eLLNext(target);
  }
}
/*** END OF FILE ***/
