/*
 * file name : eInterEnv.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<helios/hDaemonLib.h> 
#include	<helios/HeAgSvFun.h>  
#include	<helios/envdef.h>
#include	<helios/eInit.h>
#include	"eInterEnv.h"
#include	"eSMessage.h"
#include	"eAidAdm.h"
#include	"eAmes.h"
#include	"eSMessage.h"
#include	"eSmes.h"
#include	"ePrm.h"
#include	"eCom.h"
#include	"ePAdm.h"
#include	"eArg.h"
#include	"eQueue.h"
#include	"eMidObj.h"
#include	"eAgntDir.h"
#include	"eFast.h"
#include	"eBagOf.h"
#include	"eSeq.h"
#include	"eToEnv.h"
#include	"eSendError.h"
#include	"eDummy.h"


static	int	get_all_instance_name_proc(char *Ames);
static	int	get_prm_req_proc(char *Ames);
static	int	send_prm_proc(char *Ames);
static	int	init_param1(char *Ames);
static	int	init_param2(char *Ames);
static	int	create_param(char *Ames, char *my_aid);
static	int	ack_proc(char *Ames);
static	int	send_to_param(char *Ames);
static	int	send_ack(char *my_aid, char *from, char *env);
static	int	update_ag_sv(char *info);
static	int	get_num_of_agent_UImsg(char *info);
static	int	get_num_of_agent(char *str);
static	char*	get_agent_name_and_param_UImsg(int index, char *info);
static	char*	get_agent_name_and_parameter(int index, char *str);
static	char*	get_agent_name(int index, char *str);
static	char*	get_agent_parameter(int index, char *str);
static	char*	make_str(char *sp, int length);
static	char*	gen_update_info_new(int num);
static	char*	gen_update_info_old(int num);
static	char*	get_matched_name(char *info, char *aid);
static	char*	add_parameter_to_info(char *update_info, char *parameter);


/*
 * eInterEnvSendToPrm()
 */
int
eInterEnvSendToPrm(int mid_pool_id, char *to_aid, char *env, char * from,
		   SMessage Smes)
{
  MidObj	*mobj;
  char	*Ames, *my_aid, *mid, *func, *management;
  int	status, size, rpc_id, mode;

  if ( from == NULL ) mode = 0;
  else mode = 1;

  mid = eSmesGetSmid(Smes);
  func = eSmesGetSAF(Smes);
  management = eSmesGetSmanag(Smes);

  my_aid = eAidAdmGetMyProcAid();

  status = eAmesNew(my_aid, to_aid, GET_ALL_INSTANCE, env, mid,
                    NULL, &Ames, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(to_aid, &rpc_id, Ames, size);
  status = eSendErrorCheck(status, Ames, to_aid, size);
  if ( status != NORMAL ) return (ERROR);

  if ( mode == 1 ) my_aid = from;

  mobj = eMidObjNew(mid, my_aid, env, func, management);
  if ( mobj == NULL ) return (EALLOC);

  eMidObjSetWaitPrmAid(mobj, to_aid);
  eMidObjSetFromUpperFlag(mobj, mode);
  eMidObjSetSmes(mobj, Smes);
  eMidObjIncrTotalSendNum(mobj);
  status = ePAdmPut(mid_pool_id, mobj);
  if ( status != NORMAL ) return (status);

  return (NORMAL);
}


/*
 * eInterEnvSendToPrm2()
 */
int
eInterEnvSendToPrm2(MidObj *mobj, char *to_aid, char *env, SMessage Smes)
{
  char	*Ames, *my_aid;
  char	*mid, *func, *management;
  int	status, size, rpc_id;

  eMidObjIncrTotalSendNum(mobj);
  eMidObjSetWaitPrmAid(mobj, to_aid);

  mid = eSmesGetSmid(Smes);
  func = eSmesGetSAF(Smes);
  management = eSmesGetSmanag(Smes);

  my_aid = eAidAdmGetMyProcAid();

  status = eAmesNew(my_aid, to_aid, GET_ALL_INSTANCE, env, mid,
                    NULL, &Ames, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(to_aid, &rpc_id, Ames, size);
  status = eSendErrorCheck(status, Ames, to_aid, size);
  if ( status != NORMAL ) return (ERROR);

  return (NORMAL);
}


/*
 * eInterEnvProcMsg()
 */
int
eInterEnvProcMsg(char *Ames)
{
  char	*cntl, *my_aid;
  int	status;

  cntl = eAmesGetACntl(Ames);
  my_aid = eAidAdmGetMyProcAid();

  if ( !strcmp(DUMMY_FOR_EVENT, cntl) ) {
    eDummyRecvProc(Ames);
    return NORMAL;
  }
  else if ( !strcmp(GET_ALL_INSTANCE, cntl) ) {
    status = get_prm_req_proc(Ames);
    return (status);
  }
  else if ( !strcmp(PUT_ALL_INSTANCE, cntl) ) {
    status = send_prm_proc(Ames);
    return (status);
  }
  else if ( !strcmp(GET_ALL_INSTANCE_NAME, cntl) ) {
    status = get_all_instance_name_proc(Ames);
    return (status);
  }
  else if ( !strcmp(PUT_ALL_INSTANCE_NAME, cntl) ) {
    status = eToEnvInstanceNameReply(Ames);
    return (status);
  }
  else if ( my_aid == NULL && !strcmp(CREATE_INSTANCE, cntl) ) {
    ePrmSet();
    status = init_param1(Ames);
    return (status);
  }
  else if ( my_aid != NULL && !strcmp(CREATE_INSTANCE, cntl) ) {
    status = create_param(Ames, my_aid);
    return (status);
  }
  else if ( my_aid == NULL && !strcmp(UPDATE_AGENT_SERVER, cntl) ) {
    ePrmSet();
    status = init_param2(Ames);
    return (status);
  }
  else if ( my_aid != NULL && !strcmp(UPDATE_AGENT_SERVER, cntl) ) {
    status = update_ag_sv( eAmesGetAInfo(Ames) );
    if ( status != NORMAL ) return (status);
    status = send_ack( my_aid, eAmesGetAFrom(Ames), eAmesGetAEnv(Ames) );
    return (status);
  }
  else if ( !strcmp(ACK_STR, cntl) ) {
    status = ack_proc(Ames);
    return (status);
  }
  else if ( !strcmp(CREATE_INSTANCE_FROM_USER, cntl) ) {
    status = send_to_param(Ames);
    return (status);
  }
  else {
    /* unknown command */
    status = -1000;
  }

  return (status);
}


/*
 * get_all_instance_name_proc()
 */
static
int
get_all_instance_name_proc(char *Ames)
{
  SMessage	Smes, Smes_for_prm;
  Queue	*instance_name_Q, *instance_aid_Q;
  SMTo	to_field;
  char	*all_name, *instance_name, *instance_aid;
  char	*from, *to, *env, *mid;
  char	*method, *new_method = NULL;
  char	*rAmes;
  int	instance_num, info_len, rpc_id, size, status;

  from = eAmesGetAFrom(Ames);
  to = eAmesGetATo(Ames);
  env = eAmesGetAEnv(Ames);
  mid = eAmesGetAInfo(Ames);

  instance_aid_Q = eQueueNew(NULL);
  if ( instance_aid_Q == NULL ) return (EALLOC);

  instance_name_Q = eQueueNew(NULL);
  if ( instance_name_Q == NULL ) return (EALLOC);

  /* create Smes to get all instance of parametric agent with a agent server */
  Smes = eSmesNew(ASK, NULL, "---", NULL, OFF, ALL_STR, FAST_STR, NULL,
                  "method", "data");
  if ( Smes == NULL ) return (EALLOC);

  to_field = eSmesGetSto(Smes);
  method = eSmesGetSmethod(Smes);

  instance_num = 0; info_len = 0;
  while ( 1 ) {
    instance_aid = eAgntDirSearchAgentId(Smes, to, "---", to, to_field, 
				     method, &new_method, &Smes_for_prm);
    if ( instance_aid == NULL ) break;
    if ( new_method != NULL ) free(new_method);

    status = eQueuePut(instance_aid_Q, instance_aid);
    if ( status == EALLOC ) return (EALLOC);

    instance_num++;
    instance_name = eAgntDirSearchLogicalName(to, instance_aid);
    if ( instance_name == NULL ) return (ERROR);

    info_len += strlen(instance_name);
    info_len++;

    status = eQueuePut(instance_name_Q, instance_name);
    if ( status == EALLOC ) return (EALLOC);
  }
  all_name = (char*)malloc( info_len );
  if ( all_name == NULL ) return (EALLOC);
  all_name[0] = NULL;

  while ( (instance_name = eQueueGet(instance_name_Q)) ) {
    instance_aid = eQueueGet(instance_aid_Q);
    strcat(all_name, instance_name);
    strcat(all_name, SPACE_STR);
    free(instance_name);
    free(instance_aid);
  }
  all_name[info_len-1] = NULL;

  status = eAmesNew(to, from, PUT_ALL_INSTANCE_NAME, mid, all_name,
		    NULL, &rAmes, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(from, &rpc_id, rAmes, size);
  status = eSendErrorCheck(status, rAmes, from, size);
  if ( status != NORMAL ) return (ERROR);

  eQueueDelete(instance_aid_Q);
  eQueueDelete(instance_name_Q);
  
  return (NORMAL);
}


/*
 * get_prm_req_proc()
 */
static
int
get_prm_req_proc(char *Ames)
{
  SMessage	Smes, Smes_for_prm;
  Queue	*instance_name_Q, *instance_aid_Q;
  SMTo	to_field;
  char	*all_name_and_aid, *instance_name, *instance_aid;
  char	*from, *to, *env, *mid;
  char	*method, *new_method = NULL;
  char	*rAmes;
  int	instance_num, info_len, rpc_id, size, status;

  from = eAmesGetAFrom(Ames);
  to = eAmesGetATo(Ames);
  env = eAmesGetAEnv(Ames);
  mid = eAmesGetAInfo(Ames);

  instance_aid_Q = eQueueNew(NULL);
  if ( instance_aid_Q == NULL ) return (EALLOC);

  instance_name_Q = eQueueNew(NULL);
  if ( instance_name_Q == NULL ) return (EALLOC);

  /* create Smes to get all instance of parametric agent with a agent server */
  Smes = eSmesNew(ASK, NULL, "---", NULL, OFF, ALL_STR, FAST_STR, NULL,
                  "method", "data");
  if ( Smes == NULL ) return (EALLOC);

  to_field = eSmesGetSto(Smes);
  method = eSmesGetSmethod(Smes);

  instance_num = 0; info_len = 0;
  while ( 1 ) {
    instance_aid = eAgntDirSearchAgentId(Smes, to, "---", to, to_field, 
				     method, &new_method, &Smes_for_prm);
    if ( instance_aid == NULL ) break;
    if ( new_method != NULL ) free(new_method);

    status = eQueuePut(instance_aid_Q, instance_aid);
    if ( status == EALLOC ) return (EALLOC);

    info_len += strlen(instance_aid);
    info_len++;
    instance_num++;
    instance_name = eAgntDirSearchLogicalName(to, instance_aid);
    if ( instance_name == NULL ) return (ERROR);

    info_len += strlen(instance_name);
    info_len++;

    status = eQueuePut(instance_name_Q, instance_name);
    if ( status == EALLOC ) return (EALLOC);
  }
  all_name_and_aid = (char*)malloc( info_len );
  if ( all_name_and_aid == NULL ) return (EALLOC);
  all_name_and_aid[0] = NULL;

  while ( (instance_name = eQueueGet(instance_name_Q)) ) {
    instance_aid = eQueueGet(instance_aid_Q);
    strcat(all_name_and_aid, instance_name);
    strcat(all_name_and_aid, SPACE_STR);
    strcat(all_name_and_aid, instance_aid);
    strcat(all_name_and_aid, SPACE_STR);
    free(instance_name);
    free(instance_aid);
  }
  all_name_and_aid[info_len-1] = NULL;

  status = eAmesNew(to, from, PUT_ALL_INSTANCE, mid, all_name_and_aid,
		    NULL, &rAmes, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(from, &rpc_id, rAmes, size);
  status = eSendErrorCheck(status, rAmes, from, size);
  if ( status != NORMAL ) return (ERROR);

  eQueueDelete(instance_aid_Q);
  eQueueDelete(instance_name_Q);

  return (NORMAL);
}


/*
 * send_prm_proc()
 */
static
int
send_prm_proc(char *Ames)
{
  MidObj	*mobj;
  char		*mid;
  int		status;

  mid = eAmesGetAEnv(Ames);

  if ( (mobj = ePAdmGet(BAGOF_MID_POOL, mid)) != NULL ) {
    ePAdmPut(BAGOF_MID_POOL, mobj);
    status = eBagOfSendProcToPrm(mobj, Ames);
  }
  else if ( (mobj = ePAdmGet(FAST_MID_POOL, mid)) != NULL ) {
    ePAdmPut(FAST_MID_POOL, mobj);
    status = eFastSendProcToPrm(mobj, Ames);
  }
  else if ( (mobj = ePAdmGet(SEQ_MID_POOL, mid)) != NULL ) {
    ePAdmPut(SEQ_MID_POOL, mobj);
    status = eSeqSendProcToPrm(mobj, Ames);
  }
  else {
    status = ERROR;
  }
  
  return (status);
}


/*
 * init_param1()
 */
static
int
init_param1(char *Ames)
{
  int	instance_num, index, i, size, socket_num, rpc_id;
  char	*from, *to, *env, *info;
  char	*template_name, *my_aid, *my_name, *my_parameter;
  char  *dest_aid, *dest_name, *dest_parameter;
  char	*prm_aid, *prm_name, *prm_parameter;
  char	*update_info, *update_info2, *cntlAmes;
  int	status;

  from = eAmesGetAFrom(Ames);
  to = eAmesGetATo(Ames);
  env = eAmesGetAEnv(Ames);
  info = eAmesGetAInfo(Ames);

  instance_num = get_num_of_agent(info);
  template_name = eAgntDirSearchLogicalName(env, to);


  status = ePrmSetTempName(template_name);
  if ( status != NORMAL ) return (status);

  status = ePrmSetEnvID(to);
  if ( status != NORMAL ) return (status);

  status = ePrmSetUserID(from);
  if ( status != NORMAL ) return (status);

  ePrmIncrID();
  my_aid = ePrmGetMaxAgentID();
  my_name = get_agent_name(1, info);
  my_parameter = get_agent_parameter(1, info);
  ePrmPutNewInstance(my_name, my_aid, my_parameter);
  eInitMyAid(my_aid);
  eAidAdmSetMyName(my_name);
  ePrmSetMyParameter(my_parameter);
  my_aid = strdup(my_aid);
  socket_num = eArgGetSockNum();

  /* daemon interface */
#ifndef ENV_DEBUG
  register_paraAgent(socket_num, my_aid, my_name);
#endif
  free(my_name);

  index = 1;
  for ( i = 0; i < instance_num-1; i++ ) {
    index++;
    ePrmIncrID();
    prm_aid = ePrmGetMaxAgentID();
    prm_name = get_agent_name(index, info);
    prm_parameter = get_agent_parameter(index, info);
    ePrmPutNewInstance(prm_name, prm_aid, prm_parameter);
    free(prm_name);
    free(prm_parameter); 
  }

  update_info = gen_update_info_new(instance_num);
  
  for ( i = 0; i < instance_num; i++ ) {
    ePrmGetNewInstance(&dest_name, &dest_aid, &dest_parameter);
    if ( !strcmp(my_aid, dest_aid) ) {
      ePrmPutOldInstance(dest_name, dest_aid, dest_parameter);
      continue;
    }

    update_info2 = add_parameter_to_info(update_info, dest_parameter);
    if ( update_info2 == NULL ) return (EALLOC);

    status = eAmesNew(my_aid, dest_aid, UPDATE_AGENT_SERVER, to,
                      update_info2, NULL, &cntlAmes, &size);
    if ( status != NORMAL ) return ( status );

    status = eComSendAMessage(dest_aid, &rpc_id, cntlAmes, size);
    status = eSendErrorCheck(status, cntlAmes, dest_aid, size);
    if ( status != NORMAL ) return (ERROR);

    ePrmPutOldInstance(dest_name, dest_aid, dest_parameter);
  }

  update_ag_sv(update_info);

  if ( instance_num == 1 ) {
    status = eAmesNew(my_aid, from, ACK_STR, NULL, OK_STR, NULL,
		      &cntlAmes, &size);
    if ( status != NORMAL ) return (status);

    status = eComSendAMessage(from, &rpc_id, cntlAmes, size);
    status = eSendErrorCheck(status, cntlAmes, from, size);
    if ( status != NORMAL ) return (ERROR);
  }

  return (NORMAL);
}


/*
 * init_param2()
 */
static
int
init_param2(char *Ames)
{
  int	sock_num, size, rpc_id;
  char	*from, *env, *info, *upper_env;
  char	*template_name;
  char	*my_aid, *my_name;
  char	*replyAmes;
  int	status;

  from = eAmesGetAFrom(Ames);
  my_aid = eAmesGetATo(Ames);
  env = eAmesGetAEnv(Ames);
  info = eAmesGetAInfo(Ames);

  upper_env = eAidAdmGetAidOfUpperEnv(env);
  template_name = eAgntDirSearchLogicalName(upper_env, env);

  status = ePrmSetTempName(template_name);
  if ( status != NORMAL ) return (status);

  my_name = get_matched_name(info, my_aid);
  sock_num = eArgGetSockNum();

  update_ag_sv(info);
  eInitMyAid(my_aid);
  eAidAdmSetMyName(my_name);

  /* daemon interface */
#ifndef ENV_DEBUG
  register_paraAgent(sock_num, my_aid, my_name);
#endif

  status = eAmesNew(my_aid, from, ACK_STR, env, OK_STR,
                    NULL, &replyAmes, &size);
  status = eComSendAMessage(from, &rpc_id, replyAmes, size);
  status = eSendErrorCheck(status, replyAmes, from, size);
  if ( status != NORMAL ) return (ERROR);

  return (NORMAL);
}


/*
 * create_param()
 */
static
int
create_param(char *Ames, char *my_aid)
{
  int	new_num, old_num, index, len1, len2, i;
  char	*from, *to, *env, *info;
  char	*update_info_new, *update_info_old;
  char	*update_info_t, *update_info_t2;
  char	*prm_aid, *prm_name, *prm_parameter;
  char	*dest_name, *dest_aid, *dest_parameter;
  char	*cntlAmes;
  int	status, rpc_id, size;


  from = eAmesGetAFrom(Ames);
  to = eAmesGetATo(Ames);
  env = eAmesGetAEnv(Ames);
  info = eAmesGetAInfo(Ames);

  new_num = get_num_of_agent(info);
  old_num = ePrmGetMaxID();

  index = 0;
  for ( i = 0; i < new_num; i++ ) {
    index++;
    ePrmIncrID();
    prm_aid = ePrmGetMaxAgentID();
    prm_name = get_agent_name(index, info);
    prm_parameter = get_agent_parameter(index, info);
    ePrmPutNewInstance(prm_name, prm_aid, prm_parameter);
  }

  update_info_new = gen_update_info_new(new_num);
  update_info_old = gen_update_info_old(old_num);

  for ( i = 0; i < old_num; i++ ) {
    ePrmGetOldInstance(&dest_name, &dest_aid, &dest_parameter);
    if ( !strcmp(my_aid, dest_aid) ) {
      ePrmPutOldInstance(dest_name, dest_aid, dest_parameter);
      continue;
    }
    status = eAmesNew(my_aid, dest_aid, UPDATE_AGENT_SERVER, to,
                      update_info_new, NULL, &cntlAmes, &size);
    if ( status != NORMAL ) return ( status );

    status = eComSendAMessage(dest_aid, &rpc_id, cntlAmes, size);
    status = eSendErrorCheck(status, cntlAmes, dest_aid, size);
    if ( status != NORMAL ) return (ERROR);
    
    ePrmPutOldInstance(dest_name, dest_aid, dest_parameter);
  }

  len1 = strlen(update_info_old);
  len2 = strlen(update_info_new);
  update_info_t = (char*)malloc( len1 + 1 + len2 + 1 );
  if ( update_info_t == NULL ) return (EALLOC);
  strcpy(update_info_t, update_info_old);
  strcat(update_info_t, SPACE_STR);
  strcat(update_info_t, update_info_new);

  
  for ( i = 0; i < new_num; i++ ) {
    ePrmGetNewInstance(&dest_name, &dest_aid, &dest_parameter);

    update_info_t2 = add_parameter_to_info(update_info_t,
					   dest_parameter);
    if ( update_info_t2 == NULL ) return (EALLOC);

    status = eAmesNew(my_aid, dest_aid, UPDATE_AGENT_SERVER, to,
                      update_info_t2, NULL, &cntlAmes, &size);
    if ( status != NORMAL ) return ( status );

    status = eComSendAMessage(dest_aid, &rpc_id, cntlAmes, size);
    status = eSendErrorCheck(status, cntlAmes, dest_aid, size);
    if ( status != NORMAL ) return (ERROR);

    ePrmPutOldInstance(dest_name, dest_aid, dest_parameter);
  }

  update_ag_sv(update_info_new);

  return (NORMAL);
}


/*
 * ack_proc()
 */
static
int
ack_proc(char *Ames)
{
  int	total, recv_cnt;
  char	*user_id, *my_aid;
  char	*cntlAmes;
  int	status, rpc_id, size;


  recv_cnt = ePrmGetAckRecvCnt();
  recv_cnt++;

  total = ePrmGetMaxID();
  if ( recv_cnt == total-1 ) {
    ePrmSetAckRecvCnt(0);
    my_aid = eAidAdmGetMyProcAid();

    /* send Ack user */
    user_id = ePrmGetUserID();
    status = eAmesNew(my_aid, user_id, ACK_STR, NULL,
                      OK_STR, NULL, &cntlAmes, &size);
    if ( status != NORMAL ) return ( status );

    status = eComSendAMessage(user_id, &rpc_id, cntlAmes, size);
    status = eSendErrorCheck(status, cntlAmes, user_id, size);
    if ( status != NORMAL ) return (ERROR);

  }
  else {
    ePrmSetAckRecvCnt(recv_cnt);
  }

  return (NORMAL);
}


/*
 * send_to_param()
 */
static
int
send_to_param(char *Ames)
{
  SMessage	Smes, Smes_for_prm;
  SMMid		Mid;
  SMFrom	From;
  SMTo		To;
  char		*method, *new_method;
  char	*from, *env, *info, *template_name, *template_aid;
  char	*new_info, *instance_info;
  char	*newAmes;
  int	num, len, rpc_id, size;
  int	status, i;

  from = eAmesGetAFrom(Ames);
  env = eAmesGetATo(Ames);
  info = eAmesGetAInfo(Ames);

  template_name = get_agent_name_and_param_UImsg(1, info);
  if ( template_name == NULL ) return (EALLOC);

  Smes = eSmesNew(CONTROL, NULL, "-", "-", OFF, template_name, NULL, "-",
                  "-", "-");
  if ( Smes == NULL ) return (EALLOC);
  From = eSmesGetSfrom(Smes);
  Mid = eSmesGetSmid(Smes);
  To = eSmesGetSto(Smes);
  method = eSmesGetSmethod(Smes);

  template_aid = eAgntDirSearchAgentId(Smes, env, Mid, From, To,
                                       method, &new_method,
				       &Smes_for_prm);
  if ( template_aid == NULL ) return (ERROR);
  
  new_info = (char*)malloc( strlen(info) );
  if ( new_info == NULL ) return ( EALLOC );
  new_info[0] = NULL;

  num = get_num_of_agent_UImsg(info);
  for ( i = 0; i < num; i++ ) {
    instance_info = get_agent_name_and_param_UImsg(i+2, info);
    strcat(new_info, instance_info);
    strcat(new_info, SPACE_STR);
    free(instance_info);
  }
  len = strlen(new_info);
  new_info[len-1] = NULL;

  status = eAmesNew(from, template_aid, CREATE_INSTANCE, env, new_info,
                    NULL, &newAmes, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(template_aid, &rpc_id, newAmes, size);
  status = eSendErrorCheck(status, newAmes, template_aid, size);
  if ( status != NORMAL ) return (ERROR);

  return (NORMAL);
}


/*
 * send_ack()
 */
static
int
send_ack(char *my_aid, char *from, char *env)
{
  char	*Ames;
  int	status, size, rpc_id;

  status = eAmesNew(my_aid, from, ACK_STR, env, OK_STR, NULL, &Ames, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(from, &rpc_id, Ames, size);
  status = eSendErrorCheck(status, Ames, from, size);
  if ( status != NORMAL ) return (ERROR);

  return (NORMAL);
}


/*
 * update_ag_sv()
 */
static
int
update_ag_sv(char *info)
{
  char	*buf, *p, *env_id, *name, *aid, *func, *parameter;
  char	*method1, *method2;
  int	status;


  if ( info == NULL ) return (ERROR);
  buf = strdup(info);
  if ( buf == NULL ) return (EALLOC);

  p = strtok(buf, SPACE_STR);

  do {
    if ( !strcmp(p, ADD_AGENT) ) {
      env_id = strtok(NULL, SPACE_STR);
      name = strtok(NULL, SPACE_STR);
      aid = strtok(NULL, SPACE_STR);

      add_to_agent_directory(env_id, name, aid);
    }
    else if ( !strcmp(p, ADD_FUNCTION) ) {
      env_id = strtok(NULL, SPACE_STR);
      name = strtok(NULL, SPACE_STR);
      aid = strtok(NULL, SPACE_STR);

      add_to_function_directory(env_id, name, aid);
    }
    else if ( !strcmp(p, ADD_METHOD) ) {
      env_id = strtok(NULL, SPACE_STR);
      func = strtok(NULL, SPACE_STR);
      method1 = strtok(NULL, SPACE_STR);
      aid = strtok(NULL, SPACE_STR);
      method2 = strtok(NULL, SPACE_STR);

      add_to_method_directory(env_id, func, method1, aid, method2);
    }
    else if ( !strcmp(p, PRM_CMD) ) {
      parameter = strtok(NULL, "");
      status = ePrmSetMyParameter(parameter);
      if ( status != NORMAL ) return ( status );
      break;
    }
  } while ( (p = strtok(NULL, SPACE_STR)) );

  free(buf);
  return (NORMAL);
}


/*
 * get_num_of_agent_UImsg()
 *  str := template_name instance_name1(prm_str, ...) instance_name2(...)
 */
static
int
get_num_of_agent_UImsg(char *info)
{
  int	cnt;
  char	*p;

  if ( info == NULL ) return (0);
  p = info;

  /* for template_name */
  while ( *p == SPACE_CONST ) p++;
  while ( *p != SPACE_CONST && *p != NULL ) p++;

  cnt = get_num_of_agent(p);
  return ( cnt );
}


/*
 * get_num_of_agent() 
 *     str := instance_name1(prm_str, ...) instance_name2(...)
 */
static
int
get_num_of_agent(char *str)
{
  int	state, cnt;
  char	*p;

  if ( str == NULL ) return (0);
  p = str;
  state = 0;
  cnt = 0;

  while ( *p != NULL ) {
    while ( *p == SPACE_CONST ) p++;
    state = 1;
    p++;
    while ( *p != NULL && state != 4 ) {
      switch ( state ) {
      case 1 :
	while ( *p != '(' ) p++;
	state = 2;
	break;
      case 2 :
	while ( *p != ')' && *p != '\"' ) p++;
	if ( *p == ')' ) state = 4;
	else if ( *p == '\"' ) state = 3 ;
	break;
      case 3 :
	while ( *p != '\"' ) p++;
        if ( *(p-1) == '\\' && *p == '\"' ) state = 3;
        else  state = 2;
	break;
      }
      p++;
    }
    if ( state == 4 ) {
      state = 0;
      cnt++;
    }
    else {
      /* syntax error */
      return (ERROR);
    }
  }
  return ( cnt );
}


/*
 * get_agent_name_and_param_UImsg()
 *  str := template_name instance_name1(prm_str, ...) instance_name2(...)
 */
static
char*
get_agent_name_and_param_UImsg(int index, char *info)
{
  int	cnt, len, new_index;
  char	*p, *namep;

  if ( info == NULL ) return (NULL);
  p = info;
  cnt = 0;
  len = 0;

  /* for template_name */
  while ( *p == SPACE_CONST ) p++;
  namep = p;
  while ( *p != SPACE_CONST && *p != NULL ) {
    p++; len++;
  }
  cnt++;
  if ( cnt == index ) return ( make_str(namep, len) );

  new_index = index - 1;
  return ( get_agent_name_and_parameter(new_index, p) );
}


/*
 * get_agent_name_and_parameter()
 *     str := instance_name1(prm_str, ...) instance_name2(...)
 */
static
char*
get_agent_name_and_parameter(int index, char *str)
{
  int	cnt, len;
  char	*p, *namep;
  int	state;

  if ( str == NULL ) return (NULL);
  p = str;
  cnt = 0;
  len = 0;

  while ( *p != NULL ) {
    len = 0;
    while ( *p == SPACE_CONST ) p++;
    state = 1;
    namep = p;
    while ( *p != NULL && state != 4 ) {
      switch ( state ) {
      case 1 :
	while ( *p != '(' ) {
	  p++; len++;
	}
	state = 2;
	break;
      case 2 :
	while ( *p != ')' && *p != '\"' ) {
	  p++; len++;
	}
	if ( *p == ')' ) state = 4;
	else if ( *p == '\"' ) state = 3 ;
	break;
      case 3 :
	while ( *p != '\"' ) {
	  p++; len++;
	}
        if ( *(p-1) == '\\' && *p == '\"' ) state = 3;
        else  state = 2;
	break;
      }
      p++; len++;
    }
    if ( state == 4 ) {
      state = 0;
      cnt++;
    }
    else {
      /* syntax error */
      return (NULL);
    }
    if ( cnt == index ) return ( make_str(namep, len) );
  }
  return (NULL);
}


/*
 * get_agent_name()
 *     str := instance_name1(prm_str, ...) instance_name2(...)
 */
static
char*
get_agent_name(int index, char *str)
{
  int	cnt, len;
  char	*p, *namep;
  int	state;

  if ( str == NULL ) return (NULL);
  p = str;
  cnt = 0;
  len = 0;

  while ( *p != NULL ) {
    len = 0;
    while ( *p == SPACE_CONST ) p++;
    state = 1;
    namep = p;
    while ( *p != NULL && state != 4 ) {
      switch ( state ) {
      case 1 :
	while ( *p != '(' && *p != SPACE_CONST ) {
	  p++; len++;
	}
	state = 2;
	break;
      case 2 :
	while ( *p != ')' && *p != '\"' ) p++;
	if ( *p == ')' ) state = 4;
	else if ( *p == '\"' ) state = 3 ;
	break;
      case 3 :
	while ( *p != '\"' ) p++;
        if ( *(p-1) == '\\' && *p == '\"' ) state = 3;
        else  state = 2;
	break;
      }
      p++;
    }
    if ( state == 4 ) {
      state = 0;
      cnt++;
    }
    else {
      /* syntax error */
      return (NULL);
    }
    if ( cnt == index ) return ( make_str(namep, len) );
  }
  return (NULL);
}


/*
 * get_agent_parameter()
 *     str := instance_name1(prm_str, ...) instance_name2(...)
 */
static
char*
get_agent_parameter(int index, char *str)
{
  int	cnt, len;
  char	*p, *prm_startp;
  int	state;

  if ( str == NULL ) return (NULL);
  p = str;
  cnt = 0;
  len = 0;

  while ( *p != NULL ) {
    len = 0;
    while ( *p == SPACE_CONST ) p++;
    state = 1;
    while ( *p != NULL && state != 4 ) {
      switch ( state ) {
      case 1 :
	while ( *p != '(' ) p++;
        if ( *(p+1) != ')' ) {
          prm_startp = p+1;
          len++;
        }
        else {
          prm_startp = NULL;
          len = 0;
        }
	state = 2;
	break;
      case 2 :
	while ( *p != ')' && *p != '\"' ) {
	  p++; len++;
	}
	if ( *p == ')' ) {
	  len--; state = 4;
	}
	else if ( *p == '\"' ) state = 3 ;
	break;
      case 3 :
	while ( *p != '\"' ) {
	  p++; len++;
	}
        if ( *(p-1) == '\\' && *p == '\"' ) state = 3;
        else  state = 2;
	break;
      }
      p++;
      if ( state == 2 || state == 3 ) len++;
      else if ( state == 4 ) len--;
    }
    if ( state == 4 ) {
      state = 0;
      cnt++;
    }
    else {
      /* syntax error */
      return (NULL);
    }
    if ( cnt == index ) return ( make_str(prm_startp, len) );
  }
  return (NULL);
}


/*
 * make_str()
 */
static
char*
make_str(char *sp, int length)
{
  char	*p;

  p = (char*)calloc(length+1, 1);
  if ( p == NULL ) return (NULL);

  strncpy(p, sp, length);
  return (p);
}


/*
 * gen_update_info_new()
 */
static
char*
gen_update_info_new(int num)
{
  int	len, i, op_len, env_len, name_len, id_len;
  char	*update_info, *env, *name, *id, *parameter;

  env = ePrmGetEnvID();
  env_len = strlen(env);
  op_len = strlen(ADD_AGENT);
  len = 0;
  for ( i = 0; i < num; i++ ) {
    ePrmGetNewInstance(&name, &id, &parameter);
    ePrmPutNewInstance(name, id, parameter);
    name_len = strlen(name);
    id_len = strlen(id);
    len += op_len + 1 + env_len + 1 + name_len + 1 + id_len + 1;
  }

  update_info = (char*)malloc( len );
  if ( update_info == NULL ) return (NULL);

  update_info[0] = NULL;
  for ( i = 0; i < num; i++ ) {
    ePrmGetNewInstance(&name, &id, &parameter);
    ePrmPutNewInstance(name, id, parameter);
    strcat(update_info, ADD_AGENT);
    strcat(update_info, SPACE_STR);
    strcat(update_info, env);
    strcat(update_info, SPACE_STR);
    strcat(update_info, name);
    strcat(update_info, SPACE_STR);
    strcat(update_info, id);
    strcat(update_info, SPACE_STR);
  }
  update_info[len] = NULL;
  return ( update_info );
}


/*
 * gen_update_info_old()
 */
static
char*
gen_update_info_old(int num)
{
  int	len, i, op_len, env_len, name_len, id_len;
  char	*update_info, *env, *name, *id, *parameter;

  env = ePrmGetEnvID();
  env_len = strlen(env);
  op_len = strlen(ADD_AGENT);
  len = 0;
  for ( i = 0; i < num; i++ ) {
    ePrmGetOldInstance(&name, &id, &parameter);
    ePrmPutOldInstance(name, id, parameter);
    name_len = strlen(name);
    id_len = strlen(id);
    len += op_len + 1 + env_len + 1 + name_len + 1 + id_len + 1;
  }
    
  update_info = (char*)malloc( len );
  if ( update_info == NULL ) return (NULL);

  update_info[0] = NULL;
  for ( i = 0; i < num; i++ ) {
    ePrmGetOldInstance(&name, &id, &parameter);
    ePrmPutOldInstance(name, id, parameter);
    strcat(update_info, ADD_AGENT);
    strcat(update_info, SPACE_STR);
    strcat(update_info, env);
    strcat(update_info, SPACE_STR);
    strcat(update_info, name);
    strcat(update_info, SPACE_STR);
    strcat(update_info, id);
    strcat(update_info, SPACE_STR);
  }
  update_info[len] = NULL;
  return ( update_info );
}


/*
 * get_matched_name()
 */
static
char*
get_matched_name(char *info, char *aid)
{
  char	*buf, *cmd, *env, *name, *agentID;
  char	*matched_name;

  buf = strdup(info);
  if ( buf == NULL ) return (NULL);

  cmd = strtok(buf, SPACE_STR);

  do {
    if ( !strcmp(ADD_AGENT, cmd) ) {
      env = strtok(NULL, SPACE_STR);
      name = strtok(NULL, SPACE_STR);
      agentID = strtok(NULL, SPACE_STR);
      if ( !strcmp(aid, agentID) ) {
	matched_name = strdup(name);
        if ( matched_name == NULL ) return (NULL);
	free(buf);
	return (matched_name);
      }
    }
    else {
      strtok(NULL, SPACE_STR);
      strtok(NULL, SPACE_STR);
      strtok(NULL, SPACE_STR);
    }
  } while ( (cmd = strtok(NULL, SPACE_STR)) );
  return (NULL);
}


/*
 * add_parameter_to_info()
 */
static
char*
add_parameter_to_info(char *update_info, char *parameter)
{
  int	len = 0;
  char	*new_update_info;

  len = strlen(PRM_CMD);
  if ( update_info != NULL ) len += strlen(update_info);
  if ( parameter != NULL ) len += strlen(parameter);
  len += 3;

  new_update_info = (char*)calloc(len, 1);
  if ( new_update_info == NULL ) return (NULL);

  strcpy(new_update_info, update_info);
  strcat(new_update_info, SPACE_STR);
  strcat(new_update_info, PRM_CMD);
  strcat(new_update_info, SPACE_STR);
  strcat(new_update_info, parameter);

  return ( new_update_info );
}

/*** END OF FILE ***/
