/*
 * file name: eInit.c
 *
 */

/* EXAMPLE  init_environment(int argc, char **arg)  <---- ENVL compiler out put.
 *
 *	init_agent_server();
 *	init_global_pool();
 *	eInitArg(arg);
 *	eInitStart();
 *	eInitSetEnv("env1_name", "0.1");          
 *	eInitSetEnv("env2_name", "0.1.3");
 *	eInitSetEnv("env3_name", "0.1.3.2");
 *	   :
 *	   :
 *	eInitMyAid("0.1.3.2.5.1")
 *	eInitSetPrmInfo("0.1", "0.1.4", "tmp_name");
 *         :
 *	eInitEnd();
 *
 */

/* EXAMPLE  init_environment(int argc, char **arg)   for parametric agent
 *   
 *	
 *	init_agent_server();
 *	init_global_pool();
 *	eInitArg(arg);
 *	eInitStart();
 *	eInitSetEnv("env1", "0.1");
 *	eInitSetEnv("env2", "0.1.2");
 *	eInitSetPrmInfo("0.1", "0.1.4", "tmp_name");
 *	   :
 *	eInitEnd();
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	<helios/eInit.h>
#include	"eAidAdm.h"
#include	"eQAdm.h"
#include	"ePAdm.h"
#include	"eAidObj.h"
#include	"eMidObj.h"
#include	"eEAObj.h"
#include	"eESObj.h"
#include	"eSmes.h"
#include	"eWaitObj.h"
#include	"eTimeObj.h"
#include	"eCapOfEnv.h"
#include	"eArg.h"
#include	"ePrmAidObj.h"
#include	"eTimeOut.h"


/*
 * eInitArg()
 */
void
eInitArg(int argc, char **arg)
{
  long	time;
  int	sock_num, i;

  sock_num = atoi(arg[1]);
  eArgSetSockNum(sock_num);

  for ( i = 2; i < argc; i++ ) {
    if ( !strcmp(arg[i], "-timeout") ) {
      time = atoi(arg[i+1]);
      eArgSetTimeOut(time);
      eTimeOutSwitch(ON);
      return;
    }
  }
}


/*
 * eInitSetPrmInfo()
 */
int
eInitSetPrmInfo(char *env_id, char *aid, char *template_name)
{
  PrmAidObj	*op;

  op = ePrmAidObjNew(env_id, aid, template_name);
  if ( op == NULL ) return (EALLOC);

  ePAdmPut(PRMAID_OBJ_POOL, op);
  return (NORMAL);
}


/*
 * eInitStart()
 */
int
eInitStart(void)
{
  int	status;

  status = eQAdmInit(INIT_AIDOBJ_Q, eAidObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(AIDOBJ_POOL, eAidObjMatch, eAidObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(RECV_MID_POOL, eMidObjMatch, eMidObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(BAGOF_MID_POOL, eMidObjMatch, eMidObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(FAST_MID_POOL, eMidObjMatch, eMidObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(SEQ_MID_POOL, eMidObjMatch, eMidObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(EAOBJ_POOL, eEAObjMatch, eEAObjPrint);
  if ( status != NORMAL ) return (status);

  status = eQAdmInit(ESOBJ_QUEUE, eESObjPrint);
  if ( status != NORMAL ) return (status);

  status = eQAdmInit(RTN_SMES_Q, eSmesPrint);
  if ( status != NORMAL ) return (status);

  status = eQAdmInit(WAIT_OBJ_Q, eWaitObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(TIME_OBJ_POOL, eTimeObjMatch, eTimeObjPrint);
  if ( status != NORMAL ) return (status);

  status = ePAdmInit(PRMAID_OBJ_POOL, ePrmAidObjMatch, ePrmAidObjPrint);
  if ( status != NORMAL ) return (status);

  return (NORMAL);
}


/*
 * eInitSetEnv()
 */
int
eInitSetEnv(char *env_name, char *aid)
{
  AidObj	*op;

#ifndef	ENV_DEBUG
  /* init CapOfEnv */
  eCapOfEnv_init(aid);
#endif

  op = eAidObjNew(env_name, aid);
  if ( op == NULL ) return (EALLOC);

  eQAdmPut(INIT_AIDOBJ_Q, op);
  return (NORMAL);
}


/*
 * eInitMyAid()
 */
int
eInitMyAid(char *my_aid)
{
  return ( eAidAdmSetMyProcAid(my_aid) );
}


/*
 * eInitEnd()
 */
int
eInitEnd(void)
{
  return ( eAidAdmInitHiaStruct(INIT_AIDOBJ_Q) );
}

/*** END OF FILE ***/
