/*
 * file name : eFlush.c
 *
 */

#include	<stdio.h>
#include	<errno.h>
#include	<helios/envdef.h>
#include	"eFlush.h"
#include	"eWaitObj.h"
#include	"eQAdm.h"
#include	"eCom.h"

/*
 * eFlush()
 */
void
eFlush(void)
{
  WaitObj	*wp;
  char	*Ames, *to_aid;
  int	rpc_id, size, status;

  while ( 1 ) {
    wp = eQAdmGet(WAIT_OBJ_Q);
    if ( wp == NULL ) return;

    Ames = eWaitObjGetAmes(wp);
    to_aid = eWaitObjGetTo(wp);
    size = eWaitObjGetSize(wp);

    status = eComSendAMessage(to_aid, &rpc_id, Ames, size);
    if ( status == -EAGAIN || status == -ENOMEM ) {
      eQAdmPutBack(WAIT_OBJ_Q, wp);
      return;
    }
    eWaitObjDelete(wp);
  }
  return;
}

/*** END OF FILE ***/
