/*
 * file name: eFast.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<helios/envdef.h>
#include	"eFast.h"
#include	"eESObj.h"
#include	"eMidObj.h"
#include	"eSmes.h"
#include	"eEnv.h"
#include	"eAidAdm.h"
#include	"eAgntDir.h"
#include	"eSMessage.h"
#include	"eCapOfEnv.h"
#include        "eTrace.h"
#include        "eDispatch.h"
#include        "ePAdm.h"
#include        "eQAdm.h"
#include	"eUtil.h"
#include	"eAmes.h"
#include	"eInterEnv.h"
#include	"ePrmAidObj.h"
#include	"eUpper.h"


/*** static function ***/
static	void	delete_ESObj(ESObj *sobj);
static	void	rtn_Smes(ESObj *sobj);
static	int	check_recv_num(MidObj *mobj);


/*
 * eFastSendProc()
 */
int
eFastSendProc(SMessage Smes, int mode, char *org_from, char *env)
{
  SMessage	upperSmes, currentSmes, Smes_for_prm;
  SMTo	to_field;
  MidObj	*mobj;
  char	*Afrom_aid, *func, *management, *from_aid;
  char	*to_aid, *current_env, *mid, *from, *method, *new_method = NULL;
  int	order, status;
  char  *tmp_mid, *user_id; /* 10/25 */


  from_aid = eAidAdmGetMyProcAid();

  if ( env == NULL && mode == 0 ) {
    eAidAdmMoveToBottomEnv();
    current_env = eAidAdmGetAidOfCurrentEnv();
  }
  else if ( !strcmp(env, "top") ) {
    /* send to user, destination is only one */
    /* not use mid_pool */
    tmp_mid = eSmesGetSmid(Smes);
    user_id = eUtilGetUid(tmp_mid);
    if ( user_id == NULL ) return (EALLOC);

    status = eDispatchSendSmes(Smes, user_id, NULL);
    if ( status != NORMAL ) return (status);

    free(user_id);
    eSmesDelete(Smes);
    return (status);
  }
  else if ( env != NULL && mode == 0 ) {
    eAidAdmSetAidOfCurrentEnv(env);
    eTraceMessage(env, Smes);
  }
  else {
    eAidAdmSetAidOfCurrentEnv(env);
  }

  currentSmes = Smes;
  while ( 1 ) {
    current_env = eAidAdmGetAidOfCurrentEnv();
    mid = eSmesGetSmid(currentSmes);
    to_field = eSmesGetSto(currentSmes);
    method = eSmesGetSmethod(currentSmes);
    from = eSmesGetSfrom(currentSmes);
    func = eSmesGetSAF(currentSmes);
    management = eSmesGetSmanag(currentSmes);

    to_aid = eAgntDirSearchAgentId(currentSmes, current_env, mid, 
                                   from, to_field, method, 
				   &new_method, &Smes_for_prm);
    if ( to_aid == NULL ) {
      if ( mode == 1 ) return (ERROR); /* bad CAPL */

      current_env = eAidAdmGetAidOfCurrentEnv();
      if ( new_method != NULL ) free(new_method);
      new_method = NULL;

      /* convert Smessage. in-->out */
      upperSmes = eCapOfEnv(current_env, currentSmes, 1);

      if ( eAidAdmMoveToAidOfUpperEnv() == TOP_ENV ) {
	/* send to user */
        tmp_mid = eSmesGetSmid(upperSmes);
        user_id = eUtilGetUid(tmp_mid);
        if ( user_id == NULL ) return (EALLOC);

        status = eDispatchSendSmes(upperSmes, user_id, NULL);
        if ( status != NORMAL ) return (status);

        free(user_id);
	eSmesDelete(upperSmes);
	return (NORMAL);
      }
      if ( upperSmes != NULL ) {
	currentSmes = upperSmes;
	eTraceMessage(current_env, upperSmes);
      }
      continue;
    }
    /* not send to myself */
    else if ( mode == 0 && !strcmp(to_aid, from_aid) ) {
      free(to_aid);
      if ( new_method != NULL ) free(new_method);
      new_method = NULL;
      continue;
    }
    else if ( ePrmAidObjIsPrmAid(to_aid) == TRUE &&
	      Smes_for_prm == NULL ) {
      /* destination is parametric agent */
      if ( mode == 0 ) {
	from_aid = NULL;
      }
      else if ( mode == 1 ) {
	from_aid = org_from;
      }
      status = eInterEnvSendToPrm(FAST_MID_POOL, to_aid,
				  current_env, from_aid, currentSmes);
      free(to_aid);
      return (status);
    }
    else {
      Afrom_aid = eAidAdmGetMyProcAid();

      if ( Smes_for_prm == NULL ) {
	if ( new_method != NULL ) {
	  eSmesSetSmethod(currentSmes, new_method);
	}
	status = eDispatchSendSmes(currentSmes, to_aid, NULL);
      }
      else {
	if ( new_method != NULL ) {
	  eSmesSetSmethod(Smes_for_prm, new_method);
	}
	status = eDispatchSendSmes(Smes_for_prm, to_aid, NULL);
	eSmesDelete(Smes_for_prm);
      }
      
      if ( status != NORMAL ) return (status);

      if ( mode == 1 ) {
	Afrom_aid = org_from;
      }

      mobj = eMidObjNew(mid, Afrom_aid, current_env, func, management);
      if ( mobj == NULL ) return (EALLOC);

      if ( new_method != NULL && Smes_for_prm == NULL ) {
	free( eSmesGetSmethod(currentSmes) );
	eSmesSetSmethod(currentSmes, method);
	free(method);
	method = eSmesGetSmethod(currentSmes);
	free(new_method);
	new_method = NULL;
      }

      eMidObjSetFromUpperFlag(mobj, mode);
      eMidObjSetSmes(mobj, currentSmes);
      eMidObjIncrTotalSendNum(mobj);
      order = 1;
      eMidObjDestAidPPut(mobj, to_aid, order);
      ePAdmPut(FAST_MID_POOL, mobj);
      free(to_aid);
    }

    while ( 1 ) {
      to_aid = eAgntDirSearchAgentId(currentSmes, current_env, mid, 
                                     from, to_field, method, 
				     &new_method, &Smes_for_prm);
      if ( to_aid == NULL ) {
	if ( new_method != NULL ) free(new_method);
	break;
      }

      /* not send to myself */
      if ( mode == 0 && !strcmp(to_aid, from_aid) ) {
	free(to_aid);
	if ( new_method != NULL ) free(new_method);
	new_method = NULL;
	continue;
      }

      if ( ePrmAidObjIsPrmAid(to_aid) == TRUE &&
	   Smes_for_prm == NULL ) {
	/* destination is parametric agent */
	status = eInterEnvSendToPrm2(mobj, to_aid, current_env,
 				     currentSmes);
	free(to_aid);
	return (status);
      }

      if ( Smes_for_prm == NULL ) {
	if ( new_method != NULL ) {
	  eSmesSetSmethod(currentSmes, new_method);
	}
	status = eDispatchSendSmes(currentSmes, to_aid, NULL);
      }
      else {
	if ( new_method != NULL ) {
	  eSmesSetSmethod(Smes_for_prm, new_method);
	}
	status = eDispatchSendSmes(Smes_for_prm, to_aid, NULL);
	eSmesDelete(Smes_for_prm);
      }

      if ( status != NORMAL ) return (status);

      eMidObjIncrTotalSendNum(mobj);
      order++;
      eMidObjDestAidPPut(mobj, to_aid, order);
      if ( new_method != NULL && Smes_for_prm == NULL ) {
	free( eSmesGetSmethod(currentSmes) );
	eSmesSetSmethod(currentSmes, method);
	free(method);
	method = eSmesGetSmethod(currentSmes);
	free(new_method);
	new_method = NULL;
      }
      free(to_aid);
    }
    return (NORMAL);
  }
}


/*
 * eFastSendProcToPrm()
 */
int
eFastSendProcToPrm(MidObj *mobj, char *Ames)
{
  SMessage	orgSmes, Smes, Smes_for_prm;
  SMTo	to_field;
  char	*AF, *management;
  char	*mid, *env, *method, *new_method = NULL, *from;
  char	*all_name_aid, *to_aid, *inst_name, *inst_aid;
  char	*my_aid;
  int	order, i=0, status, mode;

  mode = eMidObjGetFromUpperFlag(mobj);

  if ( mode == 0 ) {
    my_aid = eAidAdmGetMyProcAid();
  }
  else if ( mode == 1 ) {
    my_aid = "-----";
  }

  all_name_aid = eAmesGetAInfo(Ames);
  order = eMidObjGetTotalSendNum(mobj);
  orgSmes = eMidObjGetSmes(mobj);
  Smes = eSmesDuplicate(orgSmes);

  inst_name = strtok(all_name_aid, " ");
  while ( inst_name ) {
    i++;
    AF = eSmesGetSAF(Smes);
    management = eSmesGetSmanag(Smes);
    free(AF);
    free(management);
    status = eSmesSetSAF(Smes, inst_name);
    if ( status != NORMAL ) return (status);
    status = eSmesSetSmanag(Smes, NULL);
    if ( status != NORMAL ) return (status);

    inst_aid = strtok(NULL, " ");

    if ( strcmp(my_aid, inst_aid) ) {
      if ( i != 1 ) {
	eMidObjIncrTotalSendNum(mobj);
	order++;
      }

      eMidObjDestAidPPut(mobj, inst_aid, order);

      status = eDispatchSendSmes(Smes, inst_aid, NULL);
      if ( status != NORMAL ) return (status);
    }

    inst_name = strtok(NULL, " ");
  }
  eSmesDelete(Smes);

  mid = eMidObjGetMid(mobj);
  env = eMidObjGetEnv(mobj);
  method = eSmesGetSmethod(orgSmes);
  from = eAidAdmGetMyProcAid();
  to_field = eSmesGetSto(orgSmes);

  while ( 1 ) {
    to_aid = eAgntDirSearchAgentId(orgSmes, env, mid, 
				   from, to_field, method, 
				   &new_method, &Smes_for_prm);
    if ( to_aid == NULL ) {
      if ( new_method != NULL )  free(new_method);
      break;
    }
    
    if ( mode == 0 && !strcmp(to_aid, from) ) {
      /* not send myself */
      free(to_aid);
      if ( new_method != NULL ) free(new_method);
      new_method = NULL;
      continue;
    }

    if ( ePrmAidObjIsPrmAid(to_aid) == TRUE ) {
      /* destination is parametric agent */
      status = eInterEnvSendToPrm2(mobj, to_aid, env, orgSmes);
      free(to_aid);
      return (status);
    }
    
    if ( new_method != NULL ) {
      eSmesSetSmethod(orgSmes, new_method);
    }

    status = eDispatchSendSmes(orgSmes, to_aid, NULL);
    if ( status != NORMAL ) return (status);
    
    eMidObjIncrTotalSendNum(mobj);
    order++;
    eMidObjDestAidPPut(mobj, to_aid, order);
    if ( new_method != NULL ) {
      free( eSmesGetSmethod(orgSmes) );
      eSmesSetSmethod(orgSmes, method);
      free(method);
      method = eSmesGetSmethod(orgSmes);
      free(new_method);
      new_method = NULL;
    }
    free(to_aid);
  }
  free(Ames);
  return (NORMAL);
}


/*
 * eFastRecvProc()
 */
int
eFastRecvProc(ESObj *sobj, MidObj *mobj)
{
  SMessage	Smes;
  char	*env;
  ESObj	*sp;
  char	*ts;
  char	*from_aid;
  int	effective_order, recv_num;
  int	mode;
  int	i;

  mode = eMidObjGetFromUpperFlag(mobj);

  if ( mode == 0 ) {
    /* move to bottom env and convert S_message */
    eEnvMoveToBottomEnv(sobj);
  }
  else if ( mode == 1 ) {
    env = eESObjGetEnv(sobj);
    Smes = eESObjGetSmes(sobj);
  }

  /* increment number of reply message */
  eMidObjIncrRecvNum(mobj);

  from_aid = eESObjGetFromProc(sobj);

  /* get current effective_order */
  effective_order = eMidObjGetEffectiveOrder(mobj);

  recv_num = eMidObjGetRecvNum(mobj);

  /* check effective_order */
  if ( effective_order < 0 ) { /* already received normal reply */
    delete_ESObj(sobj);
    check_recv_num(mobj);
    return (NORMAL);
  }    

  if ( eMidObjGetOrderOfMatchedAid(mobj, from_aid) > effective_order ) {
    /* order > effective_order */
    /* put waiting queue */
    eMidObjESObjQPut(mobj, sobj);
  }
  else { /* order == effective_order */
    ts = eSmesGetSts( eESObjGetSmes(sobj) );
    if ( ts == NULL ) ts = "";

    if ( strcmp(ts, NORMAL_STR) ){
      /* status is not normal */
      eMidObjESObjQPut(mobj, sobj);

      /* count up effective_order */
      eMidObjSetEffectiveOrder(mobj, effective_order+1);

      for ( i = 0; i < recv_num; i++ ) {
	sp = eMidObjESObjQGet(mobj);
	from_aid = eESObjGetFromProc(sp);

	/* get current effective_order */
	effective_order = eMidObjGetEffectiveOrder(mobj);

	if ( effective_order == eMidObjGetOrderOfMatchedAid(mobj,
							    from_aid) ) {
	  /* check status */
	  ts = eSmesGetSts(eESObjGetSmes(sp));
	  if ( ts == NULL ) ts = "";

	  if ( strcmp(ts, NORMAL_STR) ) {
	    /* status is not normal */
	    eMidObjSetEffectiveOrder(mobj, effective_order+1);

	    /* reset counter */
	    i = 0;

	    eMidObjESObjQPut(mobj, sp);
	    continue;
	  }

	  /* order of from_aid == effective_order */
	  mode = eMidObjGetFromUpperFlag(mobj);
	  if ( mode == 0 ) {
	    rtn_Smes(sp);
	  }
	  else if ( mode == 1 ){
	    eUpperSendReply(eESObjGetSmes(sp), mobj);
	    eESObjDeleteExceptSmes(sp);
	  }
	  
	  /* set end flag */
	  eMidObjSetEffectiveOrder(mobj, -1);
	  break;
	}
	else {
	  eMidObjESObjQPut(mobj, sp);
	}
      } /* for end */
    }
    else { /* status is normal. received fast message */
      mode = eMidObjGetFromUpperFlag(mobj);
      if ( mode == 0 ) {
	rtn_Smes(sobj);
      }
      else if ( mode == 1 ){
	eUpperSendReply(eESObjGetSmes(sobj), mobj);
	eESObjDeleteExceptSmes(sobj);
      }

      /* set end flag */
      eMidObjSetEffectiveOrder(mobj, -1);
    }
  }
  return ( check_recv_num(mobj) );
}


/*
 * delete_ESObj()
 */
static
void
delete_ESObj(ESObj *sobj)
{
  eSmesDelete( eESObjGetSmes(sobj) );
  eESObjDeleteExceptSmes(sobj);
}


/*
 * rtn_Smes()
 */
static
void
rtn_Smes(ESObj *sobj)
{
  eQAdmPut(RTN_SMES_Q, eESObjGetSmes(sobj) );
  eESObjDeleteExceptSmes(sobj);
}


/*
 * check_recv_num()
 */
static
int
check_recv_num(MidObj *mobj)
{
  SMessage	currentSmes, upperSmes;
  char	*env, *upper_env;
  char	*mid, *debug, *from, *AF, *method;
  int	recv_num, total_num;
  int 	mode;

  recv_num = eMidObjGetRecvNum(mobj);
  total_num = eMidObjGetTotalSendNum(mobj);

  mode = eMidObjGetFromUpperFlag(mobj);

  if ( mode == 0 && (total_num == recv_num) 
       && (eMidObjGetEffectiveOrder(mobj) != -1) ) {
    /* normal status reply is nothing */
    currentSmes = eMidObjGetSmes(mobj);
    env = eMidObjGetEnv(mobj);
    upperSmes = eCapOfEnv(env, currentSmes, 1);
    upper_env = eAidAdmGetAidOfUpperEnv(env);

    mid = eMidObjGetMid(mobj);
    ePAdmGet(FAST_MID_POOL, mid);
    eMidObjDelete(mobj);

    /* try in upper environment */
    return ( eFastSendProc(upperSmes, 0, NULL, upper_env) );
  }
  else if ( mode == 1 && (total_num == recv_num) 
       && (eMidObjGetEffectiveOrder(mobj) != -1) ) {
    /* normal status reply is nothing */
    currentSmes = eMidObjGetSmes(mobj);
    env = eMidObjGetEnv(mobj);

    debug = eSmesGetSdebug(currentSmes);
    from = eSmesGetSfrom(currentSmes);
    AF = eSmesGetSAF(currentSmes);
    method = eSmesGetSmethod(currentSmes);
    mid = eMidObjGetMid(mobj);
    upperSmes = eSmesNew(REPLY, debug, mid, AF, OFF, from, FAST_STR,
			 "abnormal", method, NULL);
    if ( upperSmes == NULL ) return (EALLOC);

    eUpperSendReply(upperSmes, mobj);

    mid = eMidObjGetMid(mobj);
    ePAdmGet(FAST_MID_POOL, mid);
    eMidObjDelete(mobj);
  }
  else if ( total_num == recv_num ) {
    currentSmes = eMidObjGetSmes(mobj);
    eSmesDelete(currentSmes);

    mid = eMidObjGetMid(mobj);
    ePAdmGet(FAST_MID_POOL, mid);
    eMidObjDelete(mobj);
  }
  return (NORMAL);
}

/*** END OF FILE ***/
