/*
 * file name: eEnv.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eEnv.h"
#include	"eBagOf.h"
#include	"eFast.h"
#include	"eSeq.h"
#include	"eNormal.h"
#include	"eESObj.h"
#include	"eMidObj.h"
#include	"eSmes.h"
#include	"eDispatch.h"
#include	"eRSmes.h"
#include	"eRAmes.h"
#include	"eAidAdm.h"
#include	"eAidAna.h"
#include	"eQAdm.h"
#include	"ePAdm.h"
#include	"eCapOfEnv.h"
#include	"eSMessage.h"
#include	"eTrace.h"
#include	"eInterEnv.h"
#include	"eToEnv.h"
#include	"ePrmAidObj.h"
#include	"ePrm.h"


/*** static function ***/
static	int	proc_send_ask_Smes(SMessage Smes);
static	int	proc_send_reply_Smes(SMessage Smes);

static	int	proc_recv_Smes(ESObj *sobj);
static	int	proc_recv_ask_Smes(ESObj *sobj);
static	int	proc_recv_reply_Smes(ESObj *sobj);
static	int	proc_recv_cntl_Smes(ESObj *sobj);



/*
 * eEnvSendMes()
 */
int
eEnvSendMes(SMessage Smes)
{
  int	mes_type;

  mes_type = eSmesGetStype(Smes);

  if ( mes_type == ASK ) {
    return ( proc_send_ask_Smes(Smes) );
  }
  else if ( mes_type == REPLY ) {
    return ( proc_send_reply_Smes(Smes) );
  }
  else {
    /* message type error */
    return (ERROR);
  }
}


/*
 * eEnvRecvMes()
 */
int
eEnvRecvMes(SMessage *rSmes)
{
  ESObj	*sobj;
  char	*Ames;
  int	size, rpc_id;
  int	status;

  status = eRAmesReadAll();
  if ( status != NORMAL ) return (status);

  while ( eRAmesCntlNotNormal(&Ames, &size, &rpc_id) == NORMAL ) {
    /* process interenvironment control message */
    status = eInterEnvProcMsg(Ames);
    if ( status != NORMAL ) return (status);
  }

  status = eRSmesMake();
  if ( status != NORMAL ) return (status);

  while ( (sobj = eQAdmGet(ESOBJ_QUEUE)) ) {
    status = proc_recv_Smes(sobj);
    if ( status != NORMAL ) return (status);
  }

  *rSmes = eQAdmGet(RTN_SMES_Q);
  if ( *rSmes == NULL ) return (ERROR);
  return (NORMAL);
}


/*
 * eEnvMoveToBottomEnv()
 */
void
eEnvMoveToBottomEnv(ESObj *sobj)
{
  SMessage	Smes, newSmes;
  char	*current_env, *env_level;

  /* get environment level of S_message */
  env_level = eESObjGetEnv(sobj);

  if ( !strcmp(env_level, USER_ENV_LEVEL) ) { /* env_level is user */
    Smes = eESObjGetSmes(sobj);
    eAidAdmMoveToTopEnv();
    current_env = eAidAdmGetAidOfCurrentEnv();
    newSmes = eCapOfEnv(current_env, Smes, 0);
    eTraceMessage(current_env, newSmes);
    eESObjSetSmes(sobj, newSmes);
  }
  else {
    eTraceMessage(env_level, eESObjGetSmes(sobj) );

    /* set the environment level to current environment */
    eAidAdmSetAidOfCurrentEnv(env_level);
  }

  while ( 1 ) {
    Smes = eESObjGetSmes(sobj);

    /* move to lower environment */
    if ( eAidAdmMoveToAidOfLowerEnv() == BOTTOM_ENV ) return;

    current_env = eAidAdmGetAidOfCurrentEnv();

    /* convert S_message */
    newSmes = eCapOfEnv(current_env, Smes, 0);
    if ( newSmes == NULL ) newSmes = Smes;
    eTraceMessage(current_env, newSmes);
    eESObjSetSmes(sobj, newSmes);
  }
}


/*
 * proc_send_ask_Smes()
 */
static
int
proc_send_ask_Smes(SMessage Smes)
{
  char	*bottom_env;

  /*** dbg_write for monitor ***/
  eAidAdmMoveToBottomEnv();
  bottom_env = eAidAdmGetAidOfCurrentEnv();
  eTraceMessage(bottom_env, Smes);

  if ( eSmesIsEnv(Smes) ) {
    return ( eToEnvSendProc(Smes) );
  }
  else if ( eSmesIsBagOf(Smes) || eSmesIsBagOf2(Smes)
                            || eSmesIsBagOfNum(Smes) ) {
    return ( eBagOfSendProc(Smes, 0, NULL, NULL) );
  }
  else if ( eSmesIsSeq(Smes) ) {
    return ( eSeqSendProc(Smes, 0, NULL, NULL) );
  }
  else if ( eSmesIsFast(Smes) ) {
    return ( eFastSendProc(Smes, 0, NULL, NULL) );
  }
  else {
    /* normal ask message. To_field is agent name */
    return ( eNormalSendProc(Smes) );
  }
}


/*
 * proc_send_reply_Smes()
 */
static
int
proc_send_reply_Smes(SMessage Smes)
{
  SMessage	upperSmes, currentSmes;
  MidObj	*mobj;
  char	*mid, *from_proc, *my_proc_aid, *common_env, *current_env;
  char	*Afrom;
  int	status;

  mid = eSmesGetSmid(Smes);

  mobj = ePAdmGet(RECV_MID_POOL, mid);
  from_proc = eMidObjGetFromProc(mobj);
  my_proc_aid = eAidAdmGetMyProcAid();
  Afrom = eMidObjDestAidPGet(mobj);
  
  eAidAnaGetAidOfCommonEnv(my_proc_aid, from_proc, &common_env);

  eAidAdmMoveToBottomEnv();

  currentSmes = Smes;
  while ( 1 ) {
    current_env = eAidAdmGetAidOfCurrentEnv();
    if ( !strcmp(current_env, common_env) ) {
      status = eDispatchSendSmes(currentSmes, from_proc, Afrom);
      if ( status != NORMAL ) return (status);

      eSmesDelete(currentSmes);
      eMidObjDelete(mobj);
      free(common_env);
      free(Afrom);
      return (NORMAL);
    }
    else {
      /* convert Smessage */
      upperSmes = eCapOfEnv(current_env, currentSmes, 1);
      if ( eAidAdmMoveToAidOfUpperEnv() == TOP_ENV ) {
	/* send to user */
	status = eDispatchSendSmes(upperSmes, from_proc, Afrom);
	if ( status != NORMAL ) return (status);

	eSmesDelete(upperSmes);
	eMidObjDelete(mobj);
	free(common_env);
	free(Afrom);
	return (NORMAL);
      }
      if ( upperSmes != NULL ) currentSmes = upperSmes;
    }
  }
}


/*
 * proc_recv_Smes()
 */
static
int
proc_recv_Smes(ESObj *sobj)
{
  int	mes_type;

  mes_type = eSmesGetStype( eESObjGetSmes(sobj) );

  if ( mes_type == ASK ) {
    /* message type is ASK */
    return ( proc_recv_ask_Smes(sobj) );
  }
  else if ( mes_type == REPLY ) {
    /* message type is REPLY */
    return ( proc_recv_reply_Smes(sobj) );
  }
  else if ( mes_type == CONTROL ) {
    /* message type is CONTROL */
    return ( proc_recv_cntl_Smes(sobj) );
  }
  else {
    /* message type error */
    return (ERROR);
  }
}


/*
 * proc_recv_ask_Smes()
 */
static
int
proc_recv_ask_Smes(ESObj *sobj)
{
  SMessage	lowerSmes, Smes;
  MidObj	*mobj;
  char	*current_env, *com_level_env;
  char 	*mid, *from_aid, *to_aid, *func, *management;
  int	status;

  /* get communication level of environment */
  com_level_env = eESObjGetEnv(sobj);

  if ( !strcmp(com_level_env, USER_ENV_LEVEL) ) { /* env_level is user */
    Smes = eESObjGetSmes(sobj);
    eAidAdmMoveToTopEnv();
    current_env = eAidAdmGetAidOfCurrentEnv();
    lowerSmes = eCapOfEnv(current_env, Smes, 0);
    if ( lowerSmes != Smes ) eSmesDelete(Smes);  /* ??? */

    /*** dbg_write for monitor ***/
    eTraceMessage(current_env, lowerSmes);

    eESObjSetSmes(sobj, lowerSmes);

    /* dispatch message or delegation */
    status = eDispatchRecvSmes(sobj);
    if ( status != NORMAL ) return (status);

    eESObjDeleteExceptSmes(sobj);
    return (NORMAL);
  }


  eAidAdmSetAidOfCurrentEnv(com_level_env);

  if ( eAidAdmMoveToAidOfLowerEnv() == BOTTOM_ENV ) {
    /* this message will be sent to substance */

    current_env = eAidAdmGetAidOfCurrentEnv();

    /* store mid and from_aid in pool */
    mid = eSmesGetSmid( eESObjGetSmes(sobj) );
    from_aid = eESObjGetFromProc(sobj);
    to_aid = eESObjGetToProc(sobj);
    func = eSmesGetSAF( eESObjGetSmes(sobj) );
    management = eSmesGetSmanag( eESObjGetSmes(sobj) );

    if ( ePrmAidObjIsPrmAid(to_aid) == TRUE ) {
      to_aid = eAidAdmGetMyProcAid();
    }

    mobj = eMidObjNew(mid, from_aid, current_env, func, management);
    eMidObjDestAidPPut(mobj, to_aid, 1);

    ePAdmPut(RECV_MID_POOL, mobj);

    /* store returned Smes in queue */
    eQAdmPut(RTN_SMES_Q, eESObjGetSmes(sobj) );
    eESObjDeleteExceptSmes(sobj);
    return (NORMAL);
  }

  /* Lower is environment */
  current_env = eAidAdmGetAidOfCurrentEnv();

  /* convert SMessage.  out-->in */
  lowerSmes = eCapOfEnv(current_env, eESObjGetSmes(sobj), 0);

  if ( lowerSmes == NULL && ePrmIsParam() == TRUE ) {
    lowerSmes = eESObjGetSmes(sobj);
  }

  /*** dbg_write for monitor ***/
  eTraceMessage(current_env, lowerSmes);

  if ( lowerSmes != eESObjGetSmes(sobj) ) {
    eSmesDelete(eESObjGetSmes(sobj));
  }
  eESObjSetSmes(sobj, lowerSmes);
   
  /* dispatch message or delegetaion */
  status = eDispatchRecvSmes(sobj);
  if ( status != NORMAL ) return (status);

  eESObjDeleteExceptSmes(sobj);
  return (NORMAL);
}


/*
 * proc_recv_reply_Smes()
 */
static
int
proc_recv_reply_Smes(ESObj *sobj)
{
  MidObj	*mobj;
  char	*mid;

  mid = eSmesGetSmid( eESObjGetSmes(sobj) );

  if ( (mobj = ePAdmGet(BAGOF_MID_POOL, mid)) != NULL ) {
    /* This message is bag_of reply */
    ePAdmPut(BAGOF_MID_POOL, mobj);
    return ( eBagOfRecvProc(sobj, mobj) );
  }
  else if ( (mobj = ePAdmGet(FAST_MID_POOL, mid)) != NULL ) {
    /* This message is fast reply */
    ePAdmPut(FAST_MID_POOL, mobj);
    return ( eFastRecvProc(sobj, mobj) );
  }
  else if ( (mobj = ePAdmGet(SEQ_MID_POOL, mid)) != NULL ) {
    /* This message is sequential reply */
    ePAdmPut(SEQ_MID_POOL, mobj);
    return ( eSeqRecvProc(sobj, mobj) );
  }
  else {
    /* This message is reply of normal ask */
    return ( eNormalRecvProc(sobj) );
  }
}


/*
 * proc_recv_cntl_Smes()
 */
static
int
proc_recv_cntl_Smes(ESObj *sobj)
{
  SMessage	Smes;
  char		*to_aid;

  Smes = eESObjGetSmes(sobj);
  to_aid = eSmesGetSAF(Smes);

  Smes = eCapOfEnv(to_aid, Smes, 0);
  if ( Smes != NULL ) eSmesDelete(Smes);
  
  return (NORMAL);
}

/*** END OF FILE ***/
