/*
 * file name: eESObj.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eSmes.h"
#include	"eESObj.h"
#include	"eUtil.h"


/*
 * eESObjNew()
 */
void*
eESObjNew(SMessage Smes, int rpc_id, char *from_proc, char *to_proc,
	  char *env, char *info)
{
  ESObj	*p;

  p = (ESObj*)malloc( sizeof(ESObj) );
  if ( p == NULL ) {
    return (NULL);
  }

  p->Smes = Smes;
  p->rpc_id = rpc_id;

  if ( eUtilSetString(&(p->from_proc), from_proc) == EALLOC )
    return (NULL);

  if ( eUtilSetString(&(p->to_proc), to_proc) == EALLOC )
    return (NULL);

  if ( eUtilSetString(&(p->env), env) == EALLOC )
    return (NULL);

  if ( eUtilSetString(&(p->info), info) == EALLOC )
    return (NULL);

  return (p);
}

  
/*
 * eESObjDeleteExceptSmes()
 */
void
eESObjDeleteExceptSmes(ESObj *target)
{
  if ( target->from_proc != NULL ) free( target->from_proc );
  if ( target->to_proc != NULL ) free( target->to_proc );
  if ( target->env != NULL ) free( target->env );
  if ( target->info != NULL ) free( target->info );
  target->Smes = NULL;
  target->rpc_id = 0;
  target->from_proc = NULL;
  target->to_proc = NULL;
  target->env = NULL;
  target->info = NULL;
  free( target );
}

  
/*
 * eESObjGetSmes()
 */
SMessage
eESObjGetSmes(ESObj *target)
{
  return ( target->Smes );
}


/*
 * eESObjGetRpcId()
 */
int
eESObjGetRpcId(ESObj *target)
{
  return ( target->rpc_id );
}


/*
 * eESObjGetFromProc()
 */
char*
eESObjGetFromProc(ESObj *target)
{
  return ( target->from_proc );
}


/*
 * eESObjGetToProc()
 */
char*
eESObjGetToProc(ESObj *target)
{
  return ( target->to_proc );
}


/*
 * eESObjGetEnv()
 */
char*
eESObjGetEnv(ESObj *target)
{
  return ( target->env );
}


/*
 * eESObjGetInfo()
 */
char*
eESObjGetInfo(ESObj *target)
{
  return ( target->info );
}


/*
 * eESObjSetSmes()
 */
void
eESObjSetSmes(ESObj *target, SMessage Smes)
{
  target->Smes = Smes;
}


/*
 * eESObjPrint()
 */
void
eESObjPrint(void *target)
{
  ESObj	*op;

  op = target;
  fprintf(stderr, "\n     ESObj\n");
  if ( op->Smes != NULL )  eSmesPrint(op->Smes);
  fprintf(stderr, "rpc_id = %d\n", op->rpc_id);
  if ( op->from_proc != NULL ) 
    fprintf(stderr, "from_proc = %s\n", op->from_proc);
  if ( op->to_proc != NULL ) 
    fprintf(stderr, "to_proc = %s\n", op->to_proc);
  if ( op->env != NULL ) 
    fprintf(stderr, "env = %s\n", op->env);
}

/*** END OF FILE ***/
