/*
 * file name: eEAObj.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include        <helios/envdef.h>
#include	"eEAObj.h"
#include	"eAmes.h"


/*
 * eEAObjNew()
 */
void*
eEAObjNew(char *Ames, int size, int rpc_id)
{
  EAObj	*op;

  op = (EAObj*)malloc( sizeof(EAObj) );
  if ( op == NULL ) return (NULL);

  op->Ames = Ames;
  op->size = size;
  op->rpc_id = rpc_id;

  return (op);
}


/*
 * eEAObjDeleteExceptAmes()
 */
void
eEAObjDeleteExceptAmes(EAObj *target)
{
  if ( target == NULL ) return;
  target->Ames = NULL;
  target->size = 0;
  target->rpc_id = 0;
  free(target);
}


/*
 * eEAObjGetAmes()
 */
char*
eEAObjGetAmes(EAObj *target)
{
  return (target->Ames);
}


/*
 * eEAObjGetSize()
 */
int
eEAObjGetSize(EAObj *target)
{
  return (target->size);
}


/*
 * eEAObjGetRpcId()
 */
int
eEAObjGetRpcId(EAObj *target)
{
  return (target->rpc_id);
}


/*
 * eEAObjMatch()
 */
int
eEAObjMatch(void *target, void *lookfor)
{
  char	*Ames;

  if ( !strcmp("not_normal", lookfor) ) {
    Ames = eEAObjGetAmes(target);
    return ( !eAmesCheckCntl(Ames, NORMAL_STR) );
  }
  return (ERROR);
}


/*
 * eEAObjPrint()
 */
void
eEAObjPrint(void *target)
{
  EAObj	*op;

  op = target;
  fprintf(stderr, "\n     EAObj\n");
  eAmesPrintHdr(op->Ames);
  fprintf(stderr, "size = %d\n", op->size);
  fprintf(stderr, "rpc_id = %d\n", op->rpc_id);
}

/*** END OF FILE ***/
