/*
 * file name: eDispatch.c
 *
 */

#include	<stdio.h>
#include	<helios/envdef.h>
#include	"eSMessage.h"
#include	"eDispatch.h"
#include	"eAidAdm.h"
#include	"eAidAna.h"
#include	"eESObj.h"
#include	"eSmes.h"
#include	"eSAConv.h"
#include	"eCom.h"
#include	"eAgntDir.h"
#include	"eSendError.h"
#include	"eFast.h"
#include	"eBagOf.h"
#include	"eSeq.h"
#include	"ePrmAidObj.h"
#include	"ePrm.h"



/*
 * eDispatchSendSmes()
 */
int
eDispatchSendSmes(SMessage Smes, char *to_aid, char *Afrom)
{
  char	*Ames, *from_aid, *env;
  char	*template_name, *my_name, *logical_name;
  int	size, rpc_id, len;
  int	status;

  logical_name = NULL;

  if ( ePrmIsParam() == TRUE ) {
    template_name = ePrmGetTempName();
    my_name = eAidAdmGetMyName();
    len = strlen(template_name) + strlen(my_name) + 3;
    logical_name = (char*)malloc( len );
    if ( logical_name == NULL ) return NULL;
    strcpy(logical_name, template_name);
    strcat(logical_name, "(");
    strcat(logical_name, my_name);
    strcat(logical_name, ")");
  }

  if ( Afrom == NULL ) {
    from_aid = eAidAdmGetMyProcAid();
  }
  else {
    from_aid = Afrom;
  }

  if ( eAidAnaIsUser(to_aid) == TRUE ) { /* destination is user */
    env = USER_ENV_LEVEL;
  }
  else {
    env = eAidAdmGetAidOfCurrentEnv();
  }

  status = eSAConvStoA(from_aid, to_aid, "normal", env, logical_name,
		       Smes, &Ames, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(to_aid, &rpc_id, Ames, size);
  status = eSendErrorCheck(status, Ames, to_aid, size);
  return (status);
}


/*
 * eDispatchRecvSmes()
 *   This function processes a message which is sent from 
 *   upper environment through the capsule of complex agent.
 */
int
eDispatchRecvSmes(ESObj *sobj)
{
  SMTo	to_field;
  char	*mid, *from, *method, *new_method = NULL;
  char	*to_aid, *Ames;
  char	*Afrom_aid, *Ato_aid, *current_env;
  SMessage     	Smes, Smes_for_prm;
  int	size, rpc_id, status;

  Smes = eESObjGetSmes(sobj);
  Afrom_aid = eESObjGetFromProc(sobj);

  mid = eSmesGetSmid(Smes);
  to_field = eSmesGetSto(Smes);
  from = eSmesGetSfrom(Smes);
  method = eSmesGetSmethod(Smes);
  current_env = eAidAdmGetAidOfCurrentEnv();

  if ( eSmesIsFast(Smes) ) {
    return ( eFastSendProc(Smes, 1, Afrom_aid, current_env) );
  }
  else if ( eSmesIsBagOf(Smes) || eSmesIsBagOf2(Smes) 
	                       || eSmesIsBagOfNum(Smes) ) {
    return ( eBagOfSendProc(Smes, 1, Afrom_aid, current_env) );
  }
  else if ( eSmesIsSeq(Smes) ) {
    return ( eSeqSendProc(Smes, 1, Afrom_aid, current_env) );
  }

  /* To_field is logical agent name */
  to_aid = eAgntDirSearchAgentId(Smes, current_env, mid, from, to_field,
                                 method, &new_method, &Smes_for_prm);
  if ( to_aid == NULL ) {
    return (ERROR);
  }
  else {
    if ( new_method != NULL ) {
      eSmesSetSmethod(Smes, new_method);
    }
  }

  Afrom_aid = eESObjGetFromProc(sobj);
  Ato_aid = eESObjGetToProc(sobj);

  if ( ePrmAidObjIsPrmAid(Ato_aid) == TRUE ) {
    Ato_aid = to_aid;
  }

#ifdef	ENV_DEBUG
fprintf(stderr, "current_env=%s\n", current_env);
fprintf(stderr, "from_proc = %s\n", Afrom_aid);
fprintf(stderr, "to_proc = %s\n", Ato_aid);
#endif

  status = eSAConvStoA(Afrom_aid, Ato_aid, "normal", current_env, NULL,
                       Smes, &Ames, &size);
  if ( status != NORMAL ) return (status);

  status = eComSendAMessage(to_aid, &rpc_id, Ames, size);
  status = eSendErrorCheck(status, Ames, to_aid, size);
  free(to_aid);
  eSmesDelete(Smes);
  return (status);
}

/*** END OF FILE ***/
