/*
 * file name: eCom.c
 *
 */

#include	<helios/envdef.h>
#include	<stdio.h>
#include	"eCom.h"
#include	"eSMessage.h"
#include	"eSmes.h"
#include	"eAmes.h"

#ifdef	ENV_DEBUG
extern	int	dbg_receive_a_message();
extern	int	dbg_send_a_message();
#endif

/*** dummy ***/
extern	int	receive_a_message(int *rpc_id, void *m, int *len_p);
extern	int	send_a_message(char *ag, void *m, unsigned int len);


/*
 * eComRecvAMessage()
 */
int
eComRecvAMessage(int *rpc_id, char *buf, int *size)
{
#ifndef ENV_DEBUG
  /* communication layer interface */
  return ( receive_a_message(rpc_id, buf, size) );
#endif

#ifdef  ENV_DEBUG
  /* call dummy function */
  return ( dbg_receive_a_message(rpc_id, buf, size) );
#endif

}


/*
 * eComSendAMessage()
 */
int
eComSendAMessage(char *to_aid, int *rpc_id, char *Ames, int size)
{
  int	status;
  SMessage	Smes;
#ifndef	ENV_DEBUG
/*** for dbg ***
fprintf(stderr,"---eComSendAMessage()---\n to_aid = %s\n", to_aid);
eAmesPrintHdr(Ames);
Smes = eSAConvAtoS(Ames);
eSmesPrint(Smes);
fprintf(stderr,"------------------------\n");
**************/

  /* communication layer interface */
  status =  send_a_message(to_aid, Ames, (unsigned int)size);
  if ( status > 0 ) {
    *rpc_id = status;
    return (NORMAL);
  }
  else {
    return (status);
  }
#endif

#ifdef	ENV_DEBUG
  status = dbg_send_a_message(to_aid, Ames, (unsigned int)size);
  if ( status > 0 ) {
    *rpc_id = status;
    return (NORMAL);
  }
  else {
    return (status);
  }
#endif

}

/*** END OF FILE ***/




