/*
 * file name : eCandidateObj.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<helios/envdef.h>
#include	"eSMessage.h"
#include	"eCandidateObj.h"
#include	"ePool.h"
#include	"eQueue.h"

static	ToInfo*		ToInfo_new(char *aid, SMessage Smes);


/*
 * eCandidateObjNew()
 */
CandidateObj*
eCandidateObjNew(char *mid)
{
  CandidateObj	*op;
  int		status;

  op = (CandidateObj*)malloc( sizeof(CandidateObj) );
  if ( op == NULL ) return NULL;

  status = eUtilSetString(&(op->mid), mid);
  if ( status != NORMAL ) return NULL;

  op->candidate_Q = eQueueNew(NULL);
  if ( op->candidate_Q == NULL ) return NULL;

  return op;
}


/*
 * eCandidateObjDelete()
 */
void
eCandidateObjDelete(CandidateObj *target)
{
  char	*aid;

  if ( target == NULL ) return;

  if ( target->mid != NULL ) {
    free(target->mid);
    target->mid = NULL;
  }
  eQueueDelete(target->candidate_Q);
  return;
}


/*
 * eCandidateObjPutAid()
 */
int
eCandidateObjPutAid(CandidateObj *target, char *aid, SMessage Smes)
{
  ToInfo	*op;

  op = ToInfo_new(aid, Smes);
  if ( op == NULL ) return EALLOC;
  return eQueuePut(target->candidate_Q, op);
}


/*
 * eCandidateObjGetAid()
 */
char*
eCandidateObjGetAid(CandidateObj *target, SMessage *Smes)
{
  ToInfo	*op;

  op = eQueueGet(target->candidate_Q);
  if ( op == NULL ) return NULL;

  *Smes = op->Smes;
  return op->aid;
}


/*
 * eCandidateObjMatch()
 */
int
eCandidateObjMatch(void *target, void *lookfor)
{
  CandidateObj	*op;
  char		*p;

  op = target;
  p = lookfor;

  if ( !strcmp(op->mid, lookfor) ) return TRUE;
  return FALSE;
}


/*
 * eCandidateObjPrint()
 */
void
eCandidateObjPrint(void *target)
{
  return;
}



/*
 * ToInfo_new()
 */
static
ToInfo*
ToInfo_new(char *aid, SMessage Smes)
{
  ToInfo	*op;

  op = (ToInfo*)malloc( sizeof(ToInfo) );
  if ( op == NULL ) return NULL;

  op->aid = aid;
  op->Smes = Smes;
  return op;
}

/*** END OF FILE ***/


