/*
 * file name: eBagOf.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<helios/envdef.h>
#include	"eBagOf.h"
#include	"eEnv.h"
#include	"eSMessage.h"
#include	"eESObj.h"
#include	"eMidObj.h"
#include	"eSmes.h"
#include	"eAidAdm.h"
#include	"eAgntDir.h"
#include	"eDispatch.h"
#include	"eTrace.h"
#include	"eQAdm.h"
#include	"ePAdm.h"
#include	"eAmes.h"
#include	"eTimeOut.h"
#include	"eInterEnv.h"
#include	"ePrm.h"
#include	"ePrmAidObj.h"
#include	"eUpper.h"



/*** static function ***/
static	int	compose_bag_of_result(MidObj *mobj,
                                      char **all_result);
static	int	compose_bag_of2_result(MidObj *mobj,
                                      char **all_result);
static	int	compose_bag_ofNum_result(MidObj *mobj,
                                      char **all_result);
static	int	is_bag_of(MidObj *mobj);
static	int	is_bag_of2(MidObj *mobj);
static	int	is_bag_ofNum(MidObj *mobj);
static	int	bag_of_recv_proc(ESObj *sobj, MidObj *mobj);
static	int	bag_of2_recv_proc(ESObj *sobj, MidObj *mobj);
static	int	bag_ofNum_recv_proc(ESObj *sobj, MidObj *mobj);
static	int	get_num_of_bag_ofNum(char *management);


/*
 * eBagOfTimeOutComposeResult()
 */
int
eBagOfTimeOutComposeResult(MidObj *mobj, SMessage *rSmes)
{
  ESObj	*sobj;
  SMessage	Smes;
  char	*result;
  char	*debug, *mid, *from, *to, *method;
  int	status;

  if ( is_bag_of(mobj) ) {
    status = compose_bag_of_result(mobj, &result);
    if ( status != NORMAL ) return (status);
  }
  else if ( is_bag_ofNum(mobj) ) {
    if ( eMidObjGetNormalReplyNum(mobj) != -1 ) { /* not end */
      /* can not use compose_bag_ofNum_result() in this context */
      status = compose_bag_of_result(mobj, &result);
      if ( status != NORMAL ) return (status);
      eMidObjSetNormalReplyNum(mobj, -1);  /*** 11/8 ***/
    }
    else { /* had already done */
      *rSmes = NULL;
      return (NORMAL);
    }
  }
  else if ( is_bag_of2(mobj) ) {
    status = compose_bag_of2_result(mobj, &result);
    if ( status != NORMAL ) return (status);
  }

  mid = eMidObjGetMid(mobj);
  from = eMidObjGetFunc(mobj);

  sobj = eMidObjESObjQGet(mobj);
  if ( sobj == NULL ) {
    debug = NULL;
    to = NULL;
    method = NULL;
  }
  else {
    Smes = eESObjGetSmes(sobj);
    debug = eSmesGetSdebug(Smes);
    to = eSmesGetSAF(Smes);
    method = eSmesGetSmethod(Smes);
    eMidObjESObjQPut(mobj, sobj);
  }

  *rSmes = eSmesNew(REPLY, debug, mid, from, ON, to, "bag_of",
		    "time_out", method, result);
  if ( *rSmes == NULL ) {
    return (EALLOC);
  }
  free(result);
  return (NORMAL);
}


/*
 * eBagOfSendProc()
 *    mode == 0 : message from substance
 *    mode == 1 : message from upper environment
 */
int
eBagOfSendProc(SMessage Smes, int mode, char *Afrom, char *env)
{
  SMessage	rSmes, Smes_for_prm = NULL;
  SMTo		to_field;
  MidObj	*mobj;
  char	*func, *management, *from_aid;
  char	*to_aid, *current_env, *mid, *from, *method, *new_method = NULL;
  int	data, bag_of_time, status;

  if ( mode == 0 ) {
    eAidAdmMoveToBottomEnv();
  }
  else if ( mode == 1 ) {
    eAidAdmSetAidOfCurrentEnv(env);
  }

  if ( ePrmIsParam() == TRUE && mode == 0 ) {
    eAidAdmMoveToAidOfUpperEnv();
  }

  current_env = eAidAdmGetAidOfCurrentEnv();
  mid = eSmesGetSmid(Smes);
  to_field = eSmesGetSto(Smes);
  method = eSmesGetSmethod(Smes);
  func = eSmesGetSAF(Smes);
  management = eSmesGetSmanag(Smes);
  from = eSmesGetSfrom(Smes);

  if ( mode == 0 ) {
    from_aid = eAidAdmGetMyProcAid();
  }
  else if ( mode == 1 ) {
    from_aid = NULL;
  }

  to_aid = eAgntDirSearchAgentId(Smes, current_env, mid, from, to_field,
                                 method, &new_method, &Smes_for_prm);

  /* not send myself */
  if ( from_aid != NULL && to_aid != NULL && !strcmp(to_aid, from_aid) ) {
    free(to_aid);
    if ( new_method != NULL ) free(new_method);
    new_method = NULL;
    to_aid = eAgntDirSearchAgentId(Smes, current_env, mid, from, to_field,
				   method, &new_method, &Smes_for_prm);
  }

  if ( to_aid == NULL && mode == 0 ) {
    rSmes = eSmesNew(REPLY, NULL, mid, func, ON, 
                       NULL, NULL, "no_substance", method, NULL);
    if ( rSmes == NULL ) return (EALLOC);
    eQAdmPut(RTN_SMES_Q, rSmes);
    if ( new_method != NULL ) free(new_method);
    eSmesDelete(Smes);
    return (NORMAL);
  }
  else if ( to_aid == NULL && mode == 1 ) {
    /* bad description of CAPL!! */
    /* not implemented yet!! */
  }
  else if ( ePrmAidObjIsPrmAid(to_aid) == TRUE &&
	    Smes_for_prm == NULL ) {
    if ( mode == 0 ) {
      from_aid = NULL;
    }
    else if ( mode == 1 ) {
      from_aid = Afrom;
    }
    status = eInterEnvSendToPrm(BAGOF_MID_POOL, to_aid, current_env,
                                from_aid, Smes);
    free(to_aid);
    return (status);
  }
  else {
    if ( Smes_for_prm == NULL ) {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes, new_method);
      }
      status = eDispatchSendSmes(Smes, to_aid, NULL);
    }
    else {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes_for_prm, new_method);
      }
      status = eDispatchSendSmes(Smes_for_prm, to_aid, NULL);
      eSmesDelete(Smes_for_prm);
    }

    if ( status != NORMAL ) return (status);
    free(to_aid);

    if ( from_aid == NULL ) {
      from_aid = Afrom;
    }
    mobj = eMidObjNew(mid, from_aid, current_env, func, management);
    if ( mobj == NULL ) return (EALLOC);
    eMidObjSetFromUpperFlag(mobj, mode);
    eMidObjIncrTotalSendNum(mobj);
    ePAdmPut(BAGOF_MID_POOL, mobj);
    if ( new_method != NULL && Smes_for_prm == NULL ) {
      free( eSmesGetSmethod(Smes) );
      eSmesSetSmethod(Smes, method);
      free(method);
      method = eSmesGetSmethod(Smes);
      free(new_method);
      new_method = NULL;
    }
    eMidObjSetSmes(mobj, Smes);
  }

  if ( mode == 0 ) {
    from_aid = eAidAdmGetMyProcAid();
  }
  else if ( mode == 1 ) {
    from_aid = NULL;
  }

  while ( 1 ) {
    Smes_for_prm = NULL;
    to_aid = eAgntDirSearchAgentId(Smes, current_env, mid, from, to_field,
                                   method, &new_method, &Smes_for_prm);
    if ( to_aid == NULL ) break;

    /* not send myself */
    if ( from_aid != NULL && !strcmp(to_aid, from_aid) ) {
      free(to_aid);
      if ( new_method != NULL ) free(new_method);
      new_method = NULL;
      continue;
    }

    if ( ePrmAidObjIsPrmAid(to_aid) == TRUE &&
	 Smes_for_prm == NULL ) {
      status = eInterEnvSendToPrm2(mobj, to_aid, current_env, Smes);
      free(to_aid);
      return (status);
    }

    if ( Smes_for_prm == NULL ) {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes, new_method);
      }
      status = eDispatchSendSmes(Smes, to_aid, NULL);
    }
    else {
      if ( new_method != NULL ) {
	eSmesSetSmethod(Smes_for_prm, new_method);
      }
      status = eDispatchSendSmes(Smes_for_prm, to_aid, NULL);
      eSmesDelete(Smes_for_prm);
    }


    if ( status != NORMAL ) return (status);
    free(to_aid);

    eMidObjIncrTotalSendNum(mobj);
    if ( new_method != NULL && Smes_for_prm == NULL ) {
      free( eSmesGetSmethod(Smes) );
      eSmesSetSmethod(Smes, method);
      free(method);
      method = eSmesGetSmethod(Smes);
      free(new_method);
      new_method = NULL;
    }
  }

  if ( eTimeOutUse() ) {
    data = eTimeOutGenDataNum();
    bag_of_time = eTimeOutGetTime();
    eTimeOutRegister(bag_of_time, 0, data, eSmesGetSmid(Smes));
  }

  return (NORMAL);
}


/*
 * eBagOfSendProcToPrm()
 */
int
eBagOfSendProcToPrm(MidObj *mobj, char *Ames)
{
  PrmAidObj	*prm_op;
  SMessage	orgSmes, Smes, Smes_for_prm;
  SMTo	to_field;
  char	*AF, *management;
  char	*mid, *env, *method, *new_method = NULL, *from;
  char	*all_name_aid, *to_aid, *inst_name, *inst_aid;
  char	*my_aid;
  char	*wait_prm_aid, *template_name;
  int	i=0, status;
  int	data, bag_of_time, mode;

  mode = eMidObjGetFromUpperFlag(mobj);

  wait_prm_aid = eMidObjGetWaitPrmAid(mobj);
  prm_op = ePAdmGet(PRMAID_OBJ_POOL, wait_prm_aid);
  if ( prm_op == NULL ) return ERROR;
  ePAdmPut(PRMAID_OBJ_POOL, prm_op);

  template_name = ePrmAidObjGetTempName(prm_op);

  if ( mode == 0 ) {
    my_aid = eAidAdmGetMyProcAid();
  }
  else if ( mode == 1 ) {
    my_aid = "-----";
  }

  all_name_aid = eAmesGetAInfo(Ames);
  orgSmes = eMidObjGetSmes(mobj);
  Smes = eSmesDuplicate(orgSmes);

  inst_name = strtok(all_name_aid, " ");
  while ( inst_name ) {
    i++;
    AF = eSmesGetSAF(Smes);
    management = eSmesGetSmanag(Smes);
    free(AF);
    free(management);
    status = eSmesSetSAF(Smes, inst_name);
    if ( status != NORMAL ) return (status);
    status = eSmesSetSmanag(Smes, NULL);
    if ( status != NORMAL ) return (status);

    inst_aid = strtok(NULL, " ");
    to_aid = inst_aid;

    if ( strcmp(my_aid, inst_aid) ) {
      if ( i != 1 ) {
	eMidObjIncrTotalSendNum(mobj);
      }
      
      if ( is_bag_of2(mobj) == TRUE ) {
	status = eMidObjPutInstance(mobj, inst_name, inst_aid,
				    template_name);
	if ( status != NORMAL ) return (status);
      }

      status = eDispatchSendSmes(Smes, to_aid, NULL);
      if ( status != NORMAL ) return (status);
    }

    inst_name = strtok(NULL, " ");
  }
  eSmesDelete(Smes);

  mid = eMidObjGetMid(mobj);
  env = eMidObjGetEnv(mobj);
  method = eSmesGetSmethod(orgSmes);
  from = eAidAdmGetMyProcAid();
  to_field = eSmesGetSto(orgSmes);

  while ( 1 ) {
    to_aid = eAgntDirSearchAgentId(orgSmes, env, mid, 
				   from, to_field, method, 
				   &new_method, &Smes_for_prm);
    if ( to_aid == NULL ) {
      if ( new_method != NULL )  free(new_method);
      break;
    }
    
    if ( mode == 0 && !strcmp(to_aid, from) ) {
      /* not send myself */
      free(to_aid);
      if ( new_method != NULL ) free(new_method);
      new_method = NULL;
      continue;
    }

    if ( ePrmAidObjIsPrmAid(to_aid) == TRUE ) {
      status = eInterEnvSendToPrm2(mobj, to_aid, env, orgSmes);
      free(to_aid);
      return (status);
    }
    
    if ( new_method != NULL ) {
      eSmesSetSmethod(orgSmes, new_method);
    }

    status = eDispatchSendSmes(orgSmes, to_aid, NULL);
    if ( status != NORMAL ) return (status);
    
    eMidObjIncrTotalSendNum(mobj);
    if ( new_method != NULL ) {
      free( eSmesGetSmethod(orgSmes) );
      eSmesSetSmethod(orgSmes, method);
      free(method);
      method = eSmesGetSmethod(orgSmes);
      free(new_method);
      new_method = NULL;
    }
    free(to_aid);
  }
  free(Ames);

  if ( eTimeOutUse() ) {
    data = eTimeOutGenDataNum();
    bag_of_time = eTimeOutGetTime();
    eTimeOutRegister(bag_of_time, 0, data, eSmesGetSmid(orgSmes));
  }

  return (NORMAL);
}


/*
 * eBagOfRecvProc()
 */
int
eBagOfRecvProc(ESObj *sobj, MidObj *mobj)
{
  SMessage	Smes;
  char	*env;
  int	mode;

  mode = eMidObjGetFromUpperFlag(mobj);

  if ( mode == 0 ) {
    /* move to bottom env and convert S_message */
    eEnvMoveToBottomEnv(sobj);
  }
  else if ( mode == 1 ) {
    env = eESObjGetEnv(sobj);
    Smes = eESObjGetSmes(sobj);
    eTraceMessage(env, Smes);
  }

  eMidObjIncrRecvNum(mobj);

  if ( is_bag_of(mobj) ) {
    return ( bag_of_recv_proc(sobj, mobj) );
  }
  else if ( is_bag_of2(mobj) ) {
    return ( bag_of2_recv_proc(sobj, mobj) );
  }
  else if ( is_bag_ofNum(mobj) ) {
    return ( bag_ofNum_recv_proc(sobj, mobj) );
  }
  else {
    /* management error */
    return (ERROR);
  }
}


/*
 * bag_of_recv_proc()
 */
static
int
bag_of_recv_proc(ESObj *sobj, MidObj *mobj)
{
  SMessage	newSmes, Smes;
  char	*bag_of_result;
  char	*debug, *mid, *from, *to,*method, *ts;
  int	total_num, recv_num, mode;
  int	status;

  Smes = eESObjGetSmes(sobj);

  total_num = eMidObjGetTotalSendNum(mobj);
  recv_num = eMidObjGetRecvNum(mobj);

  ts = eSmesGetSts(Smes);
  if ( ts == NULL ) ts = "";

  if ( strcmp(NORMAL_STR, ts) ) {
    /* status is not normal */
    if ( total_num != recv_num ) {  /* 10/25 */
      eSmesDelete(Smes);
    }
    eESObjDeleteExceptSmes(sobj);
  }
  else {
    /* status is normal */
    eMidObjESObjQPut(mobj, sobj);
    eMidObjIncrNormalReplyNum(mobj);
  }

  if ( total_num == recv_num ) {
    if ( eMidObjGetTimeOutFlag(mobj) == 0 ) { /* not time_out yet */
      status = compose_bag_of_result(mobj, &bag_of_result);
      if ( status != NORMAL ) return (status);

      debug = eSmesGetSdebug(Smes);
      mid = eMidObjGetMid(mobj);
      from = eMidObjGetFunc(mobj);
      to = eSmesGetSAF(Smes);
      method = eSmesGetSmethod(Smes);

      newSmes = eSmesNew(REPLY, debug, mid, from, ON, to, BAGOF_STR,
			 NORMAL_STR, method, bag_of_result);
      if ( newSmes == NULL ) {
	return (EALLOC);
      }

      mode = eMidObjGetFromUpperFlag(mobj);
      if ( mode == 0 ) {
	eQAdmPut(RTN_SMES_Q, newSmes);
      }
      else if ( mode == 1 ) {
	eUpperSendReply(newSmes, mobj);
      }

      free(bag_of_result);
    }
    if ( strcmp(NORMAL_STR, ts) ) {
      eSmesDelete(Smes);
    }
    ePAdmGet(BAGOF_MID_POOL, mid); /* Don't delete */
    eMidObjDelete(mobj);
  }
  return (NORMAL);
}


/*
 * bag_of2_recv_proc()
 */
static
int
bag_of2_recv_proc(ESObj *sobj, MidObj *mobj)
{
  SMessage	newSmes, Smes;
  char	*bag_of2_result;
  char	*debug, *mid, *from, *to,*method;
  int	total_num, recv_num, mode;
  int	status;

  Smes = eESObjGetSmes(sobj);

  total_num = eMidObjGetTotalSendNum(mobj);
  recv_num = eMidObjGetRecvNum(mobj);

  eMidObjESObjQPut(mobj, sobj);

  if ( total_num == recv_num ) {
    if ( eMidObjGetTimeOutFlag(mobj) == 0 ) { /* not time_out yet */
      status = compose_bag_of2_result(mobj, &bag_of2_result);
      if ( status != NORMAL ) return (status);

      debug = eSmesGetSdebug(Smes);
      mid = eMidObjGetMid(mobj);
      from = eMidObjGetFunc(mobj);
      to = eSmesGetSAF(Smes);
      method = eSmesGetSmethod(Smes);

      newSmes = eSmesNew(REPLY, debug, mid, from, ON, to, BAGOF2_STR,
			 NORMAL_STR, method, bag_of2_result);
      if ( newSmes == NULL ) {
	return (EALLOC);
      }

      mode = eMidObjGetFromUpperFlag(mobj);
      if ( mode == 0 ) {
	eQAdmPut(RTN_SMES_Q, newSmes);
      }
      else if ( mode == 1 ) {
	eUpperSendReply(newSmes, mobj);
      }

      free(bag_of2_result);
    }
    ePAdmGet(BAGOF_MID_POOL, mid);
    eMidObjDelete(mobj);
  }
  return (NORMAL);
}


/*
 * bag_ofNum_recv_proc()
 */
static
int
bag_ofNum_recv_proc(ESObj *sobj, MidObj *mobj)
{
  SMessage	newSmes, Smes;
  char	*bag_ofNum_result;
  char	*debug, *mid, *from, *to,*method, *ts;
  char	*management;
  int	num, total_num, recv_num, normal_reply_num, mode;
  int	status;

  Smes = eESObjGetSmes(sobj);

  ts = eSmesGetSts(Smes);
  if ( ts == NULL ) ts = "";

  if ( strcmp(NORMAL_STR, ts) ) {
    /* status is not normal */
    eESObjDeleteExceptSmes(sobj);
  }
  else {
    /* status is normal */
    eMidObjESObjQPut(mobj, sobj);
    if ( eMidObjGetNormalReplyNum(mobj) != -1 ) { /* not end */
      eMidObjIncrNormalReplyNum(mobj);
    }
  }

  normal_reply_num = eMidObjGetNormalReplyNum(mobj);

  total_num = eMidObjGetTotalSendNum(mobj);
  recv_num = eMidObjGetRecvNum(mobj);
  num = get_num_of_bag_ofNum( eMidObjGetManagement(mobj) );

  /* number of waiting message > number of sent message */
  if ( num > total_num ) num = total_num;

  if ( strcmp(NORMAL_STR, ts) && recv_num < num ) {
    eSmesDelete(Smes);
  }
  
  if ( (num == normal_reply_num &&
       eMidObjGetTimeOutFlag(mobj) == 0) || 
       (total_num == recv_num && eMidObjGetNormalReplyNum(mobj) != -1)) { 
    /* not time_out yet  or  normal_reply was nothing */

    status = compose_bag_ofNum_result(mobj, &bag_ofNum_result);
    if ( status != NORMAL ) return (status);

    debug = eSmesGetSdebug(Smes);
    mid = eMidObjGetMid(mobj);
    from = eMidObjGetFunc(mobj);
    to = eSmesGetSAF(Smes);
    management = eMidObjGetManagement(mobj);
    method = eSmesGetSmethod(Smes);

    newSmes = eSmesNew(REPLY, debug, mid, from, ON, to, management,
		       NORMAL_STR, method, bag_ofNum_result);
    if ( newSmes == NULL ) {
      return (EALLOC);
    }

    mode = eMidObjGetFromUpperFlag(mobj);
    if ( mode == 0 ) {
      eQAdmPut(RTN_SMES_Q, newSmes);
    }
    else if ( mode == 1 ) {
      eUpperSendReply(newSmes, mobj);
    }

    free(bag_ofNum_result);

    if ( strcmp(NORMAL_STR, ts) ) {
      eSmesDelete(Smes);
    }

    /* set end flag */
    eMidObjSetNormalReplyNum(mobj, -1);
  }

  if ( total_num == recv_num ) {
    mid = eMidObjGetMid(mobj);
    ePAdmGet(BAGOF_MID_POOL, mid);
    eMidObjDelete(mobj);
  }
  return (NORMAL);
}


/*
 * compose_bag_of_result()
 */
static
int
compose_bag_of_result(MidObj *mobj, char **all_result)
{
  ESObj	*sobj;
  char	*data;
  int	normal_reply_num;
  int	i, total_len = 0;

  normal_reply_num = eMidObjGetNormalReplyNum(mobj);

  for ( i = 0; i < normal_reply_num; i++ ) {
    sobj = eMidObjESObjQGet(mobj);

    data = eSmesGetSdata(eESObjGetSmes(sobj));
    if ( data == NULL ) data = "";

    total_len += strlen(data);
    total_len += 1;
    total_len -= 2;    /* remove paren */
    eMidObjESObjQPut(mobj, sobj);
  }

  total_len += 5;
  
  *all_result = (char*)malloc( total_len );
  if ( *all_result == NULL ) return (EALLOC);

  strcpy(*all_result, "([");
  for ( i = 0; i < normal_reply_num; i++ ) {
    sobj = eMidObjESObjQGet(mobj);

    data = eSmesGetSdata(eESObjGetSmes(sobj));
    if ( data == NULL ) data = "";

    strcat(*all_result, data+1);
    (*all_result)[strlen(*all_result)-1] = 0;
    if ( i != normal_reply_num - 1 ) {
      strcat(*all_result, ",");
    }
    eMidObjESObjQPut(mobj, sobj);
  }
  strcat(*all_result, "])");
  return (NORMAL);
}


/*
 * compose_bag_of2_result()
 */
static
int
compose_bag_of2_result(MidObj *mobj, char **all_result)
{
  ESObj	*sobj;
  char	*my_aid, *from_aid;
  char	*logical_name, *ts, *data, *template_name;
  int	recv_num;
  int	template_len, name_len, stat_len, result_len, total_len = 0;
  int	i, status;

  my_aid = eAidAdmGetMyProcAid(); 

  recv_num = eMidObjGetRecvNum(mobj);

  for ( i = 0; i < recv_num; i++ ) {
    template_name = NULL;
    sobj = eMidObjESObjQGet(mobj);

    ts = eSmesGetSts(eESObjGetSmes(sobj));
    if ( ts == NULL ) ts = "";
    data = eSmesGetSdata(eESObjGetSmes(sobj));
    if ( data == NULL ) data = "";

    from_aid = eESObjGetFromProc(sobj);

    logical_name = eAgntDirSearchLogicalName(eMidObjGetEnv(mobj),
					     from_aid);
    if ( logical_name == NULL ) {
      logical_name = eMidObjGetInstanceName(mobj, from_aid,
					    &template_name);
      if ( logical_name != NULL ) {
	status = eMidObjPutInstance(mobj, logical_name, from_aid,
				    template_name);
	if ( status != NORMAL ) return (status);
      }
      else {
	logical_name = eESObjGetInfo(sobj);
      }
    }

    if ( logical_name == NULL ) {
      logical_name = "unknown";
    }

    if ( template_name != NULL ) {
      template_len = strlen(template_name) + 2;
    }
    else {
      template_len = 0;
    }

    name_len = strlen(logical_name);
    stat_len = strlen(ts);
    result_len = strlen(data);
    total_len = total_len + template_len + name_len + stat_len + (result_len-2) + 4;
    eMidObjESObjQPut(mobj, sobj);
  }
  total_len = total_len + (recv_num - 1) + 5;
  *all_result = (char*)malloc( total_len );
  if ( *all_result == NULL ) return (EALLOC);

  strcpy(*all_result, "([");
  for ( i = 0; i < recv_num; i++ ) {
    template_name = NULL;
    strcat(*all_result, "[");
    sobj = eMidObjESObjQGet(mobj); 
    from_aid = eESObjGetFromProc(sobj); 

    logical_name = eAgntDirSearchLogicalName(eMidObjGetEnv(mobj),
					     from_aid);
    if ( logical_name == NULL ) {
      logical_name = eMidObjGetInstanceName(mobj, from_aid,
					    &template_name);
      if ( logical_name != NULL ) {
	status = eMidObjPutInstance(mobj, logical_name, from_aid,
				    template_name);
	if ( status != NORMAL ) return (status);
      }
      else {
	logical_name = eESObjGetInfo(sobj);
      }
    }

    if ( logical_name == NULL ) {
      logical_name = "unknown";
    }

    ts = eSmesGetSts(eESObjGetSmes(sobj));
    if ( ts == NULL ) ts = "";
    data = eSmesGetSdata(eESObjGetSmes(sobj));
    if ( data == NULL ) data = "";

    if ( template_name != NULL ) {
      strcat(*all_result, template_name);
      strcat(*all_result, "(");
      strcat(*all_result, logical_name);
      strcat(*all_result, ")");
    }
    else {
      strcat(*all_result, logical_name); 
    }
    strcat(*all_result, ","); 
    strcat(*all_result, ts); 
    strcat(*all_result, ","); 
    strcat(*all_result, data+1);
    (*all_result)[strlen(*all_result)-1] = NULL;

    if ( i != recv_num - 1 ) {
      strcat(*all_result, "],");
    }
    else strcat(*all_result, "]");
  }
  strcat(*all_result, "])");
  return (NORMAL);
}


/*
 * compose_bag_ofNum_result()
 */
static
int
compose_bag_ofNum_result(MidObj *mobj, char **all_result)
{
  ESObj	*sobj;
  char	*data;
  int	num, total_num;
  int	i, total_len = 0;
  int   normal_reply_num; /* 10/26 */

/* 10/26 */
  normal_reply_num = eMidObjGetNormalReplyNum(mobj);

  total_num = eMidObjGetTotalSendNum(mobj);
  num = get_num_of_bag_ofNum( eMidObjGetManagement(mobj) );

  /* number of waiting message > number of sent message */
  if ( num > total_num ) num = total_num;

/* 10/26 */
  if ( normal_reply_num < num ) num = normal_reply_num;

  for ( i = 0; i < num; i++ ) {
    sobj = eMidObjESObjQGet(mobj);
    
    data =eSmesGetSdata(eESObjGetSmes(sobj));
    if ( data == NULL ) data = "";

    total_len += strlen(data);
    total_len += 1;
    total_len -= 2; 
    eMidObjESObjQPut(mobj, sobj);
  }

  total_len += 5;
  
  *all_result = (char*)malloc( total_len );
  if ( *all_result == NULL ) return (EALLOC);

  strcpy(*all_result, "([");
  for ( i = 0; i < num; i++ ) {
    sobj = eMidObjESObjQGet(mobj);

    data =eSmesGetSdata(eESObjGetSmes(sobj));
    if ( data == NULL ) data = "";

    strcat(*all_result, data+1);
    (*all_result)[strlen(*all_result)-1] = NULL;
    if ( i != num - 1 ) {
      strcat(*all_result, ",");
    }
  }
  strcat(*all_result, "])");

  return (NORMAL);
}


/*
 * is_bag_of()
 */
static
int
is_bag_of(MidObj *mobj)
{
  char	*management;

  management = eMidObjGetManagement(mobj);
  if ( management == NULL ) return (FALSE);
  if ( strcmp(management, BAGOF_STR) ) return (FALSE);
  return (TRUE);
}


/*
 * is_bag_of2()
 */
static
int
is_bag_of2(MidObj *mobj)
{
  char	*management;

  management = eMidObjGetManagement(mobj);
  if ( management == NULL ) return (FALSE);
  if ( strcmp(management, BAGOF2_STR) ) return (FALSE);
  return (TRUE);
}


/*
 * is_bag_ofNum()
 */
static
int
is_bag_ofNum(MidObj *mobj)
{
  char	*management;

  management = eMidObjGetManagement(mobj);
  if ( management == NULL ) return (FALSE);
  if ( strncmp(management, BAGOFNUM_STR, strlen(BAGOFNUM_STR)) )
      return (FALSE);
  return (TRUE);
}


/*
 * get_num_of_bag_ofNum()
 */
static
int
get_num_of_bag_ofNum(char *management)
{
  char	*p, num_str[256];
  int	i, num;

  if ( management == NULL ) return (0);

  for ( p = management; !isdigit(*p); p++) {}

  for ( i = 0; isdigit(*p); i++, p++ ) {
    num_str[i] = *p;
  }
  num_str[i+1] = NULL;

  num = atoi(num_str);
  return (num);
}

/*** END OF FILE ***/
