/*
 * file name: eAmes.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<sys/types.h>
#include	<netinet/in.h>

#include	<helios/envdef.h>
#include	"eAmes.h"
#include	"eSmes.h"


static	char	A_MESSAGE[] = "A_msg";


/*** static function ***/
static	int	get_Smes_len(SMessage SMes);
static	void	set_Smes_to_array(char *Sp, SMessage Smes);
static	void	set_integer_to_array(char *Sp, int index, long ofset,
                                     int integer);
static	void	set_string_to_array(char *Sp, int index, long ofset,
                                    char *str, int len);
static	char*	get_string_from_array(char *Ames, int index);
static  int	get_Smes_int_from_array(char *Ames, int index);
static  char*	get_Smes_content_from_array(char *Ames, int index);
static	long	my_strlen(char *str);


/*** function definition ***/

/*
 * eAmesNew()
 */
int
eAmesNew(char *from, char *to, char *cntl, char *env, char *info,
            SMessage Smes, char **Amesp, int *size)
{
  char	*Ap;
  int 	from_len, to_len, cntl_len, env_len, info_len, Smes_len;
  int	total_len;
  long	ofset, length, net_ofset;

  from_len = my_strlen(from);
  to_len = my_strlen(to);
  cntl_len = my_strlen(cntl);
  env_len = my_strlen(env);
  info_len = my_strlen(info);

  Smes_len = get_Smes_len(Smes);

  total_len = Smes_len + 32 + from_len + to_len + cntl_len + env_len 
    + info_len + 3 /* for memory */ ;

  Ap = (char*)malloc(total_len);
  if ( Ap == NULL ) {
    return (EALLOC);
  }
  
  /* set A_message */

  /* "A_message" */
  length = strlen(A_MESSAGE) + 1;
  bcopy(A_MESSAGE, Ap, length);

  /* from */
  ofset = SMES_INDEX + 4;
  set_string_to_array(Ap, FROM_INDEX, ofset, from, from_len);

  /* to */
  ofset += from_len;
  set_string_to_array(Ap, TO_INDEX, ofset, to, to_len);
  
  /* cntl */
  ofset += to_len;
  set_string_to_array(Ap, CNTL_INDEX, ofset, cntl, cntl_len);

  /* env */
  ofset += cntl_len;
  set_string_to_array(Ap, ENV_INDEX, ofset, env, env_len);

  /* info */
  ofset += env_len;
  set_string_to_array(Ap, INFO_INDEX, ofset, info, info_len);

  /* Smes */
  if ( Smes == NULL ) {
    net_ofset = htonl(0L);
    bcopy((char*)(&net_ofset), (char*)(&(Ap[SMES_INDEX])), 4);
  }
  else {
    ofset += info_len;
    if ( ofset % 4 != 0 ) ofset = ofset + (4 - ofset % 4);
    net_ofset = htonl(ofset);
    bcopy((char*)(&net_ofset), (char*)(&(Ap[SMES_INDEX])), 4);
  }

  set_Smes_to_array(&(Ap[ofset]), Smes);

  *Amesp = Ap;
  *size = total_len;
  return (NORMAL);
}


/*
 * eAmesDelete()
 */
void
eAmesDelete(char *Ames)
{
  if ( Ames == NULL ) return;
  free(Ames);
  return;
}


/*
 * eAmesGetAFrom()
 */
char*
eAmesGetAFrom(char *Ames)
{
  return ( get_string_from_array(Ames, FROM_INDEX) );
}


/*
 * eAmesGetATo()
 */
char*
eAmesGetATo(char *Ames)
{
  return ( get_string_from_array(Ames, TO_INDEX) );
}


/*
 * eAmesGetACntl()
 */
char*
eAmesGetACntl(char *Ames)
{
  return ( get_string_from_array(Ames, CNTL_INDEX) );
}


/*
 * eAmesGetAEnv()
 */
char*
eAmesGetAEnv(char *Ames)
{
  return ( get_string_from_array(Ames, ENV_INDEX) );
}


/*
 * eAmesGetAInfo()
 */
char*
eAmesGetAInfo(char *Ames)
{
  return ( get_string_from_array(Ames, INFO_INDEX) );
}


/*
 * eAmesGetSmesOfset()
 */
long
eAmesGetSmesOfset(char *Ames)
{
  long	ofset, net_ofset;

  net_ofset = *(long*)(&(Ames[SMES_INDEX]));
  ofset = ntohl(net_ofset);
  return (ofset);
}


/*
 * eAmesCheckCntl()
 */
int
eAmesCheckCntl(char *Ames, char *mask)
{
  if ( strcmp(mask, eAmesGetACntl(Ames)) == 0 ) return (TRUE);
  return (FALSE);
}


/*
 * eAmesGetStype()
 */
int
eAmesGetStype(char *Ames)
{
  return ( get_Smes_int_from_array(Ames, 0) );
}


/*
 * eAmesGetSmflag()
 */
int
eAmesGetSmflag(char *Ames)
{
  return ( get_Smes_int_from_array(Ames, SMFLAG_INDEX) );
}


/*
 * eAmesGetSdebug()
 */
char*
eAmesGetSdebug(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, SDEBUG_INDEX) );
}


/*
 * eAmesGetSmid()
 */
char*
eAmesGetSmid(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, SMID_INDEX) );
}
 

/*
 * eAmesGetSfrom()
 */
char*
eAmesGetSfrom(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, SFROM_INDEX) );
}


/*
 * eAmesGetSAF()
 */
char*
eAmesGetSAF(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, SAF_INDEX) );
}


/*
 * eAmesGetSmanag()
 */
char*
eAmesGetSmanag(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, SMANAG_INDEX) );
}


/*
 * eAmesGetSts()
 */
char*
eAmesGetSts(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, STS_INDEX) );
}


/*
 * eAmesGetSmethod()
 */
char*
eAmesGetSmethod(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, SMETHOD_INDEX) );
}


/*
 * eAmesGetSdata()
 */
char*
eAmesGetSdata(char *Ames)
{
  return ( get_Smes_content_from_array(Ames, SDATA_INDEX) );
}


/*
 * eAmesPrintHdr()
 */
void
eAmesPrintHdr(char *Ames)
{
  fprintf(stderr, "A_message_Header = %s\n", Ames);
  fprintf(stderr, "A_message_from   = %s\n", eAmesGetAFrom(Ames)); 
  fprintf(stderr, "A_message_to     = %s\n", eAmesGetATo(Ames));
  fprintf(stderr, "A_message_cntl   = %s\n", eAmesGetACntl(Ames));
  fprintf(stderr, "A_message_env    = %s\n", eAmesGetAEnv(Ames));
  fprintf(stderr, "A_message_info   = %s\n", eAmesGetAInfo(Ames));

}


/*** static function ***/

/*
 * Smes_len()
 */
static
int
get_Smes_len(SMessage Smes)
{
  int	dbg_len, mid_len, from_len, af_len, manag_len, ts_len, method_len;
  int	data_len;
  int	total_len;

  if ( Smes == NULL ) return (0);

  dbg_len = my_strlen(eSmesGetSdebug(Smes));
  mid_len = my_strlen(eSmesGetSmid(Smes));
  from_len = my_strlen(eSmesGetSfrom(Smes));
  af_len = my_strlen(eSmesGetSAF(Smes));
  manag_len = my_strlen(eSmesGetSmanag(Smes));
  ts_len = my_strlen(eSmesGetSts(Smes));
  method_len = my_strlen(eSmesGetSmethod(Smes));
  data_len = my_strlen(eSmesGetSdata(Smes));

  total_len = SDATA_INDEX + 4 + 4 /* type */ + dbg_len
              + mid_len + from_len
              + 4 + 4 /* mflag */ + af_len + manag_len
              + ts_len + method_len + data_len;

  return (total_len);
}


/*
 * set_Smes_to_array()
 */
static
void
set_Smes_to_array(char *Sp, SMessage Smes)
{
  char	*dbg, *mid, *from, *af, *manag, *ts, *method, *data;
  int	dbg_len, mid_len, from_len, af_len, manag_len;
  int	ts_len, method_len, data_len;
  long	ofset, type, mflag;

  if ( Smes == NULL ) return;

  dbg = eSmesGetSdebug(Smes);
  mid = eSmesGetSmid(Smes);
  from = eSmesGetSfrom(Smes);
  af = eSmesGetSAF(Smes);
  manag = eSmesGetSmanag(Smes);
  ts = eSmesGetSts(Smes);
  method = eSmesGetSmethod(Smes);
  data = eSmesGetSdata(Smes);

  dbg_len = my_strlen(dbg);
  mid_len = my_strlen(mid);
  from_len = my_strlen(from);
  af_len = my_strlen(af);
  manag_len = my_strlen(manag);
  ts_len = my_strlen(ts);
  method_len = my_strlen(method);
  data_len = my_strlen(data);

  /* type */
  ofset = SMFLAG_INDEX + 4L;
  type = eSmesGetStype(Smes);
  set_integer_to_array(Sp, 0, ofset, type);

  /* method flag */
  ofset += 4;
  mflag = eSmesGetSmflag(Smes);
  set_integer_to_array(Sp, SMFLAG_INDEX, ofset, mflag);

  /* debug */
  ofset += 4;
  set_string_to_array(Sp, SDEBUG_INDEX, ofset, dbg, dbg_len);

  /* Mid */
  ofset += dbg_len;
  set_string_to_array(Sp, SMID_INDEX, ofset, mid, mid_len);

  /* from */
  ofset += mid_len;
  set_string_to_array(Sp, SFROM_INDEX, ofset, from, from_len);

  /* to_AF */
  ofset += from_len;
  set_string_to_array(Sp, SAF_INDEX, ofset, af, af_len);

  /* to_management */
  ofset += af_len;
  set_string_to_array(Sp, SMANAG_INDEX, ofset, manag, manag_len);

  /* ts */
  ofset += manag_len;
  set_string_to_array(Sp, STS_INDEX, ofset, ts, ts_len);

  /* method */
  ofset += ts_len;
  set_string_to_array(Sp, SMETHOD_INDEX, ofset, method, method_len);

  /* data */
  ofset += method_len;
  set_string_to_array(Sp, SDATA_INDEX, ofset, data, data_len);

  return;
}


/*
 * set_integer_to_array()
 */
static
void
set_integer_to_array(char *Sp, int index, long ofset, int integer)
{
  long	net_ofset, net_integer;

  net_ofset = htonl(ofset);
  net_integer = htonl((long)integer);
  bcopy((char*)(&net_ofset), &(Sp[index]), 4);
  bcopy((char*)(&net_integer), &(Sp[ofset]), 4);
}


/*
 * set_string_to_array()
 */
static
void
set_string_to_array(char *Sp, int index, long ofset, char *str, int len)
{
  long	net_ofset;

  net_ofset = htonl(ofset);
  bcopy((char*)(&net_ofset), &(Sp[index]), 4);
  if ( str == NULL ) {
    bcopy( "", &(Sp[ofset]), len);
  }
  else {
    bcopy(str, &(Sp[ofset]), len);
  }
}


/*
 *
 */
static
char*
get_string_from_array(char *Ames, int index)
{
  char	*p;
  long	ofset, net_ofset;

  net_ofset = *(long*)(&(Ames[index]));
  ofset = ntohl(net_ofset);

  p = &(Ames[ofset]);
  if ( *p == NULL ) return (NULL);
  return (p);
}


/*
 * get_Smes_int_from_array()
 */
static
int
get_Smes_int_from_array(char *Ames, int index)
{
  long	SmesOfset, ofset, net_ofset, net_integer;
  int	integer;

  SmesOfset = eAmesGetSmesOfset(Ames);
  if ( SmesOfset == 0L ) return (-1);
  net_ofset = *(long*)(&(Ames[SmesOfset+index]));
  ofset = ntohl(net_ofset);
  net_integer = *(long*)(&(Ames[SmesOfset+ofset]));
  integer = (int)ntohl(net_integer);

  return (integer);
}


/*
 * get_Smes_content_from_array()
 */
static
char*
get_Smes_content_from_array(char *Ames, int index)
{
  long	SmesOfset, ofset, net_ofset;
  char	*p;

  SmesOfset = eAmesGetSmesOfset(Ames);
  if ( SmesOfset == 0L ) return (NULL);
  net_ofset = *(long*)(&(Ames[SmesOfset+index]));
  ofset = ntohl(net_ofset);
  p = (char*)(&(Ames[SmesOfset+ofset]));

  if ( *p == NULL ) return (NULL);
  return (p);
}


/*
 * my_strlen()
 */
static
long
my_strlen(char *str)
{
  if ( str == NULL ) return (1);

  return ( strlen(str)+1 );
}

/*** END OF FILE ***/
