/*
 * file name: eAidObj.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	<helios/envdef.h>
#include	"eAidObj.h"
#include	"eUtil.h"


/*
 * eAidObjNew()
 */
void*
eAidObjNew(char *env, char *Aid)
{
  AidObj	*op;

  op = (AidObj*)malloc( sizeof(AidObj) );
  if ( op == NULL ) return (NULL);

  if ( eUtilSetString(&(op->env), env) == EALLOC )
    return (NULL);

  if ( eUtilSetString(&(op->Aid), Aid) == EALLOC )
    return (NULL);

  op->upperAid = NULL;
  op->lowerAid = NULL;

  return (op);
}


/*
 * eAidObjDelete()
 */
void
eAidObjDelete(AidObj *target)
{
  if ( target == NULL ) return;
  if ( target->env != NULL ) free(target->env);
  if ( target->Aid != NULL )free(target->Aid);
  if ( target->upperAid != NULL ) free(target->upperAid);
  if ( target->lowerAid != NULL ) free(target->lowerAid);
  target->env = NULL;
  target->Aid = NULL;
  target->upperAid = NULL;
  target->lowerAid = NULL;
  free(target);
}


/*
 * eAidObjGetEnv()
 */
char*
eAidObjGetEnv(AidObj *target)
{
  return (target->env);
}


/*
 * eAidObjGetAid()
 */
char*
eAidObjGetAid(AidObj *target)
{
  return (target->Aid);
}


/*
 * eAidObjGetAidOfUpperEnv()
 */
char*
eAidObjGetAidOfUpperEnv(AidObj *target)
{
  return (target->upperAid);
}


/*
 * eAidObjGetAidOfLowerEnv()
 */
char*
eAidObjGetAidOfLowerEnv(AidObj *target)
{
  return (target->lowerAid);
}


/*
 * eAidObjSetAidOfUpperEnv()
 */
int
eAidObjSetAidOfUpperEnv(AidObj *target, char *upperAid)
{
  target->upperAid = (char*)malloc( strlen(upperAid) + 1 );
  if ( target->upperAid == NULL ) return (EALLOC);
  strcpy(target->upperAid, upperAid);
  return (NORMAL);
}


/*
 * eAidObjSetAidOfLowerEnv()
 */
int
eAidObjSetAidOfLowerEnv(AidObj *target, char *lowerAid)
{
  target->lowerAid = (char*)malloc( strlen(lowerAid) + 1 );
  if ( target->lowerAid == NULL ) return (EALLOC);
  strcpy(target->lowerAid, lowerAid);
  return (NORMAL);
}


/*
 * eAidObjMatch()
 */
int
eAidObjMatch(void *target, void *lookfor)
{
  if ( !strcmp(((AidObj*)target)->Aid, lookfor) ) return (TRUE);
  return (FALSE);
}


/*
 * eAidObjPrint()
 */
void
eAidObjPrint(void *target)
{
  AidObj	*op;

  op = target;
  fprintf(stderr, "\n   AidObj\n");
  fprintf(stderr, "env = %s\n", op->env);
  fprintf(stderr, "Aid = %s\n", op->Aid);
  fprintf(stderr, "upperAid = %s\n", op->upperAid);
  fprintf(stderr, "lowerAid = %s\n", op->lowerAid);
}

/*** END OF FILE ***/
