/*
 * file name: eAidAdm.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<helios/envdef.h>
#include	"eAidAdm.h"
#include	"ePAdm.h"
#include	"eQAdm.h"
#include	"eAidObj.h"
#include	"eUtil.h"



static	char	s_AidOfTopEnv[256];
static	char	s_AidOfBottomEnv[256];
static	char	s_AidOfCurrentEnv[256];
static	char*	s_myProcAid = NULL;
static	char*	s_myName = NULL;

/*
 * eAidAdmSetMyProcAid()
 */
int
eAidAdmSetMyProcAid(char *my_aid)
{
  return ( eUtilSetString(&s_myProcAid, my_aid) );
}


/*
 * eAidAdmSetMyName()
 */
int
eAidAdmSetMyName(char *name)
{
  return ( eUtilSetString(&s_myName, name) );
}


/*
 * eAidAdmInitHiaStruct()
 */
int
eAidAdmInitHiaStruct(int queueId)
{
  AidObj	*op, *opLow;
  char	*AidOfEnv;


  if ( (op = eQAdmGet(queueId)) == NULL ) return (ERROR);
  if ( eAidObjSetAidOfUpperEnv(op, "top") == EALLOC ) return (EALLOC);  
  strcpy(s_AidOfTopEnv, eAidObjGetAid(op));
  ePAdmPut(AIDOBJ_POOL, op);

  while ( (opLow = eQAdmGet(queueId)) != NULL ) {
    AidOfEnv = eAidObjGetAid(opLow);
    if ( eAidObjSetAidOfLowerEnv(op, AidOfEnv) == EALLOC ) return (EALLOC);
    AidOfEnv = eAidObjGetAid(op);
    if ( eAidObjSetAidOfUpperEnv(opLow, AidOfEnv) == EALLOC ) return (EALLOC);
    op = opLow;
    ePAdmPut(AIDOBJ_POOL, op);
  }
  if ( eAidObjSetAidOfLowerEnv(op, "bottom") == EALLOC ) return (EALLOC);
  strcpy(s_AidOfBottomEnv, eAidObjGetAid(op));

  /*
    eQPAdm queue entry must be deleted.   not implemented yet.
  */
  
  strcpy(s_AidOfCurrentEnv, s_AidOfBottomEnv);

  return (NORMAL);
}


/*
 * eAidAdmGetEnv()
 */
char*
eAidAdmGetEnv(char *Aid)
{
  AidObj	*op;

  op = ePAdmGet(AIDOBJ_POOL, Aid);
  if ( op == NULL ) return (NULL);

  ePAdmPut(AIDOBJ_POOL, op);
  return (op->env);
}

  
/*
 * eAidAdmGetAidOfUpperEnv()
 */
char*
eAidAdmGetAidOfUpperEnv(char *Aid)
{
  AidObj	*op;

  op = ePAdmGet(AIDOBJ_POOL, Aid);
  if ( op == NULL ) return (NULL);

  ePAdmPut(AIDOBJ_POOL, op);
  return (op->upperAid);
}


/*
 * eAidAdmGetAidOfLowerEnv()
 */
char*
eAidAdmGetAidOfLowerEnv(char *Aid)
{
  AidObj	*op;

  op = ePAdmGet(AIDOBJ_POOL, Aid);
  if ( op == NULL ) return (NULL);

  ePAdmPut(AIDOBJ_POOL, op);
  return (op->lowerAid);
}
  

/*
 * eAidAdmGetAidOfCurrentEnv()
 */
char*
eAidAdmGetAidOfCurrentEnv(void)
{
  return (s_AidOfCurrentEnv);
}


/*
 * eAidAdmGetMyProcAid()
 */
char*
eAidAdmGetMyProcAid(void)
{
  return (s_myProcAid);
}


/*
 * eAidAdmGetMyName()
 */
char*
eAidAdmGetMyName(void)
{
  return (s_myName);
}


/*
 * eAidAdmSetAidOfCurrentEnv()
 */
void
eAidAdmSetAidOfCurrentEnv(char *Aid)
{
  strcpy(s_AidOfCurrentEnv, Aid);
}


/*
 * eAidAdmMoveToAidOfUpperEnv()
 */
int
eAidAdmMoveToAidOfUpperEnv(void)
{
  AidObj	*op;
  char	*AidOfCurrentEnv;

  AidOfCurrentEnv = eAidAdmGetAidOfCurrentEnv();

  op = ePAdmGet(AIDOBJ_POOL, AidOfCurrentEnv);
  if ( op == NULL ) return (ERROR);
  ePAdmPut(AIDOBJ_POOL, op);

  if ( !strcmp("top", op->upperAid) ) return (TOP_ENV);

  eAidAdmSetAidOfCurrentEnv(op->upperAid);
  return (NORMAL);
}


/*
 * eAidAdmMoveToAidOfLowerEnv()
 */
int
eAidAdmMoveToAidOfLowerEnv(void)
{
  AidObj	*op;
  char	*AidOfCurrentEnv;

  AidOfCurrentEnv = eAidAdmGetAidOfCurrentEnv();

  op = ePAdmGet(AIDOBJ_POOL, AidOfCurrentEnv);
  if ( op == NULL ) return (ERROR);
  ePAdmPut(AIDOBJ_POOL, op);

  if ( !strcmp("bottom", op->lowerAid) ) return (BOTTOM_ENV);

  eAidAdmSetAidOfCurrentEnv(op->lowerAid);
  return (NORMAL);
}


/*
 * eAidAdmMoveToTopEnv()
 */
void
eAidAdmMoveToTopEnv(void)
{
  eAidAdmSetAidOfCurrentEnv(s_AidOfTopEnv);
}


/*
 * eAidOfMoveToBottomEnv()
 */
void
eAidAdmMoveToBottomEnv()
{
  eAidAdmSetAidOfCurrentEnv(s_AidOfBottomEnv);
}


/*** END OF FILE ***/
