/*
 * file name: eAgntDir.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<helios/envdef.h>
#include	<helios/HeAgSv.h>
#include	<helios/HeAgSvDef.h>
#include	<helios/HeAgSvFun.h>
#include	"eAgntDir.h"
#include	"eSMessage.h"
#include	"eSmes.h"
#include	"ePool.h"
#include	"eQueue.h"
#include	"eCandidateObj.h"
#include	"eUtil.h"



#define	LOGICAL_NAME_AND	"+"
#define DIFF			"-"


#ifdef	ENV_DEBUG
extern	int	dbg_flag;
#endif

/**********/
int	eNotSendObjMatch(void *target, void *lookfor);
void	eNotSendObjPrint(void *target);
/*********/

static	Pool*	s_candidate_pool = NULL;

static	char*	my_search_agent_id1(SMessage Smes, char *env, SMMid mid,
				    SMFrom from, SMTo to,
				    char *method, char **new_method,
				    SMessage *Smes_for_prm);
static	char*	my_search_agent_id2(SMessage Smes, char *env, SMMid mid,
				    SMFrom from, SMTo to,
				    char *method, char **new_method,
				    SMessage *Smes_for_prm);
static	void	reset_logical_name(SMessage Smes, char *logical_name);
static  void	reset_function_name(SMessage Smes, char *func, char *management);


/*
 * eAgntDirSearchAgentId()
 */
char*
eAgntDirSearchAgentId(SMessage Smes, char *env, SMMid mid,
                      SMFrom from, SMTo to, char *method,
		      char **new_method, SMessage *Smes_for_prm)
{
#ifndef	ENV_DEBUG
  char	*dummy;

  dummy = CSMGetToMethodStr(Smes);

  if ( !strncmp(LOGICAL_NAME_AND, eSmesGetSAF(Smes),
		strlen(LOGICAL_NAME_AND)) ) {
    return ( my_search_agent_id1(Smes, env, mid, from, 
				to, method, new_method, Smes_for_prm) );
  }
  else if ( !strncmp(DIFF, eSmesGetSAF(Smes),
		strlen(DIFF)) ) {
    return ( my_search_agent_id2(Smes, env, mid, from, 
				to, method, new_method, Smes_for_prm) );
  }

  *Smes_for_prm = NULL;
  return ( search_agent_id(env, mid, from, to, dummy, new_method) );

#else
  char	*dummy;

  dummy = CSMGetToMethodStr(Smes);

  if ( !strncmp(LOGICAL_NAME_AND, eSmesGetSAF(Smes),
		strlen(LOGICAL_NAME_AND)) ) {
    return ( my_search_agent_id1(Smes, env, mid, from, 
				to, method, new_method, Smes_for_prm) );
  }
  else if ( !strncmp(DIFF, eSmesGetSAF(Smes),
		strlen(DIFF)) ) {
    return ( my_search_agent_id2(Smes, env, mid, from, 
				to, method, new_method, Smes_for_prm) );
  }

  *Smes_for_prm = NULL;
  return ( search_agent_id(env, mid, from, to, dummy, new_method) );
#endif
}


/*
 * eAgntDirSearchLogicalName()
 */
char*
eAgntDirSearchLogicalName(char *env, char *aid)
{
  return ( search_logical_agent_name(env, aid) );
}


/*
 * my_search_agent_id1()
 *        for logical_name_and
 */
static
char*
my_search_agent_id1(SMessage Smes, char *env, SMMid mid,
		   SMFrom from, SMTo to, char *method,
		   char **new_method, SMessage *Smes_for_prm)
{
  SMessage	tmpSmes, SmesPrm = NULL;
  SMTo	tmpTo;
  CandidateObj	*op;
  char	*logical_name, *template_name, *instance_name;
  char	*candidate_aid, *dummy, *tmp1;

  dummy = CSMGetToMethodStr(Smes);

  if ( s_candidate_pool == NULL ) {
    s_candidate_pool = ePoolNew(eCandidateObjMatch,
				eCandidateObjPrint);
    if ( s_candidate_pool == NULL ) return (char*)ERROR;
  }

  op = ePoolGet(s_candidate_pool, (char*)mid);
  if ( op == NULL ) {
    op = eCandidateObjNew(mid);
    tmp1 = strdup(eSmesGetSAF(Smes));
    strtok(tmp1, " "); /* skip "&" */

    tmpSmes = eSmesDuplicate(Smes);

    /* get all of logical name  and put it in queue */
    while ( logical_name = strtok(NULL, " ") ) {
      if ( eUtilIsLogNameParam(logical_name) == TRUE ) {
	template_name = eUtilGetTemplateName(logical_name);
	instance_name = eUtilGetInstanceName(logical_name);
	reset_logical_name(tmpSmes, template_name);
	SmesPrm = eSmesDuplicate(Smes);
	reset_logical_name(SmesPrm, instance_name);
      }
      else {
	reset_logical_name(tmpSmes, logical_name);
      }
      tmpTo = eSmesGetSto(tmpSmes);
      candidate_aid = search_agent_id(env, mid, from, tmpTo,
				      dummy, new_method);
      if ( candidate_aid == NULL ) break;
      eCandidateObjPutAid(op, candidate_aid, SmesPrm);
      SmesPrm = NULL;
    }
    free(tmp1);
    eSmesDelete(tmpSmes);

    candidate_aid = eCandidateObjGetAid(op, Smes_for_prm);
    ePoolPut(s_candidate_pool, op);
    return  candidate_aid;
  }
  else {
    candidate_aid = eCandidateObjGetAid(op, Smes_for_prm);
    if ( candidate_aid == NULL ) {
      eCandidateObjDelete(op);
      return NULL;
    }
    else {
      ePoolPut(s_candidate_pool, op);
      return candidate_aid;
    }
  }
}


/*
 * my_search_agent_id2()
 *        for logical_name_and
 */
static
char*
my_search_agent_id2(SMessage Smes, char *env, SMMid mid,
		   SMFrom from, SMTo to, char *method,
		   char **new_method, SMessage *Smes_for_prm)
{
  Pool	*not_send_aid_pool = NULL;
  SMessage	tmpSmes, SmesPrm = NULL;
  SMTo	tmpTo;
  CandidateObj	*op;
  char	*logical_name, *template_name, *instance_name;
  char	*candidate_aid, *dummy, *tmpAF, *func;
  char	*not_send_aid, *management;

  dummy = CSMGetToMethodStr(Smes);
  management = eSmesGetSmanag(Smes);

  if ( s_candidate_pool == NULL ) {
    s_candidate_pool = ePoolNew(eCandidateObjMatch,
				eCandidateObjPrint);
    if ( s_candidate_pool == NULL ) return (char*)ERROR;
  }

  op = ePoolGet(s_candidate_pool, (char*)mid);
  if ( op == NULL ) {
    not_send_aid_pool = ePoolNew(eNotSendObjMatch, eNotSendObjPrint);
    op = eCandidateObjNew(mid);
    tmpAF = strdup(eSmesGetSAF(Smes));
    strtok(tmpAF, " "); /* skip "-" */
    func = strtok(NULL, " ");

    tmpSmes = eSmesDuplicate(Smes);

    /* get all of logical name  and put it in queue */
    while ( logical_name = strtok(NULL, " ") ) {
      reset_logical_name(tmpSmes, logical_name);
      tmpTo = eSmesGetSto(tmpSmes);
      not_send_aid = search_agent_id(env, mid, from, tmpTo,
				      dummy, new_method);
      if ( not_send_aid == NULL ) break;
      ePoolPut(not_send_aid_pool, not_send_aid);
    }

    reset_function_name(tmpSmes, func, management);

    while ( 1 ) {
      not_send_aid = NULL;
      tmpTo = eSmesGetSto(tmpSmes);
      candidate_aid = search_agent_id(env, mid, from, tmpTo,
				      dummy, new_method);
      if ( candidate_aid == NULL ) break;
      if ( (not_send_aid = ePoolGet(not_send_aid_pool, candidate_aid)) == NULL ) {
	eCandidateObjPutAid(op, candidate_aid, SmesPrm);
      }
      else {
	ePoolPut(not_send_aid_pool, not_send_aid);
	free(candidate_aid);
      }
      SmesPrm = NULL;
    }
    eSmesDelete(tmpSmes);

    free(tmpAF);
    while ( not_send_aid = ePoolGet(not_send_aid_pool, NULL) ) {
      free(not_send_aid);
      not_send_aid = NULL;
    }
    ePoolDelete(not_send_aid_pool);

    candidate_aid = eCandidateObjGetAid(op, Smes_for_prm);
    ePoolPut(s_candidate_pool, op);
    return  candidate_aid;
  }
  else {
    candidate_aid = eCandidateObjGetAid(op, Smes_for_prm);
    if ( candidate_aid == NULL ) {
      eCandidateObjDelete(op);
      return NULL;
    }
    else {
      ePoolPut(s_candidate_pool, op);
      return candidate_aid;
    }
  }
}


/*
 * reset_logical_name()
 */
static
void
reset_logical_name(SMessage Smes, char *logical_name)
{
  char	*AF, *management;

  AF = eSmesGetSAF(Smes);
  management = eSmesGetSmanag(Smes);
  if ( AF != NULL ) free(AF);
  if ( management != NULL ) free(management);

  eSmesSetSmanag(Smes, NULL);
  eSmesSetSAF(Smes, logical_name);
  return;
}


/*
 * reset_function_name()
 */
static
void
reset_function_name(SMessage Smes, char *func, char *management)
{
  char	*AF, *old_management;

  AF = eSmesGetSAF(Smes);
  old_management = eSmesGetSmanag(Smes);
  if ( AF != NULL ) free(AF);
  if ( old_management != NULL ) free(old_management);

  eSmesSetSmanag(Smes, management);
  eSmesSetSAF(Smes, func);
  return;
}


/*
 * eNotSendObjMatch()
 */
int
eNotSendObjMatch(void *target, void *lookfor)
{
  if ( !strcmp((char*)target, (char*)lookfor) ) return (TRUE);
  return FALSE;
}


/*
 * eNotSendObjPrint()
 */
void
eNotSendObjPrint(void *target)
{
  return;
}

/*** END OF FILE ***/
