/* hdUserInfo.c
 *	module to handle User interface information
 *		created by k3sato on July 21st in 1994.
 *
 *	modification history:	
 *	(1) add hdSetupAgentIdForUser() and its relations
 *		on October 3rd in '94.
 *
 * $Id: hdUserInfo.c,v 2.0 1994/12/08 13:28:09 k3sato Exp $
 */

#include <stdio.h>

#include <helios/heliosd.h>
#include <helios/hdMessage.h>
#include "hdSocket.h"
#include "hdcommon.h"

#define HdComponentMaxNum	4	/* changed from 6 in Oct. 3rd in '94
					   changed from 5 in Oct. 4th in '94
					 */
HdBoolean hdAppendUserInfo();
char *hdGetNextComponent();
HdBoolean hdSetupAgentIdForUser();

static HAgentInfo hdCreateUserInfo();


/* ==========================================================
 *	functions for the message of HdMsg_SetupUserInfo
 * ========================================================== */
/*
 *	$B%f!<%6!&%$%s%?%U%'!<%9$+$iAw$i$l$?(B
 *	$B%f!<%6!&%$%s%?%U%'!<%9$N>pJs$r@_Dj$9$k!#(B
 */
HdBoolean hdSetupUserInfo(hHdCtlInfo, userData)
    HHeliosdCtlInfo	hHdCtlInfo;
    char		*userData;
{
    HAgentInfo		userInfo;
    HeliosdErrorMsgType	eMsgType;

    if ((userInfo = hdCreateUserInfo(userData)) == NULL) {
	eMsgType = HdEMsg_CreateUserInfoError;
	goto Error_Rtn;
    }

    if (hdSetupAgentIdForUser(hHdCtlInfo, userInfo) == HdFalse) {
	eMsgType = HdEMsg_SetupAgentIdForUserError;
	goto Free_Error_Rtn;
    }

    if ((hdAppendUserInfo(hHdCtlInfo, userInfo)) == HdFalse) {
	eMsgType = HdEMsg_AppendUserInfoError;
	goto Free_Error_Rtn;
    }

    return HdTrue;

 Free_Error_Rtn:
    hdFreeAgentInfo(&userInfo);

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/* ==========================================================
 *	functions for the message of HdMsg_GetUserInfo
 * ========================================================== */
/*
 *	$B5/F0$5$l$F$$$k%f!<%6!&%$%s%?%U%'!<%9$N>pJs$N3MF@(B
 */
HdBoolean hdGetUserInfo(hHdCtlInfo, agentId)
    HHeliosdCtlInfo	hHdCtlInfo;
    char		*agentId;
{
    HeliosdErrorMsgType	eMsgType;

    eMsgType = HdEMsg_NotYetImplemented;
    goto Error_Rtn;

    return HdTrue;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/*
 *	Search userInfo for agentId
 */
HAgentInfo hdSearchUserInfo(userInfo, agentId)
    HAgentInfo		userInfo;
    char		*agentId;
{
    for (; userInfo != NULL
	 ; userInfo = userInfo->next) {
	if (strcmp(userInfo->agentId, agentId) == 0) {
	    return userInfo;
	}
    }

    return NULL;
}

/*
 * Setup user data into a AgentInfo structure.
 *
 *  component of user data;
 *	<agentId>:		# defined in heliosd (in Oct. 3rd in '94)
 *	<user login name>:	# strPtr[0]
 *	<host name>:		# strPtr[1]
 *	<sin_family>:		# strPtr[2]
 *	<sin_port>:		# defined in heliosd (in Oct. 4th in '94)
 *	<pid>			# strPtr[3]
 */
static HAgentInfo hdCreateUserInfo(userData)
    char		*userData;
{
    HAgentInfo		userInfo;
    char		*strPtr[HdComponentMaxNum];
    char		**currStrPtr;
    char		*nextStr;
    int			cnt;
    HeliosdErrorMsgType	eMsgType;

    if ((userInfo = (HAgentInfo)HdMalloc(sizeof(AgentInfo))) == NULL) {
	eMsgType = HdEMsg_HdMallocError;
	goto Error_Rtn;
    }

    for (currStrPtr = strPtr, *currStrPtr = userData, cnt = 1
	 ; cnt < HdComponentMaxNum
	 ; *(++currStrPtr) = nextStr, cnt++) {

	if ((nextStr = hdGetNextComponent(*currStrPtr)) == NULL) {
	    eMsgType = HdEMsg_GetNextComponentError;
	    goto Error_Rtn;
	}
    }

    currStrPtr = strPtr;

    if ((userInfo->agentName = HdMallocString(*(currStrPtr++))) == NULL) {
	eMsgType = HdEMsg_HdMallocStringError;
	goto Error_Rtn;
    }

    if ((userInfo->sockInfo.hostName = HdMallocString(*(currStrPtr++))) == NULL) {
	eMsgType = HdEMsg_HdMallocStringError;
	goto Error_Rtn;
    }

    userInfo->sockInfo.sin_family = HdStr2Int(*(currStrPtr++));
    userInfo->pid = HdStr2Int(*currStrPtr);
    userInfo->status = AS_Active;

    return userInfo;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return NULL;
}

/*
 * Get next component separated with colon(':')
 */
char *hdGetNextComponent(str)
    char	*str;
{
    for (; *str != NULL; str++) {
	if (*str == ':') {
	    *str++ = NULL;
	    return str;
	}
    }

    return NULL;
}

/*
 *	Setup agentId and sin_port for user
 *	and send the agentId to user
 */
HdBoolean hdSetupAgentIdForUser(hHdCtlInfo, userInfo)
    HHeliosdCtlInfo	hHdCtlInfo;
    HAgentInfo		userInfo;
{
    char		agentId[AgentIDLen_Lim];
    HeliosdErrorMsgType	eMsgType;

    sprintf(agentId, "%s_%d",
	    userInfo->sockInfo.hostName, hHdCtlInfo->nextUserId++);

    if ((userInfo->agentId = HdMallocString(agentId)) == NULL) {
	eMsgType = HdEMsg_HdMallocStringError;
	goto Error_Rtn;
    }

    if (hdSetPortNum2AgentInfo(hHdCtlInfo, userInfo) == HdFalse) {
	eMsgType = HdEMsg_SetPortNum2AgentInfoError;
	goto Error_Rtn;
    }

    sprintf(agentId, "%d %s %u",
	    HdMsg_UserAgentId, userInfo->agentId, userInfo->sockInfo.sin_port);

    if (hdSend2Socket(hHdCtlInfo, hHdCtlInfo->s, agentId) == HdFalse) {
	eMsgType = HdEMsg_SendMsg2Agent;
	goto Error_Rtn;
    }

    return HdTrue;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/*
 *	Append userInfo to hHdCtlInfo->userInfo
 */
HdBoolean hdAppendUserInfo(hHdCtlInfo, userInfo)
    HHeliosdCtlInfo	hHdCtlInfo;
    HAgentInfo		userInfo;
{
    HAgentInfo		*currInfo;

    for (currInfo = &(hHdCtlInfo->userInfo)
	 ; *currInfo != NULL
	 ; currInfo = &((*currInfo)->next))
      ;

    *currInfo = userInfo;

    return HdTrue;
}
